/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.blocks.tank;

import mcjty.efab.blocks.GenericEFabTile;
import mcjty.efab.blocks.ModBlocks;
import mcjty.efab.blocks.tank.EFabFluidTank;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TankTE
extends GenericEFabTile {
    private EFabFluidTank handler;
    private int capacity = this.getCapacity();
    private String clientFluidName = "";

    public FluidStack getFluid() {
        return this.getHandler().getFluid();
    }

    public String getClientFluidName() {
        return this.clientFluidName;
    }

    public FluidTank getHandler() {
        if (this.handler == null) {
            TileEntity te = this.func_145831_w().func_175625_s(this.field_174879_c.func_177977_b());
            if (te instanceof TankTE && ((TankTE)te).isAdvanced() == this.isAdvanced()) {
                TankTE tankTE = (TankTE)te;
                return tankTE.getHandler();
            }
            this.handler = new EFabFluidTank(this.capacity, this);
        }
        return this.handler;
    }

    public TankTE getBottomTank() {
        BlockPos bottomPos = this.field_174879_c;
        while (this.field_145850_b.func_180495_p(bottomPos.func_177977_b()).func_177230_c() == this.getTankBlock()) {
            bottomPos = bottomPos.func_177977_b();
        }
        TileEntity te = this.field_145850_b.func_175625_s(bottomPos);
        if (te instanceof TankTE) {
            return (TankTE)te;
        }
        return this;
    }

    public int getTankIndex() {
        int idx = 0;
        BlockPos bottomPos = this.field_174879_c;
        while (this.field_145850_b.func_180495_p(bottomPos.func_177977_b()).func_177230_c() == this.getTankBlock()) {
            bottomPos = bottomPos.func_177977_b();
            ++idx;
        }
        return idx;
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!world.field_72995_K) {
            BlockPos bottomPos = pos;
            while (world.func_180495_p(bottomPos.func_177977_b()).func_177230_c() == this.getTankBlock()) {
                bottomPos = bottomPos.func_177977_b();
            }
            if (world.func_180495_p(bottomPos.func_177984_a()).func_177230_c() == this.getTankBlock()) {
                BlockPos p = bottomPos;
                int cnt = 0;
                while (world.func_180495_p(p).func_177230_c() == this.getTankBlock()) {
                    ++cnt;
                    p = p.func_177984_a();
                }
                EFabFluidTank bottomHandler = new EFabFluidTank(this.getCapacity() * cnt, this);
                p = bottomPos;
                while (world.func_180495_p(p).func_177230_c() == this.getTankBlock()) {
                    TankTE te = (TankTE)world.func_175625_s(p);
                    te.markDirtyQuick();
                    if (te.handler != null) {
                        bottomHandler.fill(te.handler.getFluid(), true);
                    }
                    te.handler = null;
                    te.capacity = 0;
                    p = p.func_177984_a();
                }
                TankTE bottomTE = (TankTE)world.func_175625_s(bottomPos);
                bottomTE.handler = bottomHandler;
                bottomTE.capacity = this.getCapacity() * cnt;
            }
            this.markDirtyClient();
        }
    }

    public boolean isAdvanced() {
        return false;
    }

    public int getCapacity() {
        return ModBlocks.tankBlock.capacity;
    }

    public Block getTankBlock() {
        return ModBlocks.tankBlock;
    }

    public void onBlockBreak(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            BlockPos bottomPos = pos;
            while (world.func_180495_p(bottomPos.func_177977_b()).func_177230_c() == this.getTankBlock()) {
                bottomPos = bottomPos.func_177977_b();
            }
            if (world.func_180495_p(bottomPos.func_177984_a()).func_177230_c() == this.getTankBlock() || bottomPos.func_177984_a().equals((Object)pos)) {
                int accepted;
                TankTE bottomTE = (TankTE)world.func_175625_s(bottomPos);
                FluidStack drained = bottomTE.getHandler().drain(bottomTE.getHandler().getCapacity(), true);
                int cntBelow = pos.func_177956_o() - bottomPos.func_177956_o();
                if (cntBelow > 0) {
                    bottomTE.handler = new EFabFluidTank(cntBelow * this.getCapacity(), this);
                    bottomTE.capacity = cntBelow * this.getCapacity();
                    if (drained != null) {
                        accepted = bottomTE.handler.fill(drained, true);
                        drained.amount -= accepted;
                    }
                    bottomTE.markDirtyQuick();
                }
                this.handler = new EFabFluidTank(this.getCapacity(), this);
                this.capacity = this.getCapacity();
                if (drained != null && drained.amount > 0) {
                    accepted = this.handler.fill(drained, true);
                    drained.amount -= accepted;
                    this.markDirtyQuick();
                }
                Block block = world.func_180495_p(pos.func_177984_a()).func_177230_c();
                TileEntity te = world.func_175625_s(pos.func_177984_a());
                if (block == this.getTankBlock() && te instanceof TankTE) {
                    TankTE topTE = (TankTE)te;
                    BlockPos p = pos.func_177984_a();
                    int cnt = 0;
                    while (world.func_180495_p(p).func_177230_c() == this.getTankBlock()) {
                        ++cnt;
                        p = p.func_177984_a();
                    }
                    topTE.handler = new EFabFluidTank(cnt * this.getCapacity(), this);
                    topTE.capacity = cnt * this.getCapacity();
                    if (drained != null && drained.amount > 0) {
                        topTE.handler.fill(drained, true);
                    }
                    topTE.markDirtyQuick();
                }
            }
            this.markDirtyClient();
        }
    }

    public void writeClientDataToNBT(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        if (this.getFluid() == null) {
            tagCompound.func_74778_a("fluidName", "");
        } else {
            tagCompound.func_74778_a("fluidName", this.getFluid().getLocalizedName());
        }
    }

    public void readClientDataFromNBT(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        String fluidName = tagCompound.func_74779_i("fluidName");
        this.setClientFluidName(fluidName);
    }

    private void setClientFluidName(String fluidName) {
        this.clientFluidName = fluidName;
        BlockPos p = this.field_174879_c;
        if (p == null || this.field_145850_b == null) {
            return;
        }
        while (this.field_145850_b.func_180495_p(p.func_177977_b()) == this.getTankBlock()) {
            p = p.func_177977_b();
        }
        while (true) {
            Block block = this.field_145850_b.func_180495_p(p).func_177230_c();
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (block != this.getTankBlock() || !(te instanceof TankTE)) break;
            ((TankTE)te).clientFluidName = fluidName;
            p = p.func_177984_a();
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.capacity = tagCompound.func_74762_e("capacity");
        this.handler = this.capacity > 0 ? new EFabFluidTank(this.capacity, this) : null;
        if (tagCompound.func_74764_b("fluid") && this.handler != null) {
            this.handler.readFromNBT(tagCompound.func_74775_l("fluid"));
            if (this.getFluid() != null && this.getFluid().amount > 0) {
                this.setClientFluidName(this.getFluid().getLocalizedName());
            }
        }
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("capacity", this.capacity);
        if (this.handler != null && this.capacity > 0 && this.handler.getFluid() != null && this.handler.getFluid().amount > 0) {
            NBTTagCompound fluidTc = new NBTTagCompound();
            this.handler.writeToNBT(fluidTc);
            tagCompound.func_74782_a("fluid", (NBTBase)fluidTc);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.getHandler());
        }
        return (T)super.getCapability(capability, facing);
    }
}

