/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.blocks.tank;

import java.util.Collections;
import java.util.List;
import mcjty.efab.blocks.tank.TankTE;
import mcjty.lib.client.HudRenderHelper;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;

public class TankRenderer
extends TileEntitySpecialRenderer<TankTE> {
    public void render(TankTE te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Block blockBelow;
        super.func_192841_a((TileEntity)te, x, y, z, partialTicks, destroyStage, alpha);
        if (te.func_145831_w().func_175623_d(te.func_174877_v())) {
            return;
        }
        Block block = te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c();
        if (block != (blockBelow = te.func_145831_w().func_180495_p(te.func_174877_v().func_177977_b()).func_177230_c())) {
            TankRenderer.renderHud(te, x, y, z);
        }
    }

    public static void renderHud(TankTE tankTE, double x, double y, double z) {
        float scale = 1.1f;
        String name = tankTE.getClientFluidName();
        if (name.length() >= 16) {
            scale = 0.5f;
        } else if (name.length() >= 12) {
            scale = 0.6f;
        } else if (name.length() >= 8) {
            scale = 0.8f;
        }
        List<String> log = Collections.singletonList(TextFormatting.DARK_GRAY + name);
        EnumFacing orientation = OrientationTools.getOrientationHoriz((IBlockState)Minecraft.func_71410_x().field_71441_e.func_180495_p(tankTE.func_174877_v()));
        HudRenderHelper.HudPlacement hudPlacement = HudRenderHelper.HudPlacement.HUD_FRONT;
        HudRenderHelper.HudOrientation hudOrientation = HudRenderHelper.HudOrientation.HUD_SOUTH;
        TankRenderer.renderHud(log, hudPlacement, hudOrientation, orientation, x, y, z, scale);
    }

    public static void renderHud(List<String> messages, HudRenderHelper.HudPlacement hudPlacement, HudRenderHelper.HudOrientation hudOrientation, EnumFacing orientation, double x, double y, double z, float scale) {
        GlStateManager.func_179094_E();
        if (hudPlacement == HudRenderHelper.HudPlacement.HUD_FRONT) {
            GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.75f), (float)((float)z + 0.5f));
        } else if (hudPlacement == HudRenderHelper.HudPlacement.HUD_CENTER) {
            GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        } else {
            GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.75f), (float)((float)z + 0.5f));
        }
        switch (hudOrientation) {
            case HUD_SOUTH: {
                GlStateManager.func_179114_b((float)(-TankRenderer.getHudAngle(orientation)), (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case HUD_TOPLAYER_HORIZ: {
                GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case HUD_TOPLAYER: {
                GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)Minecraft.func_71410_x().func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        if (hudPlacement == HudRenderHelper.HudPlacement.HUD_FRONT || hudPlacement == HudRenderHelper.HudPlacement.HUD_ABOVE_FRONT) {
            GlStateManager.func_179137_b((double)0.28f, (double)-0.75, (double)0.4325);
        } else if (hudPlacement != HudRenderHelper.HudPlacement.HUD_CENTER) {
            GlStateManager.func_179137_b((double)0.0, (double)-0.25, (double)-0.03749999999999998);
        }
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        TankRenderer.renderText(Minecraft.func_71410_x().field_71466_p, messages, 11, scale);
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        GlStateManager.func_179145_e();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179121_F();
    }

    private static float getHudAngle(EnumFacing orientation) {
        float f3 = 0.0f;
        if (orientation != null) {
            switch (orientation) {
                case NORTH: {
                    f3 = 180.0f;
                    break;
                }
                case WEST: {
                    f3 = 90.0f;
                    break;
                }
                case EAST: {
                    f3 = -90.0f;
                    break;
                }
                default: {
                    f3 = 0.0f;
                }
            }
        }
        return f3;
    }

    private static void renderText(FontRenderer fontrenderer, List<String> messages, int lines, float scale) {
        GlStateManager.func_179109_b((float)-0.5f, (float)0.5f, (float)0.07f);
        float f3 = 0.0075f;
        GlStateManager.func_179152_a((float)(f3 * scale), (float)(-f3 * scale), (float)f3);
        GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TankRenderer.renderLog(fontrenderer, messages, lines);
    }

    private static void renderLog(FontRenderer fontrenderer, List<String> messages, int lines) {
        int currenty = 7;
        int height = 10;
        int logsize = messages.size();
        int i = 0;
        for (String s : messages) {
            if (i >= logsize - lines && currenty + height <= 124) {
                fontrenderer.func_78276_b(fontrenderer.func_78269_a(s, 115), 7, currenty, 0xFFFFFF);
                currenty += height;
            }
            ++i;
        }
    }

    public static enum HudOrientation {
        HUD_SOUTH,
        HUD_TOPLAYER_HORIZ,
        HUD_TOPLAYER;

    }

    public static enum HudPlacement {
        HUD_ABOVE,
        HUD_ABOVE_FRONT,
        HUD_FRONT,
        HUD_CENTER;

    }
}

