/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.blocks.tank;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.efab.blocks.GenericEFabMultiBlockPart;
import mcjty.efab.blocks.tank.EnumTankState;
import mcjty.efab.blocks.tank.TankItemBlock;
import mcjty.efab.blocks.tank.TankRenderer;
import mcjty.efab.blocks.tank.TankTE;
import mcjty.efab.tools.FluidTools;
import mcjty.efab.tools.InventoryHelper;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.EmptyContainer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TankBlock
extends GenericEFabMultiBlockPart<TankTE, EmptyContainer> {
    public static final AxisAlignedBB EMPTY = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final PropertyEnum<EnumTankState> STATE = PropertyEnum.func_177706_a((String)"state", EnumTankState.class, (Enum[])EnumTankState.values());
    public final int capacity;

    public TankBlock(String name, int capacity, Class<? extends TankTE> clazz) {
        super(Material.field_151573_f, clazz, EmptyContainer::new, TankItemBlock::new, name, false);
        this.capacity = capacity;
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.HORIZROTATION;
    }

    public void func_190948_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound tagCompound;
        FluidStack fluid;
        super.func_190948_a(stack, playerIn, tooltip, advanced);
        tooltip.add(TextFormatting.WHITE + "This tank can store " + TextFormatting.GREEN + this.capacity + TextFormatting.WHITE + " mb");
        tooltip.add(TextFormatting.WHITE + "Combine tanks by placing them");
        tooltip.add(TextFormatting.WHITE + "on top of each other");
        tooltip.add(TextFormatting.WHITE + "Used for " + TextFormatting.GREEN + "liquid" + TextFormatting.WHITE + " and " + TextFormatting.GREEN + "steam" + TextFormatting.WHITE + " crafting");
        if (stack.func_77942_o() && (fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)(tagCompound = stack.func_77978_p()).func_74775_l("fluid"))) != null) {
            tooltip.add(TextFormatting.GRAY + "Fluid: " + TextFormatting.BLUE + fluid.amount + "mb (" + fluid.getLocalizedName() + ")");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
        ClientRegistry.bindTileEntitySpecialRenderer(TankTE.class, (TileEntitySpecialRenderer)new TankRenderer());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return EMPTY;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TankTE) {
                FluidStack fluid;
                TankTE tankTE = (TankTE)te;
                if (!heldItem.func_190926_b()) {
                    if (FluidTools.isEmptyContainer(heldItem)) {
                        this.extractIntoContainer(player, tankTE);
                        return true;
                    }
                    if (FluidTools.isFilledContainer(heldItem)) {
                        this.fillFromContainer(player, world, tankTE);
                        return true;
                    }
                }
                if ((fluid = tankTE.getFluid()) == null || fluid.amount <= 0) {
                    TextComponentString component = new TextComponentString("Tank is empty");
                    player.func_146105_b((ITextComponent)component, false);
                } else {
                    TextComponentString component = new TextComponentString("Tank contains " + fluid.amount + "mb of " + fluid.getLocalizedName());
                    player.func_146105_b((ITextComponent)component, false);
                }
            }
        }
        return true;
    }

    private void fillFromContainer(EntityPlayer player, World world, TankTE tank) {
        int filled;
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            return;
        }
        ItemStack container = heldItem.func_77946_l().func_77979_a(1);
        FluidStack fluidStack = FluidTools.convertBucketToFluid(container);
        if (fluidStack != null && (filled = tank.getHandler().fill(fluidStack, false)) == fluidStack.amount) {
            tank.getHandler().fill(fluidStack, true);
            tank.getBottomTank().markDirtyClient();
            if (!player.field_71075_bZ.field_75098_d) {
                heldItem.func_77979_a(1);
                ItemStack emptyContainer = FluidTools.drainContainer(container);
                InventoryHelper.giveItemToPlayer(player, emptyContainer);
            }
        }
    }

    private void extractIntoContainer(EntityPlayer player, TankTE tank) {
        FluidStack drained = tank.getHandler().drain(1, false);
        if (drained != null) {
            ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
            if (heldItem.func_190926_b()) {
                return;
            }
            ItemStack container = heldItem.func_77946_l().func_77979_a(1);
            int capacity = FluidTools.getCapacity(drained, container);
            if (capacity != 0 && (drained = tank.getHandler().drain(capacity, false)) != null && drained.amount == capacity) {
                tank.getHandler().drain(capacity, true);
                tank.getBottomTank().markDirtyClient();
                ItemStack filledContainer = FluidTools.fillContainer(drained, container);
                if (!filledContainer.func_190926_b()) {
                    heldItem.func_77979_a(1);
                    InventoryHelper.giveItemToPlayer(player, filledContainer);
                }
            }
            player.field_71070_bA.func_75142_b();
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, blockIn, fromPos);
        world.func_175704_b(pos, pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState metadata, int fortune) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TankTE) {
            TankTE bottomTank = ((TankTE)tileEntity).getBottomTank();
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this));
            NBTTagCompound tagCompound = new NBTTagCompound();
            bottomTank.writeRestorableToNBT(tagCompound);
            if (tagCompound.func_74764_b("fluid")) {
                tagCompound.func_74768_a("capacity", this.capacity);
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound.func_74775_l("fluid"));
                if (fluid != null) {
                    int totalamount = bottomTank.getFluid().amount;
                    for (int index = ((TankTE)tileEntity).getTankIndex(); index > 0; --index) {
                        totalamount -= this.capacity;
                    }
                    if (totalamount < 0) {
                        totalamount = 0;
                    } else if (totalamount > this.capacity) {
                        totalamount = this.capacity;
                    }
                    if (fluid.amount > totalamount) {
                        fluid.amount = totalamount;
                    }
                    if (fluid.amount > 0) {
                        tagCompound.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
                        fluid.writeToNBT(tagCompound.func_74775_l("fluid"));
                    } else {
                        tagCompound.func_82580_o("fluid");
                    }
                }
            }
            stack.func_77982_d(tagCompound);
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            result.add(stack);
            return result;
        }
        return Collections.emptyList();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean tankDown;
        boolean tankUp = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this;
        boolean bl = tankDown = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        EnumTankState s = tankUp && tankDown ? EnumTankState.MIDDLE : (tankUp ? EnumTankState.BOTTOM : (tankDown ? EnumTankState.TOP : EnumTankState.FULL));
        return state.func_177226_a(STATE, (Comparable)((Object)s));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING_HORIZ, STATE});
    }
}

