/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.blocks.storage;

import java.util.List;
import java.util.function.BiFunction;
import mcjty.efab.blocks.GenericEFabMultiBlockPart;
import mcjty.efab.blocks.storage.StorageContainer;
import mcjty.efab.blocks.storage.StorageGui;
import mcjty.efab.blocks.storage.StorageTE;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StorageBlock
extends GenericEFabMultiBlockPart<StorageTE, StorageContainer> {
    public StorageBlock() {
        super(Material.field_151573_f, StorageTE.class, StorageContainer::new, "storage", true);
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.HORIZROTATION;
    }

    public void func_190948_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, playerIn, tooltip, advanced);
        tooltip.add(TextFormatting.WHITE + "This block can store items for");
        tooltip.add(TextFormatting.WHITE + "usage with the " + TextFormatting.GREEN + "crafter");
        tooltip.add(TextFormatting.GOLD + "If you give this storage a name it will only");
        tooltip.add(TextFormatting.GOLD + "pull items from item storages with the same name!");
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        StorageTE storageTE;
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof StorageTE && (storageTE = (StorageTE)te).getCraftingName() != null && !storageTE.getCraftingName().trim().isEmpty()) {
            probeInfo.text(TextStyleClass.LABEL + "Name " + TextStyleClass.INFO + storageTE.getCraftingName());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BiFunction<StorageTE, StorageContainer, GenericGuiContainer<? super StorageTE>> getGuiFactory() {
        return StorageGui::new;
    }

    @Override
    public int getGuiID() {
        return 1;
    }
}

