/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.blocks.rfcontrol;

import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import mcjty.efab.blocks.GenericEFabTile;
import mcjty.efab.blocks.IEFabEnergyStorage;
import mcjty.efab.config.GeneralConfiguration;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyProvider", modid="redstoneflux"), @Optional.Interface(iface="cofh.redstoneflux.api.IEnergyReceiver", modid="redstoneflux")})
public class RfControlTE
extends GenericEFabTile
implements IEnergyProvider,
IEnergyReceiver,
IEFabEnergyStorage,
ITickable {
    private int energy = 0;
    private int sparks = -1;
    private IEnergyStorage handler = null;

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.energy = tagCompound.func_74762_e("energy");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("energy", this.energy);
    }

    @Override
    public boolean extractEnergy(int amount) {
        if (amount > this.energy) {
            return false;
        }
        this.energy -= amount;
        this.markDirtyQuick();
        return true;
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            if (this.sparks > 0) {
                --this.sparks;
            } else if (this.sparks == 0) {
                --this.sparks;
                this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
            }
        }
    }

    public boolean hasSpark() {
        return this.sparks >= 0;
    }

    public void setSpark(int s) {
        this.sparks = s;
        this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    @Override
    public int getMaxInternalConsumption() {
        return GeneralConfiguration.rfControlMax;
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.receiveEnergyInternal(maxReceive, simulate);
    }

    private int receiveEnergyInternal(int maxReceive, boolean simulate) {
        int toreceive = Math.min(maxReceive, GeneralConfiguration.rfControlInputPerTick);
        int newenergy = this.energy + toreceive;
        if (newenergy > GeneralConfiguration.rfControlMax) {
            toreceive -= newenergy - GeneralConfiguration.rfControlMax;
            newenergy = GeneralConfiguration.rfControlMax;
        }
        if (!simulate && this.energy != newenergy) {
            this.energy = newenergy;
            this.markDirtyQuick();
        }
        return toreceive;
    }

    @Override
    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(EnumFacing from) {
        return this.energy;
    }

    @Override
    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(EnumFacing from) {
        return GeneralConfiguration.rfControlMax;
    }

    @Optional.Method(modid="redstoneflux")
    public boolean canConnectEnergy(EnumFacing from) {
        return from != EnumFacing.UP;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            if (this.handler == null) {
                this.handler = new IEnergyStorage(){

                    public int receiveEnergy(int maxReceive, boolean simulate) {
                        return RfControlTE.this.receiveEnergyInternal(maxReceive, simulate);
                    }

                    public int extractEnergy(int maxExtract, boolean simulate) {
                        return 0;
                    }

                    public int getEnergyStored() {
                        return RfControlTE.this.energy;
                    }

                    public int getMaxEnergyStored() {
                        return GeneralConfiguration.rfControlMax;
                    }

                    public boolean canExtract() {
                        return false;
                    }

                    public boolean canReceive() {
                        return true;
                    }
                };
            }
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.handler);
        }
        return (T)super.getCapability(capability, facing);
    }
}

