/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.blocks.monitor;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.efab.blocks.GenericEFabTile;
import mcjty.efab.blocks.ISpeedBooster;
import mcjty.efab.blocks.monitor.IMonitor;
import mcjty.efab.config.GeneralConfiguration;
import mcjty.efab.network.PacketGetMonitorText;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public abstract class AbstractMonitorTE
extends GenericEFabTile
implements ITickable,
ISpeedBooster,
IMonitor {
    private float speed = 1.0f;
    private int speedBoost = 0;
    private long lastHudTime = 0L;
    private List<String> clientHudLog = new ArrayList<String>();
    protected List<String> messages = null;

    @Override
    public float getSpeed() {
        return this.speed;
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = speed;
        this.markDirtyClient();
    }

    @Override
    public int getSpeedBoost() {
        return this.speedBoost;
    }

    @Override
    public void setSpeedBoost(int speedBoost) {
        this.speedBoost = speedBoost;
        this.markDirtyClient();
    }

    @Override
    public BlockPos getMonitorPos() {
        return this.field_174879_c;
    }

    public void func_73660_a() {
        if (this.speed > 1.0f) {
            this.speed -= GeneralConfiguration.steamWheelSpinDown;
            if (this.speed < 1.0f) {
                this.speed = 1.0f;
            }
            this.markDirtyQuick();
        }
        if (this.speedBoost > 0) {
            --this.speedBoost;
            this.speed += GeneralConfiguration.steamWheelSpeedUp;
            if (this.speed > GeneralConfiguration.maxSteamWheelSpeed) {
                this.speed = GeneralConfiguration.maxSteamWheelSpeed;
            }
            this.markDirtyQuick();
        }
    }

    @Override
    public List<String> getClientLog() {
        return this.clientHudLog;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastHudTime;
    }

    @Override
    public void setLastUpdateTime(long t) {
        this.lastHudTime = t;
    }

    protected List<String> getMessages() {
        if (this.messages == null) {
            this.messages = new ArrayList<String>();
            this.getDefaultMessages(this.messages);
        }
        return this.messages;
    }

    protected abstract void getDefaultMessages(List<String> var1);

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.speed = tagCompound.func_74760_g("speed");
        this.speedBoost = tagCompound.func_74762_e("boost");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74776_a("speed", this.speed);
        tagCompound.func_74768_a("boost", this.speedBoost);
        return super.func_189515_b(tagCompound);
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if (PacketGetMonitorText.CMD_GETMESSAGES.equals(command)) {
            return type.convert(this.getMessages());
        }
        return rc;
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if (PacketGetMonitorText.CLIENTCMD_GETMESSAGES.equals(command)) {
            this.clientHudLog = Type.STRING.convert(list);
            return true;
        }
        return false;
    }
}

