/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.blocks.manareceptacle;

import mcjty.efab.blocks.GenericEFabTile;
import mcjty.efab.blocks.ISpeedBooster;
import mcjty.efab.config.GeneralConfiguration;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import vazkii.botania.api.mana.IManaReceiver;

public class ManaReceptacleTE
extends GenericEFabTile
implements IManaReceiver,
ITickable,
ISpeedBooster {
    private int mana = 0;
    private float speed = 1.0f;
    private int speedBoost = 0;

    @Override
    public float getSpeed() {
        return this.speed;
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = speed;
        this.markDirtyClient();
    }

    @Override
    public int getSpeedBoost() {
        return this.speedBoost;
    }

    @Override
    public void setSpeedBoost(int speedBoost) {
        this.speedBoost = speedBoost;
        this.markDirtyClient();
    }

    public void func_73660_a() {
        if (this.speed > 1.0f) {
            this.speed -= GeneralConfiguration.manaRotationSpinDown;
            if (this.speed < 1.0f) {
                this.speed = 1.0f;
            }
            this.markDirtyQuick();
        }
        if (this.speedBoost > 0) {
            --this.speedBoost;
            this.speed += GeneralConfiguration.manaRotationSpeedUp;
            if (this.speed > GeneralConfiguration.maxManaRotationSpeed) {
                this.speed = GeneralConfiguration.maxManaRotationSpeed;
            }
            this.markDirtyQuick();
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.speed = tagCompound.func_74760_g("speed");
        this.speedBoost = tagCompound.func_74762_e("boost");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74776_a("speed", this.speed);
        tagCompound.func_74768_a("boost", this.speedBoost);
        return super.func_189515_b(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.mana = tagCompound.func_74762_e("mana");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("mana", this.mana);
    }

    public boolean isFull() {
        return this.mana >= GeneralConfiguration.maxMana;
    }

    public void recieveMana(int mana) {
        this.mana = Math.min(GeneralConfiguration.maxMana, this.mana + mana);
        this.markDirtyQuick();
    }

    public void consumeMana(int mana) {
        this.mana = Math.max(0, this.mana - mana);
        this.markDirtyQuick();
    }

    public boolean canRecieveManaFromBursts() {
        return !this.isFull();
    }

    public int getCurrentMana() {
        return this.mana;
    }
}

