/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.blocks.grid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.efab.EFab;
import mcjty.efab.blocks.GenericEFabMultiBlockPart;
import mcjty.efab.blocks.IEFabEnergyStorage;
import mcjty.efab.blocks.ISpeedBooster;
import mcjty.efab.blocks.ModBlocks;
import mcjty.efab.blocks.boiler.BoilerTE;
import mcjty.efab.blocks.crafter.CrafterTE;
import mcjty.efab.blocks.grid.GridContainer;
import mcjty.efab.blocks.grid.GridCrafterHelper;
import mcjty.efab.blocks.grid.MInteger;
import mcjty.efab.blocks.monitor.AutoCraftingMonitorTE;
import mcjty.efab.blocks.monitor.MonitorTE;
import mcjty.efab.blocks.rfcontrol.RfControlTE;
import mcjty.efab.blocks.storage.StorageTE;
import mcjty.efab.blocks.tank.TankBlock;
import mcjty.efab.blocks.tank.TankTE;
import mcjty.efab.compat.botania.BotaniaSupportSetup;
import mcjty.efab.config.GeneralConfiguration;
import mcjty.efab.items.UpgradeItem;
import mcjty.efab.recipes.IEFabRecipe;
import mcjty.efab.recipes.RecipeTier;
import mcjty.efab.sound.SoundController;
import mcjty.lib.bindings.DefaultAction;
import mcjty.lib.bindings.IAction;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.NullSidedInvWrapper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.oredict.OreDictionary;

public class GridTE
extends GenericTileEntity
implements DefaultSidedInventory,
ITickable {
    private static final int[] SLOTS = new int[]{9, 10, 11};
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, GridContainer.factory, 22);
    public static final String ACTION_CRAFT = "craft";
    public static final String ACTION_CRAFT_REPEAT = "craftRepeat";
    public static final String ACTION_LEFT = "left";
    public static final String ACTION_RIGHT = "right";
    private MInteger ticksRemaining = new MInteger(-1);
    private int totalTicks = 0;
    private int errorTicks = 0;
    private boolean repeat = false;
    private int rfWarning = 0;
    private int manaWarning = 0;
    private int crafterDelay = 0;
    private List<String> errorsFromServer = Collections.emptyList();
    private List<String> usageFromServer = Collections.emptyList();
    private boolean dirty = true;
    private final Set<BlockPos> boilers = new HashSet<BlockPos>();
    private final Set<BlockPos> steamEngines = new HashSet<BlockPos>();
    private final Set<BlockPos> tanks = new HashSet<BlockPos>();
    private final Set<BlockPos> gearBoxes = new HashSet<BlockPos>();
    private final Set<BlockPos> rfControls = new HashSet<BlockPos>();
    private final Set<BlockPos> rfStorBasic = new HashSet<BlockPos>();
    private final Set<BlockPos> rfStorDense = new HashSet<BlockPos>();
    private final Set<BlockPos> manaReceptacles = new HashSet<BlockPos>();
    private final Set<BlockPos> processors = new HashSet<BlockPos>();
    private final Set<BlockPos> pipes = new HashSet<BlockPos>();
    private final Set<BlockPos> monitors = new HashSet<BlockPos>();
    private final Set<BlockPos> autoMonitors = new HashSet<BlockPos>();
    private final Set<BlockPos> crafters = new HashSet<BlockPos>();
    private final Set<BlockPos> storages = new HashSet<BlockPos>();
    private final Set<BlockPos> powerOptimizers = new HashSet<BlockPos>();
    private boolean isMaster = false;
    private Set<RecipeTier> supportedTiers = null;
    private final GridCrafterHelper crafterHelper = new GridCrafterHelper((IInventory)this);
    private String[] craftingStatus = new String[]{"", ""};
    private Random random = new Random();

    public IAction[] getActions() {
        return new IAction[]{new DefaultAction(ACTION_CRAFT, () -> this.startCraft(false)), new DefaultAction(ACTION_CRAFT_REPEAT, () -> this.startCraft(true)), new DefaultAction(ACTION_LEFT, this::left), new DefaultAction(ACTION_RIGHT, this::right)};
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    private void updateMonitorStatus(String[] crafterStatus) {
        TileEntity te;
        if (!this.monitors.isEmpty()) {
            String msg = this.errorTicks > 0 ? TextFormatting.DARK_RED + (this.errorTicks / 20 % 2 == 0 ? "  ERROR" : "") : (this.totalTicks == 0 ? TextFormatting.DARK_GREEN + (this.ticksRemaining.get() >= 0 ? "  100%" : "  idle") : TextFormatting.DARK_GREEN + (this.ticksRemaining.get() >= 0 ? "  " + (this.totalTicks - this.ticksRemaining.get()) * 100 / this.totalTicks + "%" : "  idle"));
            for (BlockPos monitorPos : this.monitors) {
                te = this.func_145831_w().func_175625_s(monitorPos);
                if (!(te instanceof MonitorTE)) continue;
                ((MonitorTE)te).setCraftStatus(msg, crafterStatus[0], crafterStatus[1]);
            }
        }
        if (!this.autoMonitors.isEmpty()) {
            Iterator<BlockPos> iterator = this.autoMonitors.iterator();
            ArrayList<String> messages = new ArrayList<String>();
            for (BlockPos crafter : this.crafters) {
                TileEntity te2;
                if (!iterator.hasNext()) break;
                if (messages.size() >= 8) {
                    BlockPos monitorPos = iterator.next();
                    TileEntity te3 = this.func_145831_w().func_175625_s(monitorPos);
                    if (te3 instanceof AutoCraftingMonitorTE) {
                        ((AutoCraftingMonitorTE)te3).setCraftStatus(messages);
                        messages.clear();
                    }
                }
                if ((te2 = this.field_145850_b.func_175625_s(crafter)) instanceof CrafterTE) {
                    CrafterTE crafterTE = (CrafterTE)te2;
                    if (!crafterTE.isOn()) {
                        messages.add(TextFormatting.GREEN + "* OFF");
                    } else if (crafterTE.isCrafting()) {
                        messages.add(TextFormatting.GREEN + "* " + crafterTE.getProgress() + "%");
                    } else if (crafterTE.getLastError() == null || crafterTE.getLastError().trim().isEmpty()) {
                        messages.add(TextFormatting.GREEN + "* IDLE");
                    } else {
                        messages.add(TextFormatting.RED + "* ERROR");
                    }
                    List<ItemStack> outputs = crafterTE.getOutputs();
                    if (outputs.isEmpty()) {
                        messages.add("   (unknown)");
                        continue;
                    }
                    String display = outputs.get(0).func_82833_r();
                    if (display.length() > 11) {
                        display = display.substring(0, 11) + "...";
                    }
                    messages.add("   " + display);
                    continue;
                }
                messages.add(TextFormatting.RED + "* ?");
                messages.add("");
            }
            while (iterator.hasNext()) {
                BlockPos monitorPos;
                monitorPos = iterator.next();
                te = this.func_145831_w().func_175625_s(monitorPos);
                if (!(te instanceof AutoCraftingMonitorTE)) continue;
                ((AutoCraftingMonitorTE)te).setCraftStatus(messages);
                messages.clear();
            }
        }
    }

    public boolean checkIngredients(List<ItemStack> ingredients, Predicate<String> testName) {
        for (ItemStack ingredient : ingredients) {
            int needed = ingredient.func_190916_E();
            for (BlockPos storagePos : this.storages) {
                ItemStack storageStack;
                StorageTE storageTE;
                TileEntity te = this.func_145831_w().func_175625_s(storagePos);
                if (!(te instanceof StorageTE) || !testName.test((storageTE = (StorageTE)te).getCraftingName())) continue;
                for (int ii = 0; ii < storageTE.func_70302_i_() && ((storageStack = storageTE.func_70301_a(ii)).func_190926_b() || !OreDictionary.itemMatches((ItemStack)ingredient, (ItemStack)storageStack, (boolean)false) || (needed -= Math.min(storageStack.func_190916_E(), needed)) > 0); ++ii) {
                }
                if (needed > 0) continue;
                break;
            }
            if (needed <= 0) continue;
            return false;
        }
        return true;
    }

    public void consumeIngredients(List<ItemStack> ingredients, Predicate<String> testName) {
        block0: for (ItemStack ingredient : ingredients) {
            int needed = ingredient.func_190916_E();
            for (BlockPos storagePos : this.storages) {
                ItemStack extracted;
                ItemStack storageStack;
                StorageTE storageTE;
                TileEntity te = this.func_145831_w().func_175625_s(storagePos);
                if (!(te instanceof StorageTE) || !testName.test((storageTE = (StorageTE)te).getCraftingName())) continue;
                for (int ii = 0; ii < storageTE.func_70302_i_() && ((storageStack = storageTE.func_70301_a(ii)).func_190926_b() || !OreDictionary.itemMatches((ItemStack)ingredient, (ItemStack)storageStack, (boolean)false) || (needed -= (extracted = storageTE.func_70298_a(ii, needed)).func_190916_E()) > 0); ++ii) {
                }
                if (needed > 0) continue;
                continue block0;
            }
        }
    }

    private void updateCrafters() {
        this.checkMultiBlockCache();
        if (this.crafters.isEmpty()) {
            return;
        }
        if (!this.getSupportedTiers().contains((Object)RecipeTier.COMPUTING)) {
            this.craftingStatus[0] = TextFormatting.DARK_RED + "  PROCESSOR";
            this.craftingStatus[1] = TextFormatting.DARK_RED + "  MISSING!";
            return;
        }
        this.markDirtyQuick();
        int countBusy = 0;
        int countOff = 0;
        int countMissing = 0;
        boolean startnewcrafts = false;
        --this.crafterDelay;
        if (this.crafterDelay <= 0) {
            this.crafterDelay = GeneralConfiguration.crafterDelay;
            startnewcrafts = true;
        }
        for (BlockPos crafterPos : new HashSet<BlockPos>(this.crafters)) {
            TileEntity te = this.func_145831_w().func_175625_s(crafterPos);
            if (!(te instanceof CrafterTE)) continue;
            CrafterTE crafterTE = (CrafterTE)te;
            if (crafterTE.isOn()) {
                if (crafterTE.isCrafting()) {
                    crafterTE.setSpeedBoost(GeneralConfiguration.craftAnimationBoost);
                    crafterTE.handleCraft(this);
                    ++countBusy;
                    continue;
                }
                IEFabRecipe recipe = crafterTE.checkCraft(this);
                if (recipe == null) {
                    ++countMissing;
                    continue;
                }
                if (!startnewcrafts) continue;
                crafterTE.startCraft(this, recipe);
                ++countBusy;
                continue;
            }
            crafterTE.setLastError("No redstone signal");
            ++countOff;
        }
        int idx = 0;
        if (countMissing > 0) {
            this.craftingStatus[idx++] = TextFormatting.DARK_RED + "  fail " + countMissing;
        }
        if (countBusy > 0) {
            this.craftingStatus[idx++] = TextFormatting.DARK_GREEN + "  busy " + countBusy;
        }
        if (countOff > 0 && idx <= 1) {
            this.craftingStatus[idx++] = TextFormatting.DARK_GREEN + "  off " + countOff;
        }
        if (idx <= 1) {
            this.craftingStatus[idx] = "";
        }
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            if (this.errorTicks > 0) {
                ++this.errorTicks;
                this.markDirtyQuick();
            }
            if (this.isMaster) {
                this.updateCrafters();
                this.updateMonitorStatus(this.craftingStatus);
            }
            if (this.ticksRemaining.get() >= 0) {
                this.markDirtyQuick();
                IEFabRecipe recipe = this.crafterHelper.findRecipeForOutput(this.getCurrentGhostOutput(), this.field_145850_b);
                if (recipe == null) {
                    this.abortCraft();
                    this.errorTicks = 1;
                    return;
                }
                this.ticksRemaining.dec();
                if (this.totalTicks - this.ticksRemaining.get() < 2) {
                    this.markDirtyClient();
                }
                if (!(this.ticksRemaining.get() % 20 != 0 && this.ticksRemaining.get() >= 0 || ItemStack.func_179545_c((ItemStack)this.crafterHelper.getCraftingOutput(), (ItemStack)this.getCurrentOutput(recipe)))) {
                    this.abortCraft();
                    this.errorTicks = 1;
                    return;
                }
                if (this.ticksRemaining.get() < 0) {
                    this.craftFinished(recipe);
                } else {
                    CraftProgressResult result = this.craftInProgress(recipe, this.ticksRemaining);
                    if (result == CraftProgressResult.WAIT) {
                        this.ticksRemaining.inc();
                    } else if (result == CraftProgressResult.ABORT) {
                        this.abortCraft();
                        this.errorTicks = 1;
                    }
                }
            }
        } else {
            this.updateSound();
        }
    }

    private void abortCraft() {
        this.ticksRemaining.set(-1);
        this.crafterHelper.abortCraft();
        this.markDirtyClient();
    }

    public CraftProgressResult craftInProgress(@Nonnull IEFabRecipe recipe, MInteger ticksRemain) {
        int stillneeded;
        this.checkMultiBlockCache();
        if (recipe.getRequiredTiers().contains((Object)RecipeTier.STEAM)) {
            int amount = GeneralConfiguration.waterSteamCraftingConsumption;
            FluidStack stack = new FluidStack(FluidRegistry.WATER, amount *= this.getSpeedBonus(recipe));
            TankTE tank = this.findSuitableTank(stack);
            if (tank == null) {
                return CraftProgressResult.ABORT;
            }
            FluidStack drained = tank.getHandler().drain(stack, true);
            if (drained == null || drained.amount < amount) {
                return CraftProgressResult.ABORT;
            }
        }
        if (recipe.getRequiredRfPerTick() > 0) {
            if (this.powerOptimizers.isEmpty()) {
                stillneeded = recipe.getRequiredRfPerTick();
                stillneeded *= this.getSpeedBonus(recipe);
                if ((stillneeded = this.handlePowerPerTick(stillneeded, this.rfControls, GeneralConfiguration.rfControlMax)) > 0) {
                    stillneeded = this.handlePowerPerTick(stillneeded, this.rfStorBasic, GeneralConfiguration.rfStorageInternalFlow);
                    if ((stillneeded = this.handlePowerPerTick(stillneeded, this.rfStorDense, GeneralConfiguration.advancedRfStorageInternalFlow)) > 0) {
                        if (GeneralConfiguration.ticksAllowedWithoutRF >= 0) {
                            ++this.rfWarning;
                            if (this.rfWarning > GeneralConfiguration.ticksAllowedWithoutRF) {
                                return CraftProgressResult.ABORT;
                            }
                        }
                        return CraftProgressResult.WAIT;
                    }
                } else {
                    this.rfWarning = 0;
                }
            } else {
                ticksRemain.inc();
                this.handlePowerOptimized(recipe, 100, ticksRemain);
                this.handlePowerOptimized(recipe, 10, ticksRemain);
                this.handlePowerOptimized(recipe, 1, ticksRemain);
                this.rfWarning = 0;
                if (ticksRemain.get() > 0) {
                    ticksRemain.dec();
                    return CraftProgressResult.WAIT;
                }
            }
        }
        if (EFab.botania && recipe.getRequiredManaPerTick() > 0) {
            stillneeded = recipe.getRequiredManaPerTick();
            stillneeded *= this.getSpeedBonus(recipe);
            if ((stillneeded = this.handleManaPerTick(stillneeded, this.manaReceptacles, GeneralConfiguration.maxManaUsage)) > 0) {
                if (GeneralConfiguration.ticksAllowedWithoutMana >= 0) {
                    ++this.manaWarning;
                    if (this.manaWarning > GeneralConfiguration.ticksAllowedWithoutMana) {
                        return CraftProgressResult.ABORT;
                    }
                }
                return CraftProgressResult.WAIT;
            }
            this.manaWarning = 0;
        }
        return CraftProgressResult.OK;
    }

    private void handlePowerOptimized(@Nonnull IEFabRecipe recipe, int step, MInteger ticksRemain) {
        while (ticksRemain.get() >= step) {
            int available;
            int needed = recipe.getRequiredRfPerTick() * step;
            if (needed > (available = this.getAvailablePower(this.rfControls) + this.getAvailablePower(this.rfStorBasic) + this.getAvailablePower(this.rfStorDense))) {
                return;
            }
            ticksRemain.dec(step);
            needed = this.handlePowerPerTick(needed, this.rfControls, 1000000000);
            needed = this.handlePowerPerTick(needed, this.rfStorBasic, 1000000000);
            this.handlePowerPerTick(needed, this.rfStorDense, 1000000000);
        }
    }

    private int handlePowerPerTick(int stillneeded, Set<BlockPos> poses, int maxUsage) {
        for (BlockPos p : poses) {
            TileEntity te = this.func_145831_w().func_175625_s(p);
            if (!(te instanceof IEFabEnergyStorage)) continue;
            IEFabEnergyStorage energyStorage = (IEFabEnergyStorage)te;
            int canUse = Math.min(maxUsage, energyStorage.getEnergyStored(null));
            if (canUse >= stillneeded) {
                energyStorage.extractEnergy(stillneeded);
                stillneeded = 0;
                break;
            }
            energyStorage.extractEnergy(canUse);
            stillneeded -= canUse;
        }
        return stillneeded;
    }

    private int getAvailablePower(Set<BlockPos> poses) {
        int power = 0;
        for (BlockPos p : poses) {
            TileEntity te = this.func_145831_w().func_175625_s(p);
            if (!(te instanceof IEFabEnergyStorage)) continue;
            IEFabEnergyStorage energyStorage = (IEFabEnergyStorage)te;
            power += energyStorage.getEnergyStored(null);
        }
        return power;
    }

    private int handleManaPerTick(int stillneeded, Set<BlockPos> poses, int maxUsage) {
        for (BlockPos p : poses) {
            if (!BotaniaSupportSetup.isManaReceptacle(this.func_145831_w().func_180495_p(p).func_177230_c())) continue;
            int canUse = Math.min(maxUsage, BotaniaSupportSetup.getMana(this.func_145831_w(), p));
            if (canUse >= stillneeded) {
                BotaniaSupportSetup.consumeMana(this.func_145831_w(), p, stillneeded);
                stillneeded = 0;
                break;
            }
            BotaniaSupportSetup.consumeMana(this.func_145831_w(), p, canUse);
            stillneeded -= canUse;
        }
        return stillneeded;
    }

    private void craftFinished(@Nonnull IEFabRecipe recipe) {
        this.ticksRemaining.set(-1);
        this.markDirtyClient();
        if (!this.checkRoomForOutput(this.crafterHelper.getCraftingOutput().func_77946_l())) {
            return;
        }
        if (this.checkFinalCraftRequirements(recipe, Collections.emptyList(), s -> false)) {
            return;
        }
        this.insertOutput(this.crafterHelper.getCraftingOutput().func_77946_l());
        for (int i = 0; i < 9; ++i) {
            this.func_70298_a(i, 1);
        }
        if (this.repeat) {
            this.startCraft(this.repeat);
        }
    }

    public boolean checkFinalCraftRequirements(IEFabRecipe recipe, @Nonnull List<ItemStack> ingredients, Predicate<String> matcher) {
        TankTE tank;
        for (FluidStack stack : recipe.getRequiredFluids()) {
            tank = this.findSuitableTank(stack);
            if (tank != null) continue;
            return true;
        }
        if (!this.checkIngredients(ingredients, matcher)) {
            return true;
        }
        for (FluidStack stack : recipe.getRequiredFluids()) {
            tank = this.findSuitableTank(stack);
            tank.getHandler().drain(stack, true);
        }
        this.consumeIngredients(ingredients, matcher);
        return false;
    }

    private ItemStack getCurrentGhostOutput() {
        return this.func_70301_a(21);
    }

    private boolean checkRoomForOutput(ItemStack output) {
        return this.crafterHelper.checkRoomForOutput(output, 9, 12);
    }

    private void insertOutput(ItemStack output) {
        this.crafterHelper.insertOutput(output, 9, 12);
    }

    private void setValidRecipeGhostOutput() {
        ItemStack current = this.inventoryHelper.getStackInSlot(21);
        List<IEFabRecipe> recipes = this.findCurrentRecipesSorted();
        if (current.func_190926_b()) {
            if (!recipes.isEmpty()) {
                this.inventoryHelper.setStackInSlot(21, recipes.get(0).cast().func_77571_b().func_77946_l());
                this.totalTicks = this.getCraftTime(recipes.get(0));
                this.markDirtyQuick();
            }
        } else if (recipes.isEmpty()) {
            this.inventoryHelper.setStackInSlot(21, ItemStack.field_190927_a);
            this.markDirtyQuick();
        } else {
            for (IEFabRecipe recipe : recipes) {
                if (!mcjty.efab.tools.InventoryHelper.isItemStackConsideredEqual(current, recipe.cast().func_77571_b())) continue;
                return;
            }
            this.inventoryHelper.setStackInSlot(21, recipes.get(0).cast().func_77571_b().func_77946_l());
            this.totalTicks = this.getCraftTime(recipes.get(0));
            this.markDirtyQuick();
        }
    }

    private ItemStack getCurrentOutput(@Nullable IEFabRecipe recipe) {
        if (recipe == null) {
            return ItemStack.field_190927_a;
        }
        return recipe.cast().func_77572_b(this.crafterHelper.getWorkInventory());
    }

    @Nonnull
    private List<IEFabRecipe> findCurrentRecipesSorted() {
        List<IEFabRecipe> recipes = this.crafterHelper.findCurrentRecipes(this.func_145831_w());
        recipes.sort((r1, r2) -> {
            boolean error2;
            boolean error1 = this.getErrorsForOutput((IEFabRecipe)r1, null);
            return error1 == (error2 = this.getErrorsForOutput((IEFabRecipe)r2, null)) ? 0 : (error2 ? -1 : 1);
        });
        return recipes;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.getInventoryHelper().setInventorySlotContents(this.func_70297_j_(), index, stack);
        if (index >= 0 && index < 9) {
            this.crafterHelper.invalidateCache();
            this.setValidRecipeGhostOutput();
            this.markDirtyClient();
        } else if (index >= 12 && index < 21) {
            this.invalidateMultiBlockCache();
        }
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.getInventoryHelper().decrStackSize(index, count);
        if (index >= 0 && index < 9) {
            this.setValidRecipeGhostOutput();
            this.crafterHelper.invalidateCache();
            this.markDirtyClient();
        } else if (index >= 12 && index < 21) {
            this.invalidateMultiBlockCache();
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.getInventoryHelper().removeStackFromSlot(index);
        if (index >= 0 && index < 9) {
            this.setValidRecipeGhostOutput();
            this.crafterHelper.invalidateCache();
            this.markDirtyClient();
        } else if (index >= 12 && index < 21) {
            this.invalidateMultiBlockCache();
        }
        return stack;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index >= 12 && index < 21 && !stack.func_190926_b() && stack.func_77973_b() instanceof UpgradeItem) {
            return true;
        }
        return index < 12;
    }

    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index >= 9 && index < 12;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    private void updateSound() {
        IEFabRecipe recipe;
        if (this.ticksRemaining.get() >= 0 && (recipe = this.crafterHelper.findRecipeForOutput(this.getCurrentGhostOutput(), this.field_145850_b)) != null) {
            TileEntity te;
            BlockPos p;
            ArrayList<Object> positions;
            Set<RecipeTier> requiredTiers = recipe.getRequiredTiers();
            if (requiredTiers.contains((Object)RecipeTier.STEAM) && !SoundController.isSteamPlaying(this.func_145831_w(), this.field_174879_c)) {
                SoundController.playSteamSound(this.func_145831_w(), this.field_174879_c);
                positions = new ArrayList<BlockPos>();
                this.findBoilers(this.field_174879_c, new HashSet<BlockPos>(), positions);
                if (!positions.isEmpty()) {
                    p = (BlockPos)positions.get(this.random.nextInt(positions.size()));
                    te = this.func_145831_w().func_175625_s(p);
                    if (te instanceof BoilerTE) {
                        ((BoilerTE)te).setTimer(60.0);
                    }
                }
            }
            if (requiredTiers.contains((Object)RecipeTier.COMPUTING) && !SoundController.isBeepsPlaying(this.func_145831_w(), this.field_174879_c) && (this.totalTicks - this.ticksRemaining.get() < 1 || (double)this.random.nextFloat() < 0.04)) {
                if (this.random.nextInt(100) < 50) {
                    SoundController.playBeeps1Sound(this.func_145831_w(), this.field_174879_c);
                } else {
                    SoundController.playBeeps2Sound(this.func_145831_w(), this.field_174879_c);
                }
            }
            if ((requiredTiers.contains((Object)RecipeTier.GEARBOX) || requiredTiers.contains((Object)RecipeTier.ADVANCED_GEARBOX)) && !SoundController.isMachinePlaying(this.func_145831_w(), this.field_174879_c)) {
                SoundController.playMachineSound(this.func_145831_w(), this.field_174879_c);
            }
            if (requiredTiers.contains((Object)RecipeTier.RF) && !SoundController.isSparksPlaying(this.func_145831_w(), this.field_174879_c) && (this.totalTicks - this.ticksRemaining.get() < 1 || (double)this.random.nextFloat() < 0.04)) {
                SoundController.playSparksSound(this.func_145831_w(), this.field_174879_c);
                positions = new ArrayList();
                this.findRFControlBlocks(this.field_174879_c, new HashSet<BlockPos>(), positions);
                if (!positions.isEmpty()) {
                    p = (BlockPos)positions.get(this.random.nextInt(positions.size()));
                    te = this.func_145831_w().func_175625_s(p);
                    if (te instanceof RfControlTE) {
                        ((RfControlTE)te).setSpark(25);
                    }
                }
            }
        }
    }

    private void findRFControlBlocks(BlockPos current, Set<BlockPos> visited, List<BlockPos> positions) {
        if (visited.contains(current)) {
            return;
        }
        visited.add(current);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos p = current.func_177972_a(dir);
            Block block = this.func_145831_w().func_180495_p(p).func_177230_c();
            if (block == ModBlocks.gridBlock) {
                this.findRFControlBlocks(p, visited, positions);
                continue;
            }
            if (block == ModBlocks.baseBlock) {
                this.findRFControlBlocks(p, visited, positions);
                continue;
            }
            if (!(block instanceof GenericEFabMultiBlockPart)) continue;
            if (block == ModBlocks.rfControlBlock) {
                positions.add(p);
            }
            this.findRFControlBlocks(p, visited, positions);
        }
    }

    private void findBoilers(BlockPos current, Set<BlockPos> visited, List<BlockPos> positions) {
        if (visited.contains(current)) {
            return;
        }
        visited.add(current);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos p = current.func_177972_a(dir);
            Block block = this.func_145831_w().func_180495_p(p).func_177230_c();
            if (block == ModBlocks.gridBlock) {
                this.findBoilers(p, visited, positions);
                continue;
            }
            if (block == ModBlocks.baseBlock) {
                this.findBoilers(p, visited, positions);
                continue;
            }
            if (!(block instanceof GenericEFabMultiBlockPart)) continue;
            if (block == ModBlocks.boilerBlock) {
                positions.add(p);
            }
            this.findBoilers(p, visited, positions);
        }
    }

    private void addTodo(Collection<BlockPos> todo, Collection<BlockPos> visited, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos p = pos.func_177972_a(dir);
            if (visited.contains(p) || todo.contains(p)) continue;
            todo.add(p);
        }
    }

    public int calculateGridPriority() {
        int total = 0;
        for (int i = 12; i < 21; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof UpgradeItem)) continue;
            total += ((UpgradeItem)stack.func_77973_b()).getPriority();
        }
        return total;
    }

    private void findMultiBlockParts() {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        HashSet<BlockPos> todo = new HashSet<BlockPos>();
        BlockPos bestGridSoFar = this.field_174879_c;
        int bestPrioritySoFar = this.calculateGridPriority();
        HashSet<BlockPos> grids = new HashSet<BlockPos>();
        grids.add(this.field_174879_c);
        visited.add(this.field_174879_c);
        this.addTodo(todo, visited, this.field_174879_c);
        while (!todo.isEmpty()) {
            Iterator i = todo.iterator();
            BlockPos p = (BlockPos)i.next();
            i.remove();
            visited.add(p);
            Block block = this.func_145831_w().func_180495_p(p).func_177230_c();
            if (block == ModBlocks.gridBlock) {
                int priority;
                TileEntity te = this.func_145831_w().func_175625_s(p);
                if (te instanceof GridTE && (priority = ((GridTE)te).calculateGridPriority()) > bestPrioritySoFar) {
                    bestPrioritySoFar = priority;
                    bestGridSoFar = p;
                }
                grids.add(p);
                this.addTodo(todo, visited, p);
                continue;
            }
            if (block == ModBlocks.baseBlock) {
                this.addTodo(todo, visited, p);
                continue;
            }
            if (!(block instanceof GenericEFabMultiBlockPart)) continue;
            if (block == ModBlocks.boilerBlock) {
                this.boilers.add(p);
            } else if (block == ModBlocks.steamEngineBlock) {
                this.steamEngines.add(p);
            } else if (block == ModBlocks.gearBoxBlock) {
                this.gearBoxes.add(p);
            } else if (block == ModBlocks.rfControlBlock) {
                this.rfControls.add(p);
            } else if (block == ModBlocks.rfStorageBlock) {
                this.rfStorBasic.add(p);
            } else if (block == ModBlocks.advancedRfStorageBlock) {
                this.rfStorDense.add(p);
            } else if (block == ModBlocks.processorBlock) {
                this.processors.add(p);
            } else if (block == ModBlocks.pipeBlock) {
                this.pipes.add(p);
            } else if (block == ModBlocks.monitorBlock) {
                this.monitors.add(p);
            } else if (block == ModBlocks.autoCraftingMonitorBlock) {
                this.autoMonitors.add(p);
            } else if (block == ModBlocks.crafterBlock) {
                this.crafters.add(p);
            } else if (block == ModBlocks.storageBlock) {
                this.storages.add(p);
            } else if (block == ModBlocks.powerOptimizerBlock) {
                this.powerOptimizers.add(p);
            } else if (block instanceof TankBlock) {
                this.tanks.add(p);
            } else if (EFab.botania && BotaniaSupportSetup.isManaReceptacle(block)) {
                this.manaReceptacles.add(p);
            }
            this.addTodo(todo, visited, p);
        }
        for (BlockPos grid : grids) {
            TileEntity te = this.func_145831_w().func_175625_s(grid);
            if (!(te instanceof GridTE)) continue;
            ((GridTE)te).isMaster = grid.equals((Object)bestGridSoFar);
        }
    }

    private void checkMultiBlockCache() {
        if (this.dirty) {
            this.dirty = false;
            this.boilers.clear();
            this.steamEngines.clear();
            this.tanks.clear();
            this.gearBoxes.clear();
            this.rfControls.clear();
            this.rfStorBasic.clear();
            this.rfStorDense.clear();
            this.processors.clear();
            this.pipes.clear();
            this.monitors.clear();
            this.autoMonitors.clear();
            this.crafters.clear();
            this.storages.clear();
            this.manaReceptacles.clear();
            this.powerOptimizers.clear();
            this.findMultiBlockParts();
        }
    }

    public void invalidateMultiBlockCache() {
        this.dirty = true;
        this.supportedTiers = null;
    }

    @Nonnull
    public List<ItemStack> getOutputs() {
        return this.crafterHelper.getOutputs(this.func_145831_w());
    }

    private void left() {
        List<IEFabRecipe> sorted = this.findCurrentRecipesSorted();
        OptionalInt first = this.findCurrentGhost(sorted);
        if (first.isPresent()) {
            int i = (first.getAsInt() - 1 + sorted.size()) % sorted.size();
            IEFabRecipe recipe = sorted.get(i);
            this.func_70299_a(21, recipe.cast().func_77571_b().func_77946_l());
            this.totalTicks = this.getCraftTime(recipe);
            this.markDirtyQuick();
        }
    }

    private void right() {
        List<IEFabRecipe> sorted = this.findCurrentRecipesSorted();
        OptionalInt first = this.findCurrentGhost(sorted);
        if (first.isPresent()) {
            int i = (first.getAsInt() + 1) % sorted.size();
            IEFabRecipe recipe = sorted.get(i);
            this.func_70299_a(21, recipe.cast().func_77571_b().func_77946_l());
            this.totalTicks = this.getCraftTime(recipe);
            this.markDirtyQuick();
        }
    }

    private OptionalInt findCurrentGhost(List<IEFabRecipe> sorted) {
        ItemStack ghostOutput = this.getCurrentGhostOutput();
        return IntStream.range(0, sorted.size()).filter(i -> mcjty.efab.tools.InventoryHelper.isItemStackConsideredEqual(((IEFabRecipe)sorted.get(i)).cast().func_77571_b(), ghostOutput)).findFirst();
    }

    private void startCraft(boolean repeat) {
        this.repeat = repeat;
        this.errorTicks = 0;
        this.rfWarning = 0;
        this.manaWarning = 0;
        this.markDirtyQuick();
        IEFabRecipe recipe = this.crafterHelper.findRecipeForOutput(this.getCurrentGhostOutput(), this.field_145850_b);
        if (recipe != null) {
            boolean error = this.getErrorsForOutput(recipe, null);
            if (error) {
                return;
            }
            this.crafterHelper.setCraftingOutput(this.getCurrentOutput(recipe));
            int craftTime = this.getCraftTime(recipe);
            this.ticksRemaining.set(craftTime);
            this.totalTicks = craftTime;
            this.markDirtyClient();
            if (recipe.getRequiredTiers().contains((Object)RecipeTier.STEAM)) {
                this.handleAnimationSpeed(GeneralConfiguration.steamWheelBoost, this.steamEngines);
            }
            if (EFab.botania && recipe.getRequiredTiers().contains((Object)RecipeTier.MANA)) {
                this.handleAnimationSpeed(GeneralConfiguration.manaRotationBoost, this.manaReceptacles);
            }
        }
    }

    public int getSpeedBonus(IEFabRecipe recipe) {
        int cnt;
        this.getSupportedTiers();
        int bonus = 1;
        if (recipe.getRequiredTiers().contains((Object)RecipeTier.GEARBOX) && (cnt = this.gearBoxes.size()) > 1 && bonus < cnt) {
            bonus = Math.min(GeneralConfiguration.maxSpeedupBonus, cnt);
        }
        if (recipe.getRequiredTiers().contains((Object)RecipeTier.STEAM) && (cnt = this.steamEngines.size()) > 1 && bonus < cnt) {
            bonus = Math.min(GeneralConfiguration.maxSpeedupBonus, cnt);
        }
        if (recipe.getRequiredTiers().contains((Object)RecipeTier.RF) && (cnt = this.rfControls.size()) > 1 && bonus < cnt) {
            bonus = Math.min(GeneralConfiguration.maxSpeedupBonus, cnt);
        }
        if (recipe.getRequiredTiers().contains((Object)RecipeTier.COMPUTING) && (cnt = this.processors.size()) > 1 && bonus < cnt) {
            bonus = Math.min(GeneralConfiguration.maxSpeedupBonus, cnt);
        }
        if (recipe.getRequiredTiers().contains((Object)RecipeTier.LIQUID) && (cnt = this.pipes.size()) > 1 && bonus < cnt) {
            bonus = Math.min(GeneralConfiguration.maxPipeSpeedBonus, cnt);
        }
        return bonus;
    }

    private int getCraftTime(IEFabRecipe recipe) {
        this.getSupportedTiers();
        int craftTime = recipe.getCraftTime();
        return craftTime / this.getSpeedBonus(recipe);
    }

    private void handleAnimationSpeed(int boost, Set<BlockPos> posSet) {
        this.checkMultiBlockCache();
        for (BlockPos enginePos : posSet) {
            TileEntity te = this.func_145831_w().func_175625_s(enginePos);
            if (!(te instanceof ISpeedBooster)) continue;
            ISpeedBooster speedBooster = (ISpeedBooster)te;
            speedBooster.setSpeedBoost(boost);
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.ticksRemaining.set(tagCompound.func_74762_e("ticks"));
        this.errorTicks = tagCompound.func_74762_e("error");
        this.totalTicks = tagCompound.func_74762_e("total");
        this.crafterDelay = tagCompound.func_74762_e("crafterDelay");
        this.repeat = tagCompound.func_74767_n("repeat");
        this.rfWarning = tagCompound.func_74762_e("rfWarning");
        this.manaWarning = tagCompound.func_74762_e("manaWarning");
        this.crafterHelper.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("ticks", this.ticksRemaining.get());
        tagCompound.func_74768_a("error", this.errorTicks);
        tagCompound.func_74768_a("total", this.totalTicks);
        tagCompound.func_74768_a("crafterDelay", this.crafterDelay);
        tagCompound.func_74757_a("repeat", this.repeat);
        tagCompound.func_74768_a("rfWarning", this.rfWarning);
        tagCompound.func_74768_a("manaWarning", this.manaWarning);
        this.crafterHelper.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public int getTicksRemaining() {
        return this.ticksRemaining.get();
    }

    public int getTotalTicks() {
        return this.totalTicks;
    }

    private TankTE findSuitableTank(@Nullable FluidStack stack) {
        if (stack == null) {
            return null;
        }
        this.checkMultiBlockCache();
        for (BlockPos tank : this.tanks) {
            TankTE tankTE;
            FluidStack fluid;
            TileEntity te = this.func_145831_w().func_175625_s(tank);
            if (!(te instanceof TankTE) || (fluid = (tankTE = (TankTE)te).getFluid()) == null || stack.getFluid() != fluid.getFluid() || fluid.amount < stack.amount) continue;
            return tankTE;
        }
        return null;
    }

    public List<String> getUsage() {
        if (this.func_145831_w().field_72995_K) {
            return this.usageFromServer;
        }
        ItemStack output = this.getCurrentGhostOutput();
        IEFabRecipe recipe = this.crafterHelper.findRecipeForOutput(output, this.field_145850_b);
        ArrayList<String> usage = new ArrayList<String>();
        if (recipe != null) {
            int speedBonus = this.getSpeedBonus(recipe);
            if (speedBonus > 1) {
                usage.add(TextFormatting.GOLD + "Speed up factor: " + speedBonus);
            }
            if (recipe.getRequiredRfPerTick() > 0) {
                usage.add(TextFormatting.GRAY + "RF/t " + TextFormatting.BLUE + recipe.getRequiredRfPerTick() * speedBonus);
                usage.add(TextFormatting.GRAY + "Total " + TextFormatting.BLUE + recipe.getRequiredRfPerTick() * recipe.getCraftTime());
            }
            if (recipe.getRequiredManaPerTick() > 0) {
                usage.add(TextFormatting.GRAY + "Mana/t " + TextFormatting.BLUE + recipe.getRequiredManaPerTick() * speedBonus);
                usage.add(TextFormatting.GRAY + "Total " + TextFormatting.BLUE + recipe.getRequiredManaPerTick() * recipe.getCraftTime());
            }
            for (FluidStack fluidStack : recipe.getRequiredFluids()) {
                usage.add(TextFormatting.GRAY + "Liquid " + TextFormatting.BLUE + fluidStack.getLocalizedName() + " (" + fluidStack.amount + "mb)");
            }
        }
        return usage;
    }

    public List<String> getErrorState() {
        if (this.func_145831_w().field_72995_K) {
            return this.errorsFromServer;
        }
        ItemStack output = this.getCurrentGhostOutput();
        IEFabRecipe recipe = this.crafterHelper.findRecipeForOutput(output, this.field_145850_b);
        ArrayList<String> errors = new ArrayList<String>();
        this.getErrorsForOutput(recipe, errors);
        return errors;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getErrorsForOutput(IEFabRecipe recipe, @Nullable List<String> errors) {
        TileEntity te;
        this.checkMultiBlockCache();
        if (recipe == null) {
            return false;
        }
        Set<RecipeTier> supported = this.getSupportedTiers();
        for (RecipeTier tier : recipe.getRequiredTiers()) {
            if (supported.contains((Object)tier)) continue;
            if (errors == null) return true;
            errors.add(tier.getMissingError());
        }
        for (FluidStack stack : recipe.getRequiredFluids()) {
            if (this.findSuitableTank(stack) != null) continue;
            if (errors == null) return true;
            errors.add("Not enough liquid: " + stack.getLocalizedName());
            errors.add("    " + stack.amount + " mb needed");
        }
        if (recipe.getRequiredRfPerTick() > 0 && this.powerOptimizers.isEmpty()) {
            IEFabEnergyStorage energyStorage;
            int totavailable = 0;
            int maxpertick = 0;
            for (BlockPos p : this.rfControls) {
                te = this.func_145831_w().func_175625_s(p);
                if (!(te instanceof IEFabEnergyStorage)) continue;
                energyStorage = (IEFabEnergyStorage)te;
                totavailable += energyStorage.getEnergyStored(null);
                maxpertick += energyStorage.getMaxInternalConsumption();
            }
            for (BlockPos p : this.rfStorBasic) {
                te = this.func_145831_w().func_175625_s(p);
                if (!(te instanceof IEFabEnergyStorage)) continue;
                energyStorage = (IEFabEnergyStorage)te;
                totavailable += energyStorage.getEnergyStored(null);
                maxpertick += energyStorage.getMaxInternalConsumption();
            }
            for (BlockPos p : this.rfStorDense) {
                te = this.func_145831_w().func_175625_s(p);
                if (!(te instanceof IEFabEnergyStorage)) continue;
                energyStorage = (IEFabEnergyStorage)te;
                totavailable += energyStorage.getEnergyStored(null);
                maxpertick += energyStorage.getMaxInternalConsumption();
            }
            if (recipe.getRequiredRfPerTick() > maxpertick) {
                if (errors == null) return true;
                errors.add("Not enough power capacity!");
                errors.add("    " + recipe.getRequiredRfPerTick() + "RF/t needed but only " + maxpertick + " possible");
            } else if (recipe.getRequiredRfPerTick() > totavailable) {
                if (errors == null) return true;
                errors.add("Not enough power!");
            }
        }
        if (EFab.botania && recipe.getRequiredManaPerTick() > 0) {
            int totavailable = 0;
            int maxpertick = 0;
            for (BlockPos p : this.manaReceptacles) {
                te = this.func_145831_w().func_175625_s(p);
                totavailable += BotaniaSupportSetup.getMana(this.func_145831_w(), p);
                maxpertick += GeneralConfiguration.maxManaUsage;
            }
            if (recipe.getRequiredManaPerTick() > maxpertick) {
                if (errors == null) return true;
                errors.add("Not enough mana capacity!");
                errors.add("    " + recipe.getRequiredManaPerTick() + "mana/t needed but only " + maxpertick + " possible");
            } else if (recipe.getRequiredManaPerTick() > totavailable) {
                if (errors == null) return true;
                errors.add("Not enough mana!");
            }
        }
        if (recipe.getRequiredTiers().contains((Object)RecipeTier.STEAM)) {
            boolean ok = false;
            for (BlockPos boiler : this.boilers) {
                TileEntity te2 = this.func_145831_w().func_175625_s(boiler);
                if (!(te2 instanceof BoilerTE) || !((BoilerTE)te2).canMakeSteam()) continue;
                ok = true;
                break;
            }
            if (!ok) {
                if (errors == null) return true;
                errors.add("There are no boilers hot enough!");
            }
            if (this.findSuitableTank(new FluidStack(FluidRegistry.WATER, GeneralConfiguration.waterSteamStartAmount)) == null) {
                if (errors == null) return true;
                errors.add("Insufficient water to make steam!");
            }
        }
        if (errors == null) return false;
        if (errors.isEmpty()) return false;
        return true;
    }

    private Set<RecipeTier> getSupportedTiers() {
        if (this.supportedTiers == null) {
            this.checkMultiBlockCache();
            this.supportedTiers = EnumSet.noneOf(RecipeTier.class);
            if (!this.boilers.isEmpty() && !this.steamEngines.isEmpty()) {
                this.supportedTiers.add(RecipeTier.STEAM);
            }
            if (!this.gearBoxes.isEmpty()) {
                this.supportedTiers.add(RecipeTier.GEARBOX);
            }
            if (!this.tanks.isEmpty()) {
                this.supportedTiers.add(RecipeTier.LIQUID);
            }
            if (!this.rfControls.isEmpty()) {
                this.supportedTiers.add(RecipeTier.RF);
            }
            if (!this.manaReceptacles.isEmpty()) {
                this.supportedTiers.add(RecipeTier.MANA);
            }
            if (!this.processors.isEmpty()) {
                this.supportedTiers.add(RecipeTier.COMPUTING);
            }
            for (int i = 12; i < 21; ++i) {
                ItemStack stack = this.func_70301_a(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof UpgradeItem)) continue;
                this.supportedTiers.add(((UpgradeItem)stack.func_77973_b()).providesTier());
            }
        }
        return this.supportedTiers;
    }

    public void syncFromServer(int ticks, int total, List<String> errors, List<ItemStack> outputs, List<String> usage) {
        this.ticksRemaining.set(ticks);
        this.totalTicks = total;
        this.errorsFromServer = errors;
        this.usageFromServer = usage;
        this.crafterHelper.syncFromServer(outputs);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.needsCustomInvWrapper()) {
            if (facing == null) {
                if (this.invHandlerNull == null) {
                    this.invHandlerNull = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
                }
                return (T)this.invHandlerNull;
            }
            if (this.invHandlerSided == null) {
                this.invHandlerSided = new NullSidedInvWrapper((ISidedInventory)this);
            }
            return (T)this.invHandlerSided;
        }
        return (T)super.getCapability(capability, facing);
    }

    public static enum CraftProgressResult {
        ABORT,
        WAIT,
        OK;

    }
}

