/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.blocks.grid;

import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import mcjty.efab.EFab;
import mcjty.efab.blocks.grid.GridContainer;
import mcjty.efab.blocks.grid.GridTE;
import mcjty.efab.network.EFabMessages;
import mcjty.efab.network.PacketGetGridStatus;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GridGui
extends GenericGuiContainer<GridTE> {
    public static final int WIDTH = 171;
    public static final int HEIGHT = 176;
    private Button craftButton;
    private Button leftArrow;
    private Button rightArrow;
    private Label timeLeftLabel;
    private static final ResourceLocation mainBackground = new ResourceLocation("efab", "textures/gui/grid.png");
    private static DecimalFormat fmt = new DecimalFormat("#.##");
    private static DecimalFormat shortFmt = new DecimalFormat("#.0");

    public GridGui(GridTE controller, GridContainer container) {
        super((ModBase)EFab.instance, EFabMessages.INSTANCE, (GenericTileEntity)controller, (Container)container, 0, "grid");
        this.field_146999_f = 171;
        this.field_147000_g = 176;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setBackground(mainBackground);
        this.leftArrow = (Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setName("left")).setText("<")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(82, 45, 13, 18))).setVisible(false);
        this.rightArrow = (Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setName("right")).setText(">")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(112, 45, 13, 18))).setVisible(false);
        this.timeLeftLabel = (Label)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText("")).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(88, 11, 40, 14));
        this.craftButton = (Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setChannel("craft")).setText("Start")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(84, 24, 40, 16));
        ((Panel)((Panel)((Panel)toplevel.addChild((Widget)this.craftButton)).addChild((Widget)this.leftArrow)).addChild((Widget)this.rightArrow)).addChild((Widget)this.timeLeftLabel);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        this.window.action(EFabMessages.INSTANCE, "left", this.tileEntity, "left");
        this.window.action(EFabMessages.INSTANCE, "right", this.tileEntity, "right");
        this.window.event("craft", (source, params) -> this.craft());
    }

    private void craft() {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            this.window.sendAction(EFabMessages.INSTANCE, this.tileEntity, "craftRepeat");
        } else {
            this.window.sendAction(EFabMessages.INSTANCE, this.tileEntity, "craft");
        }
    }

    public static String getTime(int ticks, boolean shortForm) {
        DecimalFormat format;
        float seconds = (float)ticks / 20.0f;
        DecimalFormat decimalFormat = format = shortForm ? shortFmt : fmt;
        if (seconds >= 60.0f) {
            float minutes = (float)ticks / 20.0f / 60.0f;
            if (minutes >= 60.0f) {
                float hours = (float)ticks / 20.0f / 3600.0f;
                if ((double)Math.abs(hours - 1.0f) < 0.01) {
                    return shortForm ? "1h" : "1 hour";
                }
                return format.format(hours) + (shortForm ? "h" : " hours");
            }
            if ((double)Math.abs(minutes - 1.0f) < 0.01) {
                return shortForm ? "1m" : "1 minute";
            }
            return format.format(minutes) + (shortForm ? "m" : " minutes");
        }
        if ((double)Math.abs(seconds - 1.0f) < 0.01) {
            return shortForm ? "1s" : "1 second";
        }
        return format.format(seconds) + (shortForm ? "s" : " seconds");
    }

    protected void func_146976_a(float v, int x1, int x2) {
        EFabMessages.INSTANCE.sendToServer((IMessage)new PacketGetGridStatus(((GridTE)this.tileEntity).func_174877_v()));
        List<String> errorState = ((GridTE)this.tileEntity).getErrorState();
        if (!errorState.isEmpty()) {
            this.timeLeftLabel.setText("");
            this.craftButton.setText("ERROR");
            this.craftButton.setTooltips(errorState.toArray(new String[errorState.size()]));
            this.craftButton.setEnabled(false);
        } else {
            int ticks = ((GridTE)this.tileEntity).getTicksRemaining();
            if (ticks < 0) {
                this.timeLeftLabel.setText("");
                this.craftButton.setText("Start");
                ArrayList<String> tooltip = new ArrayList<String>();
                tooltip.add("Start craft operation");
                tooltip.add("Duration " + GridGui.getTime(((GridTE)this.tileEntity).getTotalTicks(), false));
                tooltip.add(TextFormatting.GRAY + "Shift-click to autorepeat");
                List<String> usage = ((GridTE)this.tileEntity).getUsage();
                if (!usage.isEmpty()) {
                    tooltip.add("");
                    tooltip.addAll(usage);
                }
                this.craftButton.setTooltips(tooltip.toArray(new String[tooltip.size()]));
                this.craftButton.setEnabled(true);
            } else {
                this.timeLeftLabel.setText(GridGui.getTime(ticks, true));
                this.craftButton.setTooltips(new String[]{"Craft operation in progress"});
                this.craftButton.setEnabled(false);
                int total = ((GridTE)this.tileEntity).getTotalTicks();
                if (total > 0) {
                    this.craftButton.setText((total - ticks) * 100 / total + "%");
                }
            }
        }
        List<ItemStack> outputs = ((GridTE)this.tileEntity).getOutputs();
        this.leftArrow.setVisible(outputs.size() > 1);
        this.rightArrow.setVisible(outputs.size() > 1);
        this.drawWindow();
    }
}

