/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.blocks.grid;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.efab.config.GeneralConfiguration;
import mcjty.efab.recipes.IEFabRecipe;
import mcjty.efab.recipes.RecipeManager;
import mcjty.efab.recipes.VanillaRecipeAdapter;
import mcjty.efab.tools.InventoryHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class GridCrafterHelper {
    private final IInventory inventory;
    private final InventoryCrafting workInventory = new InventoryCrafting(new Container(){

        public boolean func_75145_c(EntityPlayer var1) {
            return false;
        }
    }, 3, 3);
    private ItemStack craftingOutput = ItemStack.field_190927_a;
    private IRecipe vanillaRecipe = null;
    private boolean vanillaRecipeValid = false;
    @Nullable
    private ItemStack cachedItemStackForRecipe = null;
    @Nullable
    private IEFabRecipe cachedRecipe = null;
    private List<ItemStack> outputsFromServer = Collections.emptyList();

    public GridCrafterHelper(IInventory inventory) {
        this.inventory = inventory;
    }

    public InventoryCrafting getWorkInventory() {
        return this.workInventory;
    }

    public void invalidateCache() {
        this.vanillaRecipe = null;
        this.vanillaRecipeValid = false;
        this.cachedItemStackForRecipe = null;
        this.cachedRecipe = null;
    }

    @Nullable
    public IEFabRecipe findRecipeForOutput(ItemStack output, World world) {
        if (this.cachedItemStackForRecipe != null && (this.cachedItemStackForRecipe.func_190926_b() && output.func_190926_b() || InventoryHelper.isItemStackConsideredEqual(output, this.cachedItemStackForRecipe))) {
            return this.cachedRecipe;
        }
        this.cachedItemStackForRecipe = output;
        List<IEFabRecipe> recipes = this.findCurrentRecipes(world);
        for (IEFabRecipe recipe : recipes) {
            if (!InventoryHelper.isItemStackConsideredEqual(output, recipe.cast().func_77571_b())) continue;
            this.cachedRecipe = recipe;
            return recipe;
        }
        this.cachedRecipe = null;
        return null;
    }

    @Nonnull
    public List<ItemStack> getOutputs(World world) {
        if (world.field_72995_K) {
            return this.outputsFromServer;
        }
        return this.findCurrentRecipes(world).stream().map(r -> r.cast().func_77571_b()).collect(Collectors.toList());
    }

    public void syncFromServer(List<ItemStack> outputs) {
        this.outputsFromServer = outputs;
    }

    public void abortCraft() {
        this.craftingOutput = ItemStack.field_190927_a;
    }

    public ItemStack getCraftingOutput() {
        return this.craftingOutput;
    }

    public void setCraftingOutput(ItemStack craftingOutput) {
        this.craftingOutput = craftingOutput;
    }

    @Nonnull
    public List<IEFabRecipe> findCurrentRecipes(World world) {
        for (int i = 0; i < 9; ++i) {
            this.workInventory.func_70299_a(i, this.inventory.func_70301_a(i));
        }
        List<IEFabRecipe> validRecipes = RecipeManager.findValidRecipes(this.workInventory, world);
        if (validRecipes.isEmpty() && GeneralConfiguration.vanillaCraftingAllowed) {
            if (!this.vanillaRecipeValid) {
                this.vanillaRecipe = CraftingManager.func_192413_b((InventoryCrafting)this.workInventory, (World)world);
                this.vanillaRecipeValid = true;
            }
            if (this.vanillaRecipe != null) {
                validRecipes.add(new VanillaRecipeAdapter(this.vanillaRecipe));
            }
        }
        return validRecipes;
    }

    public boolean checkRoomForOutput(ItemStack output, int start, int stop) {
        for (int i = start; i < stop; ++i) {
            ItemStack currentStack = this.inventory.func_70301_a(i);
            if (currentStack.func_190926_b()) {
                return true;
            }
            if (!InventoryHelper.isItemStackConsideredEqual(currentStack, output)) continue;
            int remaining = currentStack.func_77976_d() - currentStack.func_190916_E();
            if (remaining >= output.func_190916_E()) {
                return true;
            }
            int amount = -remaining;
            output.func_190917_f(amount);
        }
        return false;
    }

    public void insertOutput(ItemStack output, int start, int stop) {
        for (int i = start; i < stop; ++i) {
            int amount;
            ItemStack currentStack = this.inventory.func_70301_a(i);
            if (currentStack.func_190926_b()) {
                this.inventory.func_70299_a(i, output);
                return;
            }
            if (!InventoryHelper.isItemStackConsideredEqual(currentStack, output)) continue;
            int remaining = currentStack.func_77976_d() - currentStack.func_190916_E();
            if (remaining >= output.func_190916_E()) {
                amount = output.func_190916_E() + currentStack.func_190916_E();
                if (amount <= 0) {
                    output.func_190920_e(0);
                } else {
                    output.func_190920_e(amount);
                }
                this.inventory.func_70299_a(i, output);
                return;
            }
            amount = currentStack.func_77976_d();
            if (amount <= 0) {
                currentStack.func_190920_e(0);
            } else {
                currentStack.func_190920_e(amount);
            }
            this.inventory.func_70299_a(i, currentStack);
            amount = -remaining;
            output.func_190917_f(amount);
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.craftingOutput = tagCompound.func_74764_b("output") ? new ItemStack(tagCompound.func_74775_l("output")) : ItemStack.field_190927_a;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        if (!this.craftingOutput.func_190926_b()) {
            NBTTagCompound out = new NBTTagCompound();
            this.craftingOutput.func_77955_b(out);
            tagCompound.func_74782_a("output", (NBTBase)out);
        }
    }
}

