/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.blocks.grid;

import java.util.List;
import java.util.function.BiFunction;
import mcjty.efab.blocks.GenericEFabBlockWithTE;
import mcjty.efab.blocks.ModBlocks;
import mcjty.efab.blocks.grid.GridContainer;
import mcjty.efab.blocks.grid.GridGui;
import mcjty.efab.blocks.grid.GridRenderer;
import mcjty.efab.blocks.grid.GridTE;
import mcjty.efab.sound.ISoundProducer;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GridBlock
extends GenericEFabBlockWithTE<GridTE, GridContainer>
implements ISoundProducer {
    public static PropertyBool HALF = PropertyBool.func_177716_a((String)"half");

    public GridBlock() {
        super(Material.field_151573_f, GridTE.class, GridContainer::new, "grid", true);
    }

    public void func_190948_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, playerIn, tooltip, advanced);
        tooltip.add(TextFormatting.WHITE + "This is the basic crafting device for the fabricator");
        tooltip.add(TextFormatting.WHITE + "Add blocks to this to extend the capabilities");
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.HORIZROTATION;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
        ClientRegistry.bindTileEntitySpecialRenderer(GridTE.class, (TileEntitySpecialRenderer)new GridRenderer());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BiFunction<GridTE, GridContainer, GenericGuiContainer<? super GridTE>> getGuiFactory() {
        return GridGui::new;
    }

    public int getGuiID() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, blockIn, fromPos);
        world.func_175704_b(pos, pos);
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof GridTE) {
            GridTE gridTE = (GridTE)te;
            List<String> errorState = gridTE.getErrorState();
            if (!errorState.isEmpty()) {
                for (String error : errorState) {
                    probeInfo.text(TextStyleClass.LABEL + "Status " + TextStyleClass.ERROR + error);
                }
            } else {
                int ticks = gridTE.getTicksRemaining();
                if (ticks < 0) {
                    probeInfo.text(TextStyleClass.LABEL + "Status " + TextStyleClass.INFO + "IDLE");
                } else {
                    int total = gridTE.getTotalTicks();
                    if (total > 0) {
                        int progress = (total - ticks) * 100 / total;
                        probeInfo.text(TextStyleClass.LABEL + "Status " + TextStyleClass.INFO + progress + "%");
                    }
                }
            }
            List<ItemStack> outputs = gridTE.getOutputs();
            if (!outputs.isEmpty()) {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(TextStyleClass.LABEL + "Output ").item(outputs.get(0));
            }
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean half = GridBlock.isHalfBlock(worldIn, pos);
        return state.func_177226_a((IProperty)HALF, (Comparable)Boolean.valueOf(half));
    }

    public static boolean isHalfBlock(IBlockAccess worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlocks.baseBlock;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING_HORIZ, HALF});
    }
}

