/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.blocks.crafter;

import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.efab.blocks.GenericEFabTile;
import mcjty.efab.blocks.ISpeedBooster;
import mcjty.efab.blocks.crafter.CrafterContainer;
import mcjty.efab.blocks.grid.GridCrafterHelper;
import mcjty.efab.blocks.grid.GridTE;
import mcjty.efab.blocks.grid.MInteger;
import mcjty.efab.config.GeneralConfiguration;
import mcjty.efab.recipes.IEFabRecipe;
import mcjty.lib.bindings.DefaultAction;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IAction;
import mcjty.lib.bindings.IValue;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.NullSidedInvWrapper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class CrafterTE
extends GenericEFabTile
implements DefaultSidedInventory,
ITickable,
ISpeedBooster {
    public static final int[] SLOTS = new int[]{9, 10, 11};
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CrafterContainer.factory, 13);
    private float speed = 1.0f;
    private int speedBoost = 0;
    private String name;
    private MInteger ticksRemaining = new MInteger(-1);
    private int totalTicks = 0;
    private String lastError = "";
    private float cnt = 0.0f;
    private float cnt2 = 0.0f;
    private final GridCrafterHelper crafterHelper = new GridCrafterHelper((IInventory)this);
    public static final String ACTION_LEFT = "left";
    public static final String ACTION_RIGHT = "right";
    public static final Key<String> VALUE_NAME = new Key("name", Type.STRING);

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_NAME, this::getCraftingName, this::setCraftingName)};
    }

    public IAction[] getActions() {
        return new IAction[]{new DefaultAction(ACTION_LEFT, this::left), new DefaultAction(ACTION_RIGHT, this::right)};
    }

    public String getCraftingName() {
        return this.name == null ? "" : this.name;
    }

    public void setCraftingName(String name) {
        this.name = name;
        this.markDirtyClient();
    }

    public float getCnt() {
        return this.cnt;
    }

    public void setCnt(float cnt) {
        this.cnt = cnt;
    }

    public float getCnt2() {
        return this.cnt2;
    }

    public void setCnt2(float cnt2) {
        this.cnt2 = cnt2;
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    @Override
    public float getSpeed() {
        return this.speed;
    }

    public boolean isOn() {
        return this.powerLevel > 0;
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = speed;
        this.markDirtyClient();
    }

    @Override
    public int getSpeedBoost() {
        return this.speedBoost;
    }

    @Override
    public void setSpeedBoost(int speedBoost) {
        this.speedBoost = speedBoost;
        this.markDirtyClient();
    }

    public void func_73660_a() {
        if (this.speed > 1.0f) {
            this.speed -= GeneralConfiguration.craftAnimationSpinDown;
            if (this.speed < 1.0f) {
                this.speed = 1.0f;
            }
            this.markDirtyQuick();
        }
        if (this.speedBoost > 0) {
            --this.speedBoost;
            this.speed += GeneralConfiguration.craftAnimationSpeedUp;
            if (this.speed > GeneralConfiguration.maxCraftAnimationSpeed) {
                this.speed = GeneralConfiguration.maxCraftAnimationSpeed;
            }
            this.markDirtyQuick();
        }
    }

    private ItemStack getCurrentOutput(@Nullable IEFabRecipe recipe) {
        if (recipe == null) {
            return ItemStack.field_190927_a;
        }
        return recipe.cast().func_77572_b(this.crafterHelper.getWorkInventory());
    }

    @Nonnull
    public List<ItemStack> getOutputs() {
        return this.crafterHelper.getOutputs(this.func_145831_w());
    }

    private void abortCraft() {
        this.ticksRemaining.set(-1);
        this.crafterHelper.abortCraft();
    }

    public boolean isCrafting() {
        IEFabRecipe recipe = this.crafterHelper.findRecipeForOutput(this.getCurrentGhostOutput(), this.field_145850_b);
        if (recipe == null) {
            return false;
        }
        return this.ticksRemaining.get() >= 0 && !this.crafterHelper.getCraftingOutput().func_190926_b();
    }

    public int getProgress() {
        if (this.totalTicks == 0) {
            return 100;
        }
        return (this.totalTicks - this.ticksRemaining.get()) * 100 / this.totalTicks;
    }

    public String getLastError() {
        return this.lastError;
    }

    public void setLastError(String lastError) {
        this.lastError = lastError;
    }

    public void handleCraft(GridTE grid) {
        if (this.ticksRemaining.get() >= 0) {
            this.markDirtyQuick();
            IEFabRecipe recipe = this.crafterHelper.findRecipeForOutput(this.getCurrentGhostOutput(), this.field_145850_b);
            if (recipe == null) {
                this.lastError = "No recipe";
                this.abortCraft();
                return;
            }
            this.ticksRemaining.dec();
            if (this.totalTicks - this.ticksRemaining.get() < 2) {
                this.markDirtyClient();
            }
            if (!(this.ticksRemaining.get() % 20 != 0 && this.ticksRemaining.get() >= 0 || ItemStack.func_179545_c((ItemStack)this.crafterHelper.getCraftingOutput(), (ItemStack)this.getCurrentOutput(recipe)))) {
                this.abortCraft();
                return;
            }
            if (this.ticksRemaining.get() < 0) {
                this.craftFinished(recipe, grid);
            } else {
                GridTE.CraftProgressResult result = grid.craftInProgress(recipe, this.ticksRemaining);
                if (result == GridTE.CraftProgressResult.WAIT) {
                    this.ticksRemaining.dec();
                } else if (result == GridTE.CraftProgressResult.ABORT) {
                    this.abortCraft();
                }
            }
        }
    }

    private List<ItemStack> condenseIngredients(InventoryCrafting workInventory) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (int i = 0; i < workInventory.func_70302_i_(); ++i) {
            ItemStack stack = workInventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            boolean found = false;
            for (ItemStack ingredient : ingredients) {
                if (!mcjty.efab.tools.InventoryHelper.isItemStackConsideredEqual(stack, ingredient)) continue;
                ingredient.func_190917_f(stack.func_190916_E());
                found = true;
                break;
            }
            if (found) continue;
            ingredients.add(stack.func_77946_l());
        }
        return ingredients;
    }

    private void craftFinished(@Nonnull IEFabRecipe recipe, GridTE grid) {
        this.lastError = "";
        this.ticksRemaining.set(-1);
        this.markDirtyQuick();
        if (!this.checkRoomForOutput(this.crafterHelper.getCraftingOutput().func_77946_l())) {
            return;
        }
        List<ItemStack> ingredients = this.condenseIngredients(this.crafterHelper.getWorkInventory());
        if (grid.checkFinalCraftRequirements(recipe, ingredients, this.getStorageMatcher())) {
            return;
        }
        this.insertOutput(this.crafterHelper.getCraftingOutput().func_77946_l());
        this.crafterHelper.abortCraft();
    }

    private boolean checkRoomForOutput(ItemStack output) {
        return this.crafterHelper.checkRoomForOutput(output, 9, 12);
    }

    private void insertOutput(ItemStack output) {
        this.crafterHelper.insertOutput(output, 9, 12);
    }

    public void startCraft(GridTE grid, IEFabRecipe recipe) {
        this.crafterHelper.setCraftingOutput(this.getCurrentOutput(recipe));
        int craftTime = recipe.getCraftTime() / grid.getSpeedBonus(recipe);
        this.ticksRemaining.set(craftTime);
        this.totalTicks = craftTime;
        this.markDirtyQuick();
    }

    public IEFabRecipe checkCraft(GridTE grid) {
        IEFabRecipe recipe = this.crafterHelper.findRecipeForOutput(this.getCurrentGhostOutput(), this.field_145850_b);
        if (recipe != null) {
            ArrayList<String> errors = new ArrayList<String>();
            boolean error = grid.getErrorsForOutput(recipe, errors);
            if (error) {
                this.lastError = (String)errors.get(0);
                return null;
            }
            List<ItemStack> ingredients = this.condenseIngredients(this.crafterHelper.getWorkInventory());
            if (!grid.checkIngredients(ingredients, this.getStorageMatcher())) {
                this.lastError = "Ingredients missing";
                return null;
            }
            if (!this.checkRoomForOutput(this.crafterHelper.getCraftingOutput().func_77946_l())) {
                this.lastError = "Not enough room for output";
                return null;
            }
            this.lastError = "";
            return recipe;
        }
        this.lastError = "No recipe";
        return null;
    }

    private Predicate<String> getStorageMatcher() {
        return this.getCraftingName().isEmpty() ? s -> true : s -> this.getCraftingName().equals(s);
    }

    private void setValidRecipeGhostOutput() {
        ItemStack current = this.inventoryHelper.getStackInSlot(12);
        List<IEFabRecipe> recipes = this.crafterHelper.findCurrentRecipes(this.func_145831_w());
        if (current.func_190926_b()) {
            if (!recipes.isEmpty()) {
                this.inventoryHelper.setStackInSlot(12, recipes.get(0).cast().func_77571_b());
                this.markDirtyQuick();
            }
        } else if (recipes.isEmpty()) {
            this.inventoryHelper.setStackInSlot(12, ItemStack.field_190927_a);
            this.markDirtyQuick();
        } else {
            for (IEFabRecipe recipe : recipes) {
                if (!mcjty.efab.tools.InventoryHelper.isItemStackConsideredEqual(current, recipe.cast().func_77571_b())) continue;
                return;
            }
            this.inventoryHelper.setStackInSlot(12, recipes.get(0).cast().func_77571_b());
            this.markDirtyQuick();
        }
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.getInventoryHelper().setInventorySlotContents(this.func_70297_j_(), index, stack);
        if (index >= 0 && index < 9) {
            this.crafterHelper.invalidateCache();
            this.setValidRecipeGhostOutput();
        }
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.getInventoryHelper().decrStackSize(index, count);
        if (index >= 0 && index < 9) {
            this.crafterHelper.invalidateCache();
            this.setValidRecipeGhostOutput();
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.getInventoryHelper().removeStackFromSlot(index);
        if (index >= 0 && index < 9) {
            this.crafterHelper.invalidateCache();
            this.setValidRecipeGhostOutput();
        }
        return stack;
    }

    public void setGridContents(List<ItemStack> stacks) {
        this.crafterHelper.invalidateCache();
        this.func_70299_a(12, stacks.get(0));
        for (int i = 1; i < stacks.size(); ++i) {
            this.func_70299_a(0 + i - 1, stacks.get(i));
        }
    }

    public void syncFromServer(List<String> errors, List<ItemStack> outputs) {
        this.lastError = errors.isEmpty() ? "" : errors.get(0);
        this.crafterHelper.syncFromServer(outputs);
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index >= 9 && index < 12;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.name = tagCompound.func_74779_i("name");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        if (this.name != null) {
            tagCompound.func_74778_a("name", this.name);
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.speed = tagCompound.func_74760_g("speed");
        this.speedBoost = tagCompound.func_74762_e("boost");
        this.ticksRemaining.set(tagCompound.func_74762_e("ticks"));
        this.totalTicks = tagCompound.func_74762_e("total");
        this.crafterHelper.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74776_a("speed", this.speed);
        tagCompound.func_74768_a("boost", this.speedBoost);
        tagCompound.func_74768_a("ticks", this.ticksRemaining.get());
        tagCompound.func_74768_a("total", this.totalTicks);
        this.crafterHelper.writeToNBT(tagCompound);
        return super.func_189515_b(tagCompound);
    }

    private void left() {
        List<IEFabRecipe> sorted = this.crafterHelper.findCurrentRecipes(this.func_145831_w());
        OptionalInt first = this.findCurrentGhost(sorted);
        if (first.isPresent()) {
            int i = (first.getAsInt() - 1 + sorted.size()) % sorted.size();
            IEFabRecipe recipe = sorted.get(i);
            this.func_70299_a(12, recipe.cast().func_77571_b());
            this.markDirtyQuick();
        }
    }

    private void right() {
        List<IEFabRecipe> sorted = this.crafterHelper.findCurrentRecipes(this.func_145831_w());
        OptionalInt first = this.findCurrentGhost(sorted);
        if (first.isPresent()) {
            int i = (first.getAsInt() + 1) % sorted.size();
            IEFabRecipe recipe = sorted.get(i);
            this.func_70299_a(12, recipe.cast().func_77571_b());
            this.markDirtyQuick();
        }
    }

    private OptionalInt findCurrentGhost(List<IEFabRecipe> sorted) {
        ItemStack ghostOutput = this.getCurrentGhostOutput();
        return IntStream.range(0, sorted.size()).filter(i -> mcjty.efab.tools.InventoryHelper.isItemStackConsideredEqual(((IEFabRecipe)sorted.get(i)).cast().func_77571_b(), ghostOutput)).findFirst();
    }

    private ItemStack getCurrentGhostOutput() {
        return this.func_70301_a(12);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.needsCustomInvWrapper()) {
            if (facing == null) {
                if (this.invHandlerNull == null) {
                    this.invHandlerNull = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
                }
                return (T)this.invHandlerNull;
            }
            if (this.invHandlerSided == null) {
                this.invHandlerSided = new NullSidedInvWrapper((ISidedInventory)this);
            }
            return (T)this.invHandlerSided;
        }
        return (T)super.getCapability(capability, facing);
    }
}

