/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.blocks.crafter;

import mcjty.efab.blocks.ModBlocks;
import mcjty.efab.blocks.crafter.CrafterTE;
import mcjty.lib.blocks.BaseBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class CrafterRenderer
extends TileEntitySpecialRenderer<CrafterTE> {
    private IModel wheelModel;
    private IBakedModel bakedWheelModel;
    private IModel pipeModel;
    private IBakedModel bakedPipeModel;
    private static final int SPEEDCYCLE = 2000;
    private static final int SPEEDCYCLE2 = 2500;

    private IBakedModel getBakedWheelModel() {
        if (this.bakedWheelModel == null) {
            try {
                this.wheelModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("efab", "block/wheel.obj"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.bakedWheelModel = this.wheelModel.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
        }
        return this.bakedWheelModel;
    }

    private IBakedModel getBakedPipeModel() {
        if (this.bakedPipeModel == null) {
            try {
                this.pipeModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("efab", "block/pipe.obj"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.bakedPipeModel = this.pipeModel.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
        }
        return this.bakedPipeModel;
    }

    public void render(CrafterTE te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        super.func_192841_a((TileEntity)te, x, y, z, partialTicks, destroyStage, alpha);
        if (te.func_145831_w().func_175623_d(te.func_174877_v())) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GlStateManager.func_179101_C();
        CrafterRenderer.rotateFacing((TileEntity)te);
        this.renderWheel(te);
        GlStateManager.func_179121_F();
    }

    public static void rotateFacing(TileEntity tileEntity) {
        IBlockState state = tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v());
        EnumFacing orientation = BaseBlock.getFrontDirection((BaseBlock.RotationType)ModBlocks.crafterBlock.getRotationType(), (IBlockState)state);
        switch (orientation) {
            case NORTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
    }

    protected void renderWheel(CrafterTE tileEntity) {
        float cnt = tileEntity.getCnt();
        float cnt2 = tileEntity.getCnt2();
        float t = (long)(4000.0f * (float)((int)cnt % 2000)) / 2000L % 2000L;
        if ((cnt += tileEntity.getSpeed()) > 2000.0f) {
            cnt -= 2000.0f;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
        GlStateManager.func_179114_b((float)(360.0f * t / 2000.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)0.0, (double)-0.5, (double)0.0);
        GlStateManager.func_179137_b((double)((double)(-tileEntity.func_174877_v().func_177958_n()) - 0.5), (double)(-tileEntity.func_174877_v().func_177956_o() - 1), (double)((double)(-tileEntity.func_174877_v().func_177952_p()) + 0.2));
        this.renderModel(tileEntity, this.getBakedWheelModel());
        GlStateManager.func_179121_F();
        int t2 = 2000 * ((int)cnt % 2000) / 2000 % 2000;
        float offs = t2 <= 1000 ? (float)t2 / 2900.0f : (float)(2000 - t2) / 2900.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)(-tileEntity.func_174877_v().func_177958_n()) - 0.25), (double)((double)((float)(-tileEntity.func_174877_v().func_177956_o() - 1) + offs) + 0.3), (double)((double)(-tileEntity.func_174877_v().func_177952_p()) - 0.2));
        this.renderModel(tileEntity, this.getBakedPipeModel());
        GlStateManager.func_179121_F();
        t2 = 2000 * ((int)cnt2 % 2500) / 2500 % 2000;
        cnt2 += tileEntity.getSpeed();
        if (cnt2 > 2500.0f) {
            cnt2 -= 2500.0f;
        }
        offs = t2 <= 1000 ? (float)t2 / 2900.0f : (float)(2000 - t2) / 2900.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)(-tileEntity.func_174877_v().func_177958_n()) + 0.25), (double)((double)((float)(-tileEntity.func_174877_v().func_177956_o() - 1) + offs) + 0.3), (double)((double)(-tileEntity.func_174877_v().func_177952_p()) - 0.2));
        this.renderModel(tileEntity, this.getBakedPipeModel());
        GlStateManager.func_179121_F();
        tileEntity.setCnt(cnt);
        tileEntity.setCnt2(cnt2);
    }

    private void renderModel(CrafterTE tileEntity, IBakedModel model) {
        RenderHelper.func_74518_a();
        this.func_147499_a(TextureMap.field_110575_b);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        World world = tileEntity.func_145831_w();
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)world, model, world.func_180495_p(tileEntity.func_174877_v()), tileEntity.func_174877_v().func_177984_a(), Tessellator.func_178181_a().func_178180_c(), true);
        tessellator.func_78381_a();
        RenderHelper.func_74519_b();
    }
}

