/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.blocks.crafter;

import java.util.List;
import java.util.function.BiFunction;
import mcjty.efab.blocks.GenericEFabMultiBlockPart;
import mcjty.efab.blocks.crafter.CrafterContainer;
import mcjty.efab.blocks.crafter.CrafterGui;
import mcjty.efab.blocks.crafter.CrafterRenderer;
import mcjty.efab.blocks.crafter.CrafterTE;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CrafterBlock
extends GenericEFabMultiBlockPart<CrafterTE, CrafterContainer> {
    public static final AxisAlignedBB EMPTY = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public CrafterBlock() {
        super(Material.field_151573_f, CrafterTE.class, CrafterContainer::new, "crafter", false);
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.HORIZROTATION;
    }

    public boolean needsRedstoneCheck() {
        return true;
    }

    public void func_190948_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, playerIn, tooltip, advanced);
        tooltip.add(TextFormatting.WHITE + "This block adds auto crafting to the fabricator");
        tooltip.add(TextFormatting.WHITE + "Also needs a " + TextFormatting.GREEN + "processor" + TextFormatting.WHITE + " and one or more " + TextFormatting.GREEN + "storage" + TextFormatting.WHITE + " blocks");
        tooltip.add(TextFormatting.YELLOW + "The crafter needs a redstone signal to work!");
        tooltip.add(TextFormatting.GOLD + "If you give this crafter a name it will only");
        tooltip.add(TextFormatting.GOLD + "pull items from item storages with the same name!");
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof CrafterTE) {
            List<ItemStack> outputs;
            CrafterTE crafterTE = (CrafterTE)te;
            if (!crafterTE.isOn()) {
                probeInfo.text(TextStyleClass.LABEL + "Status " + TextStyleClass.INFO + "OFF");
            } else if (crafterTE.isCrafting()) {
                probeInfo.text(TextStyleClass.LABEL + "Status " + TextStyleClass.INFO + crafterTE.getProgress() + "%");
            } else if (crafterTE.getLastError() == null || crafterTE.getLastError().trim().isEmpty()) {
                probeInfo.text(TextStyleClass.LABEL + "Status " + TextStyleClass.INFO + "IDLE");
            } else {
                probeInfo.text(TextStyleClass.LABEL + "Status " + TextStyleClass.ERROR + crafterTE.getLastError());
            }
            if (crafterTE.getCraftingName() != null && !crafterTE.getCraftingName().trim().isEmpty()) {
                probeInfo.text(TextStyleClass.LABEL + "Name " + TextStyleClass.INFO + crafterTE.getCraftingName());
            }
            if (!(outputs = crafterTE.getOutputs()).isEmpty()) {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(TextStyleClass.LABEL + "Output ").item(crafterTE.func_70301_a(12));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
        ClientRegistry.bindTileEntitySpecialRenderer(CrafterTE.class, (TileEntitySpecialRenderer)new CrafterRenderer());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BiFunction<CrafterTE, CrafterContainer, GenericGuiContainer<? super CrafterTE>> getGuiFactory() {
        return CrafterGui::new;
    }

    @Override
    public int getGuiID() {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return EMPTY;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

