/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.blocks.boiler;

import mcjty.efab.blocks.GenericEFabTile;
import mcjty.efab.config.GeneralConfiguration;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BoilerTE
extends GenericEFabTile
implements ITickable {
    private float temperature = GeneralConfiguration.ambientBoilerTemperature;
    private double timer = 0.0;

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.timer = this.timer > 0.0 ? (this.timer -= 1.0) : 0.0;
        }
        if (this.hasHeatBelow()) {
            if (this.temperature < GeneralConfiguration.maxBoilerTemperature) {
                this.temperature += GeneralConfiguration.boilerRiseTemperature;
            }
        } else if (this.temperature > GeneralConfiguration.ambientBoilerTemperature) {
            this.temperature -= GeneralConfiguration.boilerCoolTemperature;
            if (this.temperature < GeneralConfiguration.ambientBoilerTemperature) {
                this.temperature = GeneralConfiguration.ambientBoilerTemperature;
            }
        }
        this.markDirtyQuick();
    }

    public float getTemperature() {
        return this.temperature;
    }

    public boolean canMakeSteam() {
        return this.temperature >= 100.0f;
    }

    private boolean hasHeatBelow() {
        return this.isHot(this.func_174877_v().func_177977_b());
    }

    public void setTimer(double timer) {
        this.timer = timer;
    }

    public double getTimer() {
        return this.timer;
    }

    private boolean isHot(BlockPos p) {
        IBlockState state = this.func_145831_w().func_180495_p(p);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150480_ab) {
            return true;
        }
        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            return true;
        }
        if (block == Blocks.field_189877_df) {
            return true;
        }
        return block.isBurning((IBlockAccess)this.func_145831_w(), p);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.temperature = tagCompound.func_74760_g("temperature");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74776_a("temperature", this.temperature);
        return super.func_189515_b(tagCompound);
    }
}

