/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.blocks.boiler;

import java.text.DecimalFormat;
import java.util.List;
import mcjty.efab.blocks.GenericEFabMultiBlockPart;
import mcjty.efab.blocks.boiler.BoilerRenderer;
import mcjty.efab.blocks.boiler.BoilerTE;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.EmptyContainer;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BoilerBlock
extends GenericEFabMultiBlockPart<BoilerTE, EmptyContainer> {
    public static final AxisAlignedBB EMPTY = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public BoilerBlock() {
        super(Material.field_151573_f, BoilerTE.class, EmptyContainer::new, "boiler", false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
        ClientRegistry.bindTileEntitySpecialRenderer(BoilerTE.class, (TileEntitySpecialRenderer)new BoilerRenderer());
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.HORIZROTATION;
    }

    public void func_190948_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, playerIn, tooltip, advanced);
        tooltip.add(TextFormatting.WHITE + "This block is needed for " + TextFormatting.GREEN + "steam" + TextFormatting.WHITE + " crafting");
        tooltip.add(TextFormatting.WHITE + "Needs a " + TextFormatting.GREEN + "steam engine" + TextFormatting.WHITE + " and a " + TextFormatting.GREEN + "tank" + TextFormatting.WHITE + " with water");
        tooltip.add(TextFormatting.WHITE + "and a heat source below (fire, lava, ...)");
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof BoilerTE) {
            BoilerTE boilerTE = (BoilerTE)te;
            DecimalFormat decimalFormat = new DecimalFormat("#.#");
            probeInfo.text(TextFormatting.GREEN + "Temperature: " + decimalFormat.format(boilerTE.getTemperature()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return EMPTY;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

