/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.blocks;

import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import mcjty.efab.blocks.GenericEFabBlockWithTE;
import mcjty.efab.blocks.GenericEFabTile;
import mcjty.efab.blocks.ModBlocks;
import mcjty.efab.blocks.grid.GridTE;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GenericEFabMultiBlockPart<T extends GenericEFabTile, C extends Container>
extends GenericEFabBlockWithTE<T, C> {
    public GenericEFabMultiBlockPart(Material material, Class<? extends T> tileEntityClass, BiFunction<EntityPlayer, IInventory, C> containerFactory, String name, boolean isContainer) {
        super(material, tileEntityClass, containerFactory, name, isContainer);
    }

    public GenericEFabMultiBlockPart(Material material, Class<? extends T> tileEntityClass, BiFunction<EntityPlayer, IInventory, C> containerFactory, Function<Block, ItemBlock> itemBlockFunction, String name, boolean isContainer) {
        super(material, tileEntityClass, containerFactory, itemBlockFunction, name, isContainer);
    }

    public int getGuiID() {
        return -1;
    }

    private void invalidateGrids(World world, BlockPos current, Set<BlockPos> visited) {
        if (visited.contains(current)) {
            return;
        }
        visited.add(current);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos p = current.func_177972_a(dir);
            Block block = world.func_180495_p(p).func_177230_c();
            if (block == ModBlocks.gridBlock) {
                TileEntity te = world.func_175625_s(p);
                if (te instanceof GridTE) {
                    ((GridTE)te).invalidateMultiBlockCache();
                }
                this.invalidateGrids(world, p, visited);
                continue;
            }
            if (block == ModBlocks.baseBlock) {
                this.invalidateGrids(world, p, visited);
                continue;
            }
            if (!(block instanceof GenericEFabMultiBlockPart)) continue;
            this.invalidateGrids(world, p, visited);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            this.invalidateGrids(world, pos, new HashSet<BlockPos>());
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            this.invalidateGrids(world, pos, new HashSet<BlockPos>());
        }
        super.func_180663_b(world, pos, state);
    }
}

