/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.common.IInventoryGui;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.library.smeltery.ISmelteryTankHandler;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.library.smeltery.SmelteryTank;
import slimeknights.tconstruct.library.utils.FluidUtil;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.smeltery.client.GuiSmeltery;
import slimeknights.tconstruct.smeltery.events.TinkerSmelteryEvent;
import slimeknights.tconstruct.smeltery.inventory.ContainerSmeltery;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockDetection;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockSmeltery;
import slimeknights.tconstruct.smeltery.network.SmelteryFluidUpdatePacket;
import slimeknights.tconstruct.smeltery.network.SmelteryInventoryUpdatePacket;
import slimeknights.tconstruct.smeltery.tileentity.TileHeatingStructureFuelTank;

public class TileSmeltery
extends TileHeatingStructureFuelTank<MultiblockSmeltery>
implements ITickable,
IInventoryGui,
ISmelteryTankHandler {
    public static final DamageSource smelteryDamage = new DamageSource("smeltery").func_76361_j();
    static final Logger log = Util.getLogger("Smeltery");
    public static final String TAG_INSIDEPOS = "insidePos";
    protected static final int CAPACITY_PER_BLOCK = 1152;
    protected static final int ALLOYING_PER_TICK = 10;
    protected SmelteryTank liquids;
    protected int tick;
    private BlockPos insideCheck;
    private int fullCheckCounter = 0;

    public TileSmeltery() {
        super("gui.smeltery.name", 0, 1);
        this.setMultiblock(new MultiblockSmeltery(this));
        this.liquids = new SmelteryTank(this);
    }

    public void func_73660_a() {
        if (this.isClientWorld()) {
            return;
        }
        if (!this.isActive()) {
            if (this.tick == 0) {
                this.checkMultiblockStructure();
            }
        } else {
            if (this.tick == 0) {
                this.interactWithEntitiesInside();
            }
            if (this.tick % 4 == 0) {
                this.heatItems();
                this.alloyAlloys();
            }
            if (this.needsFuel) {
                this.consumeFuel();
            }
            if (this.tick == 0) {
                if (++this.fullCheckCounter >= 15) {
                    this.fullCheckCounter = 0;
                    this.checkMultiblockStructure();
                } else {
                    this.updateInsideCheck();
                    if (!this.func_145831_w().func_175623_d(this.insideCheck)) {
                        this.setInvalid();
                        this.insideCheck = null;
                        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
                        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
                    } else {
                        this.progressInsideCheck();
                    }
                }
            }
        }
        this.tick = (this.tick + 1) % 20;
    }

    private void updateInsideCheck() {
        if (this.insideCheck == null || this.insideCheck.func_177958_n() < this.minPos.func_177958_n() || this.insideCheck.func_177956_o() < this.minPos.func_177956_o() || this.insideCheck.func_177952_p() < this.minPos.func_177952_p() || this.insideCheck.func_177958_n() > this.maxPos.func_177958_n() || this.insideCheck.func_177956_o() > this.maxPos.func_177956_o() || this.insideCheck.func_177952_p() > this.maxPos.func_177952_p()) {
            this.insideCheck = this.minPos;
        }
    }

    private void progressInsideCheck() {
        this.insideCheck = this.insideCheck.func_177982_a(1, 0, 0);
        if (this.insideCheck.func_177958_n() > this.maxPos.func_177958_n()) {
            this.insideCheck = new BlockPos(this.minPos.func_177958_n(), this.insideCheck.func_177956_o(), this.insideCheck.func_177952_p() + 1);
            if (this.insideCheck.func_177952_p() > this.maxPos.func_177952_p()) {
                this.insideCheck = new BlockPos(this.minPos.func_177958_n(), this.insideCheck.func_177956_o() + 1, this.minPos.func_177952_p());
            }
        }
    }

    @Override
    protected void updateHeatRequired(int index) {
        MeltingRecipe melting;
        ItemStack stack = this.func_70301_a(index);
        if (!stack.func_190926_b() && (melting = TinkerRegistry.getMelting(stack)) != null) {
            this.setHeatRequiredForSlot(index, Math.max(5, melting.getUsableTemperature()));
            if (!this.hasFuel()) {
                this.consumeFuel();
            }
            return;
        }
        this.setHeatRequiredForSlot(index, 0);
    }

    @Override
    protected boolean onItemFinishedHeating(ItemStack stack, int slot) {
        MeltingRecipe recipe = TinkerRegistry.getMelting(stack);
        if (recipe == null) {
            return false;
        }
        TinkerSmelteryEvent.OnMelting event = TinkerSmelteryEvent.OnMelting.fireEvent(this, stack, recipe.output.copy());
        FluidStack fluidStack = FluidUtil.getValidFluidStackOrNull(event.result);
        int filled = this.liquids.fill(fluidStack, false);
        if (filled == fluidStack.amount) {
            this.liquids.fill(fluidStack, true);
            this.func_70299_a(slot, ItemStack.field_190927_a);
            return true;
        }
        this.itemTemperatures[slot] = this.itemTempRequired[slot] * 2 + 1;
        return false;
    }

    protected void interactWithEntitiesInside() {
        AxisAlignedBB bb = this.info.getBoundingBox().func_191195_a(-2.0, -1.0, -2.0).func_72317_d(-1.0, 0.0, -1.0);
        List entities = this.func_145831_w().func_72872_a(Entity.class, bb);
        block0: for (Entity entity : entities) {
            if (entity instanceof EntityItem) {
                if (TinkerRegistry.getMelting(((EntityItem)entity).func_92059_d()) == null) continue;
                ItemStack stack = ((EntityItem)entity).func_92059_d();
                for (int i = 0; i < this.func_70302_i_(); ++i) {
                    if (!this.isStackInSlot(i)) {
                        ItemStack invStack = stack.func_77946_l();
                        stack.func_190918_g(1);
                        invStack.func_190920_e(1);
                        this.func_70299_a(i, invStack);
                    }
                    if (!stack.func_190926_b()) continue;
                    entity.func_70106_y();
                    continue block0;
                }
                continue;
            }
            if (this.liquids.getFluidAmount() <= 0) continue;
            FluidStack fluid = TinkerRegistry.getMeltingForEntity(entity);
            if (fluid == null && entity instanceof EntityLivingBase && entity.func_70089_S() && !entity.field_70128_L) {
                fluid = new FluidStack((Fluid)TinkerFluids.blood, 20);
            }
            if (fluid == null || !entity.func_70097_a(smelteryDamage, 2.0f)) continue;
            this.liquids.fill(fluid.copy(), true);
        }
    }

    protected void alloyAlloys() {
        for (AlloyRecipe recipe : TinkerRegistry.getAlloys()) {
            if (!recipe.isValid()) continue;
            int matched = recipe.matches(this.liquids.getFluids());
            if (matched > 10) {
                matched = 10;
            }
            while (matched > 0) {
                for (FluidStack liquid : recipe.getFluids()) {
                    FluidStack toDrain = liquid.copy();
                    FluidStack drained = this.liquids.drain(toDrain, true);
                    assert (drained != null);
                    if (drained.isFluidEqual(toDrain) && drained.amount == toDrain.amount) continue;
                    log.error("Smeltery alloy creation drained incorrect amount: was %s:%d, should be %s:%d", (Object)drained.getUnlocalizedName(), (Object)drained.amount, (Object)toDrain.getUnlocalizedName(), (Object)toDrain.amount);
                }
                FluidStack toFill = FluidUtil.getValidFluidStackOrNull(recipe.getResult().copy());
                int filled = this.liquids.fill(toFill, true);
                if (filled != recipe.getResult().amount) {
                    log.error("Smeltery alloy creation filled incorrect amount: was %d, should be %d (%s)", (Object)filled, (Object)(recipe.getResult().amount * matched), (Object)recipe.getResult().getUnlocalizedName());
                }
                matched -= filled;
            }
        }
    }

    @Override
    protected void updateStructureInfo(MultiblockDetection.MultiblockStructure structure) {
        super.updateStructureInfo(structure);
        this.liquids.setCapacity(this.func_70302_i_() * 1152);
    }

    @Override
    protected boolean hasCeiling() {
        return false;
    }

    @Override
    protected int getUpdatedInventorySize(int width, int height, int depth) {
        return width * height * depth;
    }

    @Override
    public SmelteryTank getTank() {
        return this.liquids;
    }

    public Container createContainer(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new ContainerSmeltery(inventoryplayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new GuiSmeltery((ContainerSmeltery)this.createContainer(inventoryplayer, world, pos), this);
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.minPos == null || this.maxPos == null) {
            return super.getRenderBoundingBox();
        }
        return new AxisAlignedBB((double)this.minPos.func_177958_n(), (double)this.minPos.func_177956_o(), (double)this.minPos.func_177952_p(), (double)(this.maxPos.func_177958_n() + 1), (double)(this.maxPos.func_177956_o() + 1), (double)(this.maxPos.func_177952_p() + 1));
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        if (this.func_145831_w() != null && this.func_145831_w() instanceof WorldServer && !this.func_145831_w().field_72995_K && !ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)this.func_70301_a(slot))) {
            TinkerNetwork.sendToClients((WorldServer)this.func_145831_w(), this.field_174879_c, (AbstractPacket)new SmelteryInventoryUpdatePacket(itemstack, slot, this.field_174879_c));
        }
        super.func_70299_a(slot, itemstack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateFluidsFromPacket(List<FluidStack> fluids) {
        this.liquids.setFluids(fluids);
    }

    @Override
    public void onTankChanged(List<FluidStack> fluids, FluidStack changed) {
        if (this.isServerWorld()) {
            TinkerNetwork.sendToAll((AbstractPacket)new SmelteryFluidUpdatePacket(this.field_174879_c, fluids));
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        this.liquids.writeToNBT(compound);
        compound.func_74782_a(TAG_INSIDEPOS, (NBTBase)TagUtil.writePos(this.insideCheck));
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.liquids.readFromNBT(compound);
        this.insideCheck = TagUtil.readPos(compound.func_74775_l(TAG_INSIDEPOS));
    }
}

