/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.misc;

import appeng.bootstrap.IItemRendering;
import appeng.bootstrap.ItemRenderingCustomizer;
import appeng.items.misc.ItemCrystalSeed;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCrystalSeedRendering
extends ItemRenderingCustomizer {
    private static final ModelResourceLocation[] MODELS_CERTUS = new ModelResourceLocation[]{new ModelResourceLocation("appliedenergistics2:crystal_seed_certus"), new ModelResourceLocation("appliedenergistics2:crystal_seed_certus2"), new ModelResourceLocation("appliedenergistics2:crystal_seed_certus3")};
    private static final ModelResourceLocation[] MODELS_FLUIX = new ModelResourceLocation[]{new ModelResourceLocation("appliedenergistics2:crystal_seed_fluix"), new ModelResourceLocation("appliedenergistics2:crystal_seed_fluix2"), new ModelResourceLocation("appliedenergistics2:crystal_seed_fluix3")};
    private static final ModelResourceLocation[] MODELS_NETHER = new ModelResourceLocation[]{new ModelResourceLocation("appliedenergistics2:crystal_seed_nether"), new ModelResourceLocation("appliedenergistics2:crystal_seed_nether2"), new ModelResourceLocation("appliedenergistics2:crystal_seed_nether3")};

    @Override
    @SideOnly(value=Side.CLIENT)
    public void customize(IItemRendering rendering) {
        rendering.variants((Collection<ResourceLocation>)ImmutableList.builder().add((Object[])MODELS_CERTUS).add((Object[])MODELS_FLUIX).add((Object[])MODELS_NETHER).build());
        rendering.meshDefinition(this.getItemMeshDefinition());
    }

    private ItemMeshDefinition getItemMeshDefinition() {
        return is -> {
            ModelResourceLocation[] models;
            int damage = ItemCrystalSeed.getProgress(is);
            int type = damage / 600;
            int level = damage % 600 / 200;
            switch (type) {
                case 0: {
                    models = MODELS_CERTUS;
                    break;
                }
                case 1: {
                    models = MODELS_NETHER;
                    break;
                }
                case 2: {
                    models = MODELS_FLUIX;
                    break;
                }
                default: {
                    models = MODELS_CERTUS;
                }
            }
            if (level < 0) {
                level = 0;
            } else if (level >= models.length) {
                level = models.length - 1;
            }
            return models[level];
        };
    }
}

