/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.api.hunger;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class HealthRegenEvent
extends Event {
    public final EntityPlayer player;

    public HealthRegenEvent(EntityPlayer player) {
        this.player = player;
    }

    @Cancelable
    public static class SaturatedRegen
    extends HealthRegenEvent {
        public float deltaHealth;
        public float deltaExhaustion;

        public SaturatedRegen(EntityPlayer player) {
            super(player);
            this.deltaExhaustion = Math.min(player.func_71024_bL().func_75115_e(), 4.0f);
            this.deltaHealth = this.deltaExhaustion / 4.0f;
        }
    }

    public static class GetSaturatedRegenTickPeriod
    extends HealthRegenEvent {
        public int regenTickPeriod = 10;

        public GetSaturatedRegenTickPeriod(EntityPlayer player) {
            super(player);
        }
    }

    @Event.HasResult
    public static class AllowSaturatedRegen
    extends HealthRegenEvent {
        public AllowSaturatedRegen(EntityPlayer player) {
            super(player);
        }
    }

    @Cancelable
    public static class PeacefulRegen
    extends HealthRegenEvent {
        public float deltaHealth = 1.0f;

        public PeacefulRegen(EntityPlayer player) {
            super(player);
        }
    }

    @Cancelable
    public static class Regen
    extends HealthRegenEvent {
        public float deltaHealth = 1.0f;
        public float deltaExhaustion = 4.0f;

        public Regen(EntityPlayer player) {
            super(player);
        }
    }

    public static class GetRegenTickPeriod
    extends HealthRegenEvent {
        public int regenTickPeriod = 80;

        public GetRegenTickPeriod(EntityPlayer player) {
            super(player);
        }
    }

    @Event.HasResult
    public static class AllowRegen
    extends HealthRegenEvent {
        public AllowRegen(EntityPlayer player) {
            super(player);
        }
    }
}

