/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.itemhandler.IItemHandlerCompat;
import com.rwtema.extrautils2.itemhandler.XUTileItemStackHandler;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.utils.ItemStackNonNull;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.XURandom;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import gnu.trove.map.hash.TObjectIntHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileTrashChest
extends XUTile
implements IDynamicHandler {
    static final int BUFFER_SIZE = 27;
    private final XUTileItemStackHandler contents = this.registerNBT("contents", new XUTileItemStackHandler(27, this));
    private final NBTSerializable.NBTIntArray priorities = this.registerNBT("priority", new NBTSerializable.NBTIntArray(new int[27]));
    int[] ordering;
    private final IItemHandlerCompat insertion_handler = new IItemHandlerCompat(){

        @Override
        public int getSlots() {
            return 47;
        }

        @Override
        @ItemStackNonNull
        public ItemStack getStackInSlot(int slot) {
            if (slot < 27) {
                return TileTrashChest.this.contents.getStackInSlot(slot);
            }
            return StackHelper.empty();
        }

        @Override
        @ItemStackNonNull
        public ItemStack insertItem(int slot, @ItemStackNonNull ItemStack stack, boolean simulate) {
            if (!simulate) {
                if (slot < 27) {
                    stack = TileTrashChest.this.contents.insertItem(slot, stack, false);
                }
                TileTrashChest.this.insertStack(stack);
            }
            return StackHelper.empty();
        }

        @Override
        @ItemStackNonNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot < 27) {
                return TileTrashChest.this.contents.extractItem(slot, amount, false);
            }
            return StackHelper.empty();
        }
    };

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        return this.insertion_handler;
    }

    public void insertStack(ItemStack stack) {
        if (StackHelper.isEmpty(stack)) {
            return;
        }
        int fallback = -1;
        boolean hasDuplicates = false;
        for (int i = 0; i < this.contents.getSlots(); ++i) {
            ItemStack stackInSlot = this.contents.getStackInSlot(i);
            if (StackHelper.isEmpty(stackInSlot)) {
                if (fallback != -1) continue;
                fallback = i;
                continue;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) continue;
            hasDuplicates = true;
            if (!StackHelper.isEmpty(stack = this.contents.insertItem(i, stack, false))) continue;
            return;
        }
        if (fallback != -1) {
            this.contents.setStackInSlot(fallback, stack);
            return;
        }
        if (hasDuplicates) {
            return;
        }
        TObjectIntHashMap curSlot = new TObjectIntHashMap();
        for (int i = 0; i < this.contents.getSlots(); ++i) {
            ItemStack stackInSlot = this.contents.getStackInSlot(i);
            if (StackHelper.isEmpty(stackInSlot)) {
                this.contents.setStackInSlot(i, stack);
                return;
            }
            ItemRef ref = ItemRef.wrap(stackInSlot);
            if (curSlot.containsKey((Object)ref)) {
                int j = curSlot.get((Object)ref);
                this.contents.insertItem(j, stackInSlot, false);
                this.contents.setStackInSlot(i, stack);
                return;
            }
            curSlot.put((Object)ref, i);
        }
        curSlot.clear();
        this.ordering = XURandom.createRandomOrder(this.contents.getSlots(), this.ordering);
        for (int i : this.ordering) {
            ItemStack stackInSlot = this.contents.getStackInSlot(i);
            if (StackHelper.isEmpty(stackInSlot)) {
                this.contents.setStackInSlot(i, stack);
                return;
            }
            ItemRef ref = ItemRef.wrapCrafting(stackInSlot);
            if (curSlot.containsKey((Object)ref)) {
                int j = curSlot.get((Object)ref);
                this.contents.insertItem(j, stack, false);
                this.contents.setStackInSlot(i, stack);
                return;
            }
            curSlot.put((Object)ref, i);
        }
        int i = XURandom.rand.nextInt(27);
        this.contents.setStackInSlot(i, stack);
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerTrashChest(this, player);
    }

    public static class ContainerTrashChest
    extends DynamicContainerTile {
        private TileTrashChest trashChest;

        public ContainerTrashChest(TileTrashChest tile, EntityPlayer player) {
            super(tile);
            this.trashChest = tile;
            this.addTitle(Lang.getItemName(tile.getXUBlock()), false);
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 9; ++k) {
                    this.addWidget(new WidgetSlotItemHandler((IItemHandler)tile.contents, k + j * 9, 4 + k * 18, 17 + j * 18));
                }
            }
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }

        @Override
        @ItemStackNonNull
        public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int par2) {
            ItemStack itemstack = StackHelper.empty();
            Slot slot = (Slot)this.field_75151_b.get(par2);
            if (par2 >= this.playerSlotsStart) {
                if (slot != null && slot.func_75216_d()) {
                    ItemStack otherItemStack = slot.func_75211_c();
                    if (StackHelper.isNull(otherItemStack)) {
                        return StackHelper.empty();
                    }
                    itemstack = otherItemStack.func_77946_l();
                    if (!((TileTrashChest)this.trashChest).field_145850_b.field_72995_K) {
                        this.trashChest.insertStack(otherItemStack);
                    }
                    slot.func_75215_d(StackHelper.empty());
                }
                return itemstack;
            }
            return super.func_82846_b(par1EntityPlayer, par2);
        }
    }
}

