/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.textures;

import com.rwtema.extrautils2.blocks.BlockScreen;
import com.rwtema.extrautils2.tile.TileScreen;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ImgurTextureHolder {
    public static final ResourceLocation loading_texture = new ResourceLocation("extrautils2", "textures/screen_loading.png");
    public static final ResourceLocation noSignal_texture = new ResourceLocation("extrautils2", "textures/screen_no_signal.png");
    public static final ResourceLocation error_texture = new ResourceLocation("extrautils2", "textures/screen_error.png");
    private static final Pattern patternControlCode = TileScreen.illegalPatternControlCode;
    private static final Logger logger = LogManager.getLogger();
    private static final AtomicInteger threadDownloadCounter = new AtomicInteger(0);
    public static ImgurTextureHolder _default = new ImgurTextureHolder(loading_texture);
    private static HashMap<String, ImgurTextureHolder> holder = new HashMap();
    public ResourceLocation resourceLocation;
    public boolean deleteOldTexture;
    public SimpleTexture img;
    public BufferedImage image;
    public int width = 32;
    public int height = 32;
    public float u0 = 0.0f;
    public float u1 = 1.0f;
    public float v0 = 0.0f;
    public float v1 = 1.0f;

    public ImgurTextureHolder(ResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public ImgurTextureHolder(String key) {
        key = patternControlCode.matcher(key).replaceAll("");
        String url = "https://i.imgur.com/" + key + ".png";
        this.img = new XUDownloadImageData(null, url, loading_texture, new IImageBuffer(){

            @Nonnull
            public BufferedImage func_78432_a(@Nonnull BufferedImage image) {
                if (image == null) {
                    return null;
                }
                int w = image.getWidth();
                int h = image.getHeight();
                ImgurTextureHolder.this.width = ImgurTextureHolder.nextPower2(w);
                ImgurTextureHolder.this.height = ImgurTextureHolder.nextPower2(h);
                BufferedImage newImage = new BufferedImage(ImgurTextureHolder.this.width, ImgurTextureHolder.this.height, 2);
                Graphics graphics = newImage.getGraphics();
                int x = (ImgurTextureHolder.this.width - w) / 2;
                int y = (ImgurTextureHolder.this.height - h) / 2;
                ImgurTextureHolder.this.u0 = (float)x / (float)ImgurTextureHolder.this.width;
                ImgurTextureHolder.this.u1 = ((float)x + (float)w) / (float)ImgurTextureHolder.this.width;
                ImgurTextureHolder.this.v0 = (float)y / (float)ImgurTextureHolder.this.height;
                ImgurTextureHolder.this.v1 = ((float)y + (float)h) / (float)ImgurTextureHolder.this.height;
                graphics.setColor(Color.BLACK);
                graphics.fillRect(0, 0, ImgurTextureHolder.this.width, ImgurTextureHolder.this.height);
                graphics.drawImage(image, x, y, null);
                graphics.dispose();
                ImgurTextureHolder.this.image = newImage;
                return newImage;
            }

            public void func_152634_a() {
            }
        });
        this.resourceLocation = new ResourceLocation("extrautils2", "texures/imgur/" + key);
        Minecraft.func_71410_x().field_71446_o.func_110579_a(this.resourceLocation, (ITextureObject)this.img);
    }

    public static ImgurTextureHolder getTex(String tex) {
        if (tex.length() == 0) {
            return _default;
        }
        ImgurTextureHolder imgurTextureHolder = holder.get(tex);
        if (imgurTextureHolder != null) {
            return imgurTextureHolder;
        }
        imgurTextureHolder = new ImgurTextureHolder(tex);
        holder.put(tex, imgurTextureHolder);
        return imgurTextureHolder;
    }

    public static int nextPower2(int v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return ++v;
    }

    public ResourceLocation getResourceLocationForBinding() {
        if (this.deleteOldTexture) {
            this.img.func_147631_c();
            this.deleteOldTexture = false;
        }
        return this.resourceLocation;
    }

    public class XUDownloadImageData
    extends SimpleTexture {
        private final File cacheFile;
        private final String imageUrl;
        private final IImageBuffer imageBuffer;
        private BufferedImage bufferedImage;
        private Thread imageThread;
        private boolean textureUploaded;

        public XUDownloadImageData(File cacheFileIn, String imageUrlIn, ResourceLocation textureResourceLocation, IImageBuffer imageBufferIn) {
            super(textureResourceLocation);
            this.cacheFile = cacheFileIn;
            this.imageUrl = imageUrlIn;
            this.imageBuffer = imageBufferIn;
        }

        private void checkTextureUploaded() {
            if (!this.textureUploaded && this.bufferedImage != null) {
                if (this.field_110568_b != null) {
                    this.func_147631_c();
                }
                TextureUtil.func_110987_a((int)super.func_110552_b(), (BufferedImage)this.bufferedImage);
                this.textureUploaded = true;
            }
        }

        public int func_110552_b() {
            this.checkTextureUploaded();
            return super.func_110552_b();
        }

        public void setBufferedImage(BufferedImage bufferedImageIn) {
            this.bufferedImage = bufferedImageIn;
            if (this.imageBuffer != null) {
                this.imageBuffer.func_152634_a();
            }
        }

        public void func_110551_a(IResourceManager resourceManager) throws IOException {
            if (this.bufferedImage == null && this.field_110568_b != null) {
                super.func_110551_a(resourceManager);
            }
            if (this.imageThread == null) {
                if (this.cacheFile != null && this.cacheFile.isFile()) {
                    logger.debug("Loading http texture from local cache ({})", (Object)this.cacheFile);
                    try {
                        this.bufferedImage = ImageIO.read(this.cacheFile);
                        if (this.imageBuffer != null) {
                            this.setBufferedImage(this.imageBuffer.func_78432_a(this.bufferedImage));
                        }
                    }
                    catch (IOException ioexception) {
                        logger.error("Couldn't load texture " + this.cacheFile, (Throwable)ioexception);
                        this.loadTextureFromServer();
                    }
                } else {
                    this.loadTextureFromServer();
                }
            }
        }

        protected void loadTextureFromServer() {
            this.imageThread = new Thread("XU Texture Downloader #" + threadDownloadCounter.incrementAndGet()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpURLConnection httpurlconnection = null;
                    logger.debug("Downloading http texture from {} to {}", (Object)XUDownloadImageData.this.imageUrl, (Object)XUDownloadImageData.this.cacheFile);
                    try {
                        httpurlconnection = (HttpURLConnection)new URL(XUDownloadImageData.this.imageUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
                        httpurlconnection.setDoInput(true);
                        httpurlconnection.setDoOutput(false);
                        httpurlconnection.connect();
                        if (httpurlconnection.getResponseCode() / 100 == 2) {
                            int contentLength = httpurlconnection.getContentLength();
                            if (BlockScreen.maxSize > 0 && contentLength > BlockScreen.maxSize) {
                                logger.debug(contentLength + " is larger than " + BlockScreen.maxSize);
                                ImgurTextureHolder.this.resourceLocation = error_texture;
                                ImgurTextureHolder.this.deleteOldTexture = true;
                            } else {
                                BufferedImage bufferedimage;
                                if (XUDownloadImageData.this.cacheFile != null) {
                                    FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)XUDownloadImageData.this.cacheFile);
                                    bufferedimage = ImageIO.read(XUDownloadImageData.this.cacheFile);
                                } else {
                                    bufferedimage = TextureUtil.func_177053_a((InputStream)httpurlconnection.getInputStream());
                                }
                                if (XUDownloadImageData.this.imageBuffer != null) {
                                    bufferedimage = XUDownloadImageData.this.imageBuffer.func_78432_a(bufferedimage);
                                }
                                XUDownloadImageData.this.setBufferedImage(bufferedimage);
                            }
                        } else {
                            ImgurTextureHolder.this.resourceLocation = noSignal_texture;
                            ImgurTextureHolder.this.deleteOldTexture = true;
                        }
                    }
                    catch (Exception exception) {
                        logger.error("Couldn't download http texture", (Throwable)exception);
                        ImgurTextureHolder.this.resourceLocation = error_texture;
                        ImgurTextureHolder.this.deleteOldTexture = true;
                    }
                    finally {
                        if (httpurlconnection != null) {
                            httpurlconnection.disconnect();
                        }
                    }
                }
            };
            this.imageThread.setDaemon(true);
            this.imageThread.start();
        }
    }
}

