/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbguides.handlers;

import com.feed_the_beast.ftbguides.FTBGuidesCommon;
import com.feed_the_beast.ftbguides.FTBGuidesConfig;
import com.feed_the_beast.ftbguides.client.FTBGuidesClient;
import com.feed_the_beast.ftblib.events.FTBLibPreInitRegistryEvent;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ISyncData;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.google.gson.JsonElement;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="ftbguides")
public class FTBGuidesEventHandler {
    @SubscribeEvent
    public static void onFTBLibPreInitRegistry(FTBLibPreInitRegistryEvent event) {
        FTBLibPreInitRegistryEvent.Registry registry = event.getRegistry();
        registry.registerServerReloadHandler(new ResourceLocation("ftbguides", "config"), reloadEvent -> FTBGuidesConfig.sync());
        registry.registerServerReloadHandler(new ResourceLocation("ftbguides", "server_info"), reloadEvent -> FTBGuidesCommon.reloadServerGuide());
        registry.registerSyncData("ftbguides", new ISyncData(){

            public NBTTagCompound writeSyncData(EntityPlayerMP player, ForgePlayer forgePlayer) {
                NBTTagCompound nbt = new NBTTagCompound();
                NBTBase data = JsonUtils.toNBT((JsonElement)FTBGuidesCommon.getServerGuide(player.field_71133_b));
                if (data != null) {
                    nbt.func_74782_a("Data", data);
                }
                return nbt;
            }

            @SideOnly(value=Side.CLIENT)
            public void readSyncData(NBTTagCompound nbt) {
                FTBGuidesClient.loadServerGuide(JsonUtils.toJson((NBTBase)nbt.func_74781_a("Data")));
            }
        });
    }
}

