/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbguides.gui.components;

import com.feed_the_beast.ftbguides.events.CreateGuideComponentEvent;
import com.feed_the_beast.ftbguides.gui.GuidePage;
import com.feed_the_beast.ftbguides.gui.components.CodeblockGuideComponent;
import com.feed_the_beast.ftbguides.gui.components.CombinedGuideComponent;
import com.feed_the_beast.ftbguides.gui.components.ComponentPanel;
import com.feed_the_beast.ftbguides.gui.components.EmptyGuideComponent;
import com.feed_the_beast.ftbguides.gui.components.HRGuideComponent;
import com.feed_the_beast.ftbguides.gui.components.IGuideComponentWidget;
import com.feed_the_beast.ftbguides.gui.components.ImageGuideComponent;
import com.feed_the_beast.ftbguides.gui.components.LineBreakGuideComponent;
import com.feed_the_beast.ftbguides.gui.components.ListOrdering;
import com.feed_the_beast.ftbguides.gui.components.TableGuideComponent;
import com.feed_the_beast.ftbguides.gui.components.TextGuideComponent;
import com.feed_the_beast.ftbguides.gui.components.VideoGuideComponent;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.URLImageIcon;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public abstract class GuideComponent {
    public GuideComponent parent = null;
    public Map<String, String> properties = null;

    public boolean isEmpty() {
        return false;
    }

    public abstract IGuideComponentWidget createWidget(ComponentPanel var1);

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public String getProperty(String key, boolean includeParent) {
        String p;
        String string = p = this.hasProperties() ? this.properties.get(key) : null;
        return p == null ? (this.parent == null || !includeParent ? "" : this.parent.getProperty(key, true)) : p;
    }

    public final String getProperty(String key, boolean includeParent, String def) {
        String s = this.getProperty(key, includeParent);
        return s.isEmpty() ? def : s;
    }

    public final GuideComponent setProperty(String key, String value) {
        if (!value.isEmpty()) {
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            this.properties.put(key, value);
        } else if (this.properties != null) {
            this.properties.remove(key);
            if (this.properties.isEmpty()) {
                this.properties = null;
            }
        }
        return this;
    }

    public final void setProperty(String key, @Nullable JsonElement json) {
        this.setProperty(key, JsonUtils.isNull((JsonElement)json) ? "" : json.getAsString());
    }

    public boolean isInline() {
        return true;
    }

    public static String fixHtmlString(String s) {
        return s.isEmpty() ? "" : StringUtils.fixTabs((String)s, (int)2).replace("&gt;", ">").replace("&lt;", "<").replace("&amp;", "&");
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static double parseSize(double original, String s) {
        if (s.isEmpty()) {
            return original;
        }
        if (s.endsWith("%")) {
            return original * Double.parseDouble(s.substring(0, s.length() - 1)) / 100.0;
        }
        if (s.endsWith("px")) {
            return Double.parseDouble(s.substring(0, s.length() - 2));
        }
        if (s.endsWith("x")) {
            double x = Double.parseDouble(s.substring(0, s.length() - 1));
            return x >= 0.0 ? original * x : original * (1.0 / x);
        }
        return Double.parseDouble(s.substring(0, s.length() - 2));
    }

    public static GuideComponent create(GuidePage page, @Nullable JsonElement json) {
        Iterable<String> list;
        if (JsonUtils.isNull((JsonElement)json)) {
            return EmptyGuideComponent.INSTANCE;
        }
        if (json.isJsonPrimitive()) {
            String s = json.getAsString();
            if (s.isEmpty()) {
                return EmptyGuideComponent.INSTANCE;
            }
            if (s.equals("\n")) {
                return LineBreakGuideComponent.INSTANCE;
            }
            return new TextGuideComponent(GuideComponent.fixHtmlString(s));
        }
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            if (array.size() == 0) {
                return EmptyGuideComponent.INSTANCE;
            }
            if (array.size() == 1) {
                return GuideComponent.create(page, array.get(0));
            }
            CombinedGuideComponent component = new CombinedGuideComponent();
            for (JsonElement e : array) {
                GuideComponent c1 = GuideComponent.create(page, e);
                if (c1.isEmpty()) continue;
                component.add(c1);
            }
            return component.isEmpty() ? EmptyGuideComponent.INSTANCE : component;
        }
        JsonObject object = json.getAsJsonObject();
        if (object.size() == 0) {
            return EmptyGuideComponent.INSTANCE;
        }
        if (object.has("br")) {
            return LineBreakGuideComponent.INSTANCE;
        }
        if (object.has("hr")) {
            return HRGuideComponent.INSTANCE;
        }
        Object component = EmptyGuideComponent.INSTANCE;
        if (object.has("h1")) {
            component = GuideComponent.create(page, object.get("h1")).setProperty("text_scale", "1.5").setProperty("bold", "true");
        } else if (object.has("h2")) {
            component = GuideComponent.create(page, object.get("h2")).setProperty("text_scale", "1.5");
        } else if (object.has("h3")) {
            component = GuideComponent.create(page, object.get("h3")).setProperty("text_scale", "1.25");
        } else if (object.has("img")) {
            Color4I icon = Icon.EMPTY;
            if (object.has("img_url")) {
                icon = page.getIcon(object.get("img_url").getAsString());
            } else if (object.has("img")) {
                icon = page.getIcon(object.get("img").getAsString());
            }
            if (!(!(icon instanceof URLImageIcon) || object.has("img_width") && object.has("img_height"))) {
                try {
                    BufferedImage image = ImageIO.read(new URL(icon.toString()));
                    object.addProperty("img_width", Integer.toString(image.getWidth()));
                    object.addProperty("img_height", Integer.toString(image.getHeight()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    icon = Icon.EMPTY;
                }
            }
            if (!icon.isEmpty()) {
                int iw = object.has("img_width") ? object.get("img_width").getAsInt() : 16;
                int ih = object.has("img_height") ? object.get("img_height").getAsInt() : 16;
                int w = (int)GuideComponent.parseSize(iw, object.has("width") ? object.get("width").getAsString() : "");
                int h = (int)GuideComponent.parseSize(ih, object.has("height") ? object.get("height").getAsString() : "");
                if (w > 0 && h > 0) {
                    component = new ImageGuideComponent((Icon)icon, w, h);
                }
            }
        } else if (object.has("codeblock")) {
            list = new ArrayList();
            for (JsonElement e : object.get("codeblock").getAsJsonArray()) {
                if (e.isJsonPrimitive()) {
                    list.add((String)GuideComponent.fixHtmlString(e.getAsString()));
                    continue;
                }
                list.add((String)(TextFormatting.RED + GuideComponent.fixHtmlString(e.toString())));
            }
            component = new CodeblockGuideComponent((List<String>)list);
        } else if (object.has("list")) {
            list = new TableGuideComponent();
            TableGuideComponent.HeadCellComponent left = ((TableGuideComponent)list).addRow();
            left.setProperty("align", "right");
            TableGuideComponent.HeadCellComponent right = ((TableGuideComponent)list).addRow();
            ((GuideComponent)((Object)list)).setProperty("borders", "false");
            ((GuideComponent)((Object)list)).setProperty("padding", "0");
            ((TableGuideComponent)list).hasHead = false;
            ((GuideComponent)((Object)list)).setProperty("ordering", object.get("ordering"));
            ListOrdering ordering = (ListOrdering)((Object)ListOrdering.NAME_MAP.get(((GuideComponent)((Object)list)).getProperty("ordering", true)));
            JsonArray array = object.get("list").getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                TableGuideComponent.CellComponent leftc = new TableGuideComponent.CellComponent(left);
                leftc.add(ordering.createComponent(i));
                ((CombinedGuideComponent)list).add(leftc);
                TableGuideComponent.CellComponent rightc = new TableGuideComponent.CellComponent(right);
                rightc.add(GuideComponent.create(page, array.get(i)));
                ((CombinedGuideComponent)list).add(rightc);
            }
            component = list;
        } else if (object.has("table")) {
            TableGuideComponent table = new TableGuideComponent();
            if (object.has("head")) {
                table.hasHead = true;
                for (Iterator element : object.get("head").getAsJsonArray()) {
                    TableGuideComponent.HeadCellComponent head = table.addRow();
                    head.add(GuideComponent.create(page, (JsonElement)element));
                }
            } else {
                table.hasHead = false;
                int r = 0;
                for (JsonElement element : object.get("table").getAsJsonArray()) {
                    r = Math.max(r, element.getAsJsonArray().size());
                }
            }
            for (Iterator element : object.get("table").getAsJsonArray()) {
                JsonArray array = element.getAsJsonArray();
                if (array.size() != table.rows.size()) continue;
                for (int i = 0; i < array.size(); ++i) {
                    TableGuideComponent.CellComponent component1 = new TableGuideComponent.CellComponent(table.rows.get(i));
                    JsonElement element1 = array.get(i);
                    if (element1.isJsonArray()) {
                        for (JsonElement element2 : element1.getAsJsonArray()) {
                            if (!component1.components.isEmpty()) {
                                component1.add(LineBreakGuideComponent.INSTANCE);
                            }
                            component1.add(GuideComponent.create(page, element2));
                        }
                    } else {
                        component1.add(GuideComponent.create(page, element1));
                    }
                    table.add(component1);
                }
            }
            table.setProperty("borders", object.get("borders"));
            table.setProperty("padding", object.get("padding"));
            component = table;
        } else if (object.has("yt")) {
            String id = object.get("yt").getAsString();
            component = new VideoGuideComponent(page.getIcon("https://img.youtube.com/vi/" + id + "/maxresdefault.jpg"), 480, 270);
            object.addProperty("click", "https://youtu.be/" + id);
            object.addProperty("hover", I18n.func_135052_a((String)"ftbguides.lang.open_in_browser", (Object[])new Object[0]));
        } else if (object.has("text") || object.has("code")) {
            component = new TextGuideComponent((object.has("text") ? object.get("text") : object.get("code")).getAsString());
            ((GuideComponent)component).setProperty("bold", object.get("bold"));
            ((GuideComponent)component).setProperty("italic", object.get("italic"));
            ((GuideComponent)component).setProperty("underlined", object.get("underlined"));
            ((GuideComponent)component).setProperty("bold", object.get("bold"));
            if (object.has("text")) {
                ((GuideComponent)component).setProperty("code", object.get("code"));
            } else {
                ((GuideComponent)component).setProperty("code", "true");
            }
        }
        if (((GuideComponent)component).isEmpty()) {
            CreateGuideComponentEvent event = new CreateGuideComponentEvent(page, object);
            event.post();
            component = event.getComponent();
        }
        if (((GuideComponent)component).isEmpty()) {
            component = new TextGuideComponent(TextFormatting.RED + object.toString());
        } else {
            ((GuideComponent)component).setProperty("click", object.get("click"));
            ((GuideComponent)component).setProperty("hover", object.get("hover"));
        }
        return component;
    }
}

