/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbguides.gui;

import com.feed_the_beast.ftbguides.FTBGuides;
import com.feed_the_beast.ftbguides.gui.components.TableGuideComponent;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.swing.JFileChooser;

public class GuiConverter {
    private int filesFixed = 0;
    private int currentList = -1;
    private int currentLine = 0;

    public static void main(String[] args) {
        new GuiConverter();
    }

    private GuiConverter() {
        File folder = null;
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        if (fc.showOpenDialog(null) == 0) {
            folder = fc.getSelectedFile();
        }
        if (folder == null || !folder.exists()) {
            FTBGuides.LOGGER.error("Directory not found!");
        } else {
            try {
                this.scanAndFix(folder, 0);
                FTBGuides.LOGGER.info("Fixed " + this.filesFixed + " files!");
            }
            catch (Exception ex) {
                FTBGuides.LOGGER.info("Error while fixing files!" + ex);
                ex.printStackTrace();
            }
        }
        System.exit(0);
    }

    private void scanAndFix(File file, int level) throws Exception {
        File[] files;
        if (level == 1 && file.getName().equals("data.json")) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append('\t');
        }
        sb.append(" - ");
        sb.append(file.getAbsolutePath());
        FTBGuides.LOGGER.info(sb.toString());
        if (file.isFile() && file.getName().endsWith(".json")) {
            JsonElement json = DataReader.get((File)file).safeJson();
            if (json.isJsonArray()) {
                try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(FileUtils.newFile((File)new File(file.getParentFile(), file.getName().equals("index.json") ? "README.md" : file.getName().replace(".json", ".md")))), StandardCharsets.UTF_8);
                     BufferedWriter br = new BufferedWriter(fw);){
                    this.currentLine = 0;
                    for (JsonElement json1 : json.getAsJsonArray()) {
                        this.write(false, json1, br);
                        br.write(10);
                        ++this.currentLine;
                    }
                    ++this.filesFixed;
                }
            }
        } else if (file.isDirectory() && (files = file.listFiles()) != null && files.length > 0) {
            for (File f : files) {
                this.scanAndFix(f, level + 1);
            }
        }
    }

    private void write(boolean inline, JsonElement json, BufferedWriter writer) throws Exception {
        boolean needsNewLine;
        boolean bl = needsNewLine = this.currentLine > 0 && !inline;
        if (json.isJsonPrimitive()) {
            if (needsNewLine) {
                writer.write(10);
            }
            writer.write(json.getAsString());
            return;
        }
        if (json.isJsonArray()) {
            for (JsonElement json1 : json.getAsJsonArray()) {
                this.write(true, json1, writer);
            }
            return;
        }
        if (!json.isJsonObject()) {
            return;
        }
        JsonObject o = json.getAsJsonObject();
        for (int i = 1; i <= 3; ++i) {
            if (!o.has("h" + i)) continue;
            if (needsNewLine) {
                writer.write(10);
            }
            for (int j = 0; j < i; ++j) {
                writer.write(35);
            }
            writer.write(32);
            this.write(true, o.get("h" + i), writer);
            return;
        }
        if (o.has("hr")) {
            if (needsNewLine) {
                writer.write(10);
            }
            writer.write("---\n");
        } else if (o.has("img")) {
            String click;
            if (needsNewLine) {
                writer.write(10);
            }
            String string = click = o.has("click") ? o.get("click").getAsString() : "";
            if (!click.isEmpty()) {
                writer.write(91);
            }
            writer.write(33);
            writer.write(91);
            if (o.has("hover")) {
                writer.write(o.get("hover").getAsString());
            }
            writer.write(93);
            writer.write(40);
            writer.write(o.get("img").getAsString());
            writer.write(")");
            if (!click.isEmpty()) {
                writer.write(93);
                writer.write(40);
                writer.write(click);
                writer.write(41);
            }
        } else if (o.has("list")) {
            ++this.currentList;
            if (needsNewLine) {
                writer.write(10);
            }
            boolean first = true;
            for (JsonElement json1 : o.get("list").getAsJsonArray()) {
                if (first) {
                    first = false;
                } else {
                    writer.write(10);
                }
                for (int i = 0; i < this.currentList; ++i) {
                    writer.write(9);
                }
                writer.write(42);
                writer.write(32);
                this.write(true, json1, writer);
            }
            if (this.currentList == 0) {
                writer.write(10);
            }
            --this.currentList;
        } else if (o.has("table")) {
            if (needsNewLine) {
                writer.write(10);
            }
            JsonArray table = o.get("table").getAsJsonArray();
            int cols = o.has("head") ? o.get("head").getAsJsonArray().size() : 0;
            for (JsonElement e : table) {
                if (!e.isJsonArray()) continue;
                cols = Math.max(cols, e.getAsJsonArray().size());
            }
            String[] head = new String[cols];
            TableGuideComponent.Align[] align = new TableGuideComponent.Align[cols];
            Arrays.fill((Object[])align, (Object)TableGuideComponent.Align.NONE);
            if (o.has("head")) {
                JsonArray heade = o.get("head").getAsJsonArray();
                for (int i = 0; i < Math.min(heade.size(), cols); ++i) {
                    JsonElement e = heade.get(i);
                    if (e.isJsonPrimitive()) {
                        head[i] = e.getAsString();
                        continue;
                    }
                    if (!e.isJsonObject()) continue;
                    JsonObject o1 = e.getAsJsonObject();
                    if (o1.has("text")) {
                        head[i] = o1.get("text").getAsString();
                    }
                    if (!o1.has("style")) continue;
                    JsonObject jsonObject = o1.get("style").getAsJsonObject();
                }
            }
            for (int i = 0; i < cols; ++i) {
                if (head[i] != null) continue;
                head[i] = "";
            }
            if (this.currentLine > 0) {
                writer.write(10);
            }
            writer.write(124);
            for (String h : head) {
                writer.write(32);
                writer.write(h);
                writer.write(32);
                writer.write(124);
            }
            writer.write(10);
            writer.write(124);
            for (int i = 0; i < cols; ++i) {
                writer.write(align[i].md);
            }
            writer.write(10);
            for (JsonElement e : table) {
                if (!e.isJsonArray()) continue;
                writer.write(124);
                for (JsonElement e1 : e.getAsJsonArray()) {
                    writer.write(32);
                    this.write(true, e1, writer);
                    writer.write(32);
                    writer.write(124);
                }
                writer.write(10);
            }
        } else if (o.has("text")) {
            if (needsNewLine) {
                writer.write(10);
            }
            String text = o.get("text").getAsString();
            if (o.has("code") && o.get("code").getAsBoolean()) {
                text = "`" + text + "`";
            } else {
                if (o.has("bold") && o.get("bold").getAsBoolean()) {
                    text = "**" + text + "**";
                }
                if (o.has("italic") && o.get("italic").getAsBoolean()) {
                    text = "*" + text + "*";
                }
                if (o.has("strikethrough") && o.get("strikethrough").getAsBoolean()) {
                    text = "~~" + text + "~~";
                }
            }
            if (o.has("click")) {
                text = "[" + text + "](" + o.get("click").getAsString() + ")";
            }
            writer.write(text);
        } else if (o.has("code")) {
            if (needsNewLine) {
                writer.write(10);
            }
            writer.write(96);
            this.write(true, o.get("code"), writer);
            writer.write(96);
        } else if (o.has("codeblock")) {
            if (needsNewLine) {
                writer.write(10);
            }
            writer.write("```");
            writer.write(10);
            for (JsonElement json1 : o.get("codeblock").getAsJsonArray()) {
                writer.write(json1.getAsString());
                writer.write(10);
            }
            writer.write("```\n");
        }
    }
}

