/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbguides.client;

import com.feed_the_beast.ftbguides.FTBGuidesCommon;
import com.feed_the_beast.ftbguides.client.FTBGuidesClientConfig;
import com.feed_the_beast.ftbguides.client.ThreadLoadGuides;
import com.feed_the_beast.ftbguides.gui.GuiGuide;
import com.feed_the_beast.ftbguides.gui.GuidePage;
import com.feed_the_beast.ftbguides.gui.ThreadLoadPage;
import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;

public class FTBGuidesClient
extends FTBGuidesCommon {
    public static KeyBinding KEY_GUIDE;
    static GuiGuide guidesGui;
    static ThreadLoadGuides reloadingThread;
    public static String pageToOpen;
    public static JsonObject serverGuideClient;
    public static Map<String, ThreadLoadPage> serverGuideClientLoading;

    @Override
    public void preInit() {
        super.preInit();
        FTBGuidesClientConfig.sync();
        KEY_GUIDE = new KeyBinding("key.ftbguides.guide", (IKeyConflictContext)KeyConflictContext.IN_GAME, Loader.isModLoaded((String)"ftbquests") ? KeyModifier.ALT : KeyModifier.NONE, 34, "key.categories.ftbmods");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_GUIDE);
    }

    @Override
    public void postInit() {
        super.postInit();
        if (ClientUtils.MC.func_110442_L() instanceof SimpleReloadableResourceManager) {
            ((SimpleReloadableResourceManager)ClientUtils.MC.func_110442_L()).func_110542_a(resourceManager -> FTBGuidesClient.setShouldReload());
        }
    }

    public static void loadServerGuide(JsonElement json) {
        if (json.isJsonObject()) {
            JsonObject o = json.getAsJsonObject();
            serverGuideClient = new JsonObject();
            if (o.has("pages") && o.get("pages").isJsonArray()) {
                for (JsonElement element : o.get("pages").getAsJsonArray()) {
                    if (!element.isJsonObject() || !element.getAsJsonObject().has("id")) continue;
                    serverGuideClient.add(element.getAsJsonObject().get("id").getAsString(), element);
                }
            }
            serverGuideClientLoading = new HashMap<String, ThreadLoadPage>();
        } else {
            serverGuideClient = null;
            serverGuideClientLoading = null;
        }
    }

    public static void loadServerGuidePage(String page, JsonElement json) {
        ThreadLoadPage thread;
        if (serverGuideClientLoading != null && (thread = serverGuideClientLoading.get(page)) != null) {
            thread.json = json;
            thread.gui.setFinished();
            serverGuideClientLoading.remove(page);
        }
    }

    public static void setShouldReload() {
        guidesGui = null;
        if (serverGuideClientLoading != null) {
            for (ThreadLoadPage thread : serverGuideClientLoading.values()) {
                thread.gui.setFinished();
            }
        }
    }

    public static boolean openGuidesGui(String path) {
        if (!path.isEmpty()) {
            pageToOpen = path;
        }
        if (guidesGui == null) {
            if (reloadingThread == null) {
                reloadingThread = new ThreadLoadGuides();
                reloadingThread.start();
            }
            FTBGuidesClient.reloadingThread.gui.openGui();
            return false;
        }
        if (!pageToOpen.isEmpty()) {
            GuidePage page = FTBGuidesClient.guidesGui.page.getSubFromPath(pageToOpen);
            if (page != null) {
                if (page.textURI != null && page.textLoadingState == 0) {
                    new ThreadLoadPage(page).start();
                    return false;
                }
                guidesGui = new GuiGuide(page);
            }
            pageToOpen = "";
        }
        guidesGui.openGui();
        return true;
    }

    static {
        guidesGui = null;
        reloadingThread = null;
        pageToOpen = "";
        serverGuideClient = null;
    }
}

