/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.handlers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.IFlightProvider;
import moze_intel.projecte.gameObjs.items.IStepAssister;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public final class InternalAbilities {
    @CapabilityInject(value=InternalAbilities.class)
    public static final Capability<InternalAbilities> CAPABILITY = null;
    public static final ResourceLocation NAME = new ResourceLocation("projecte", "internal_abilities");
    private final EntityPlayerMP player;
    private boolean swrgOverride = false;
    private boolean gemArmorReady = false;
    private boolean hadFlightItem = false;
    private int projectileCooldown = 0;
    private int gemChestCooldown = 0;

    public InternalAbilities(EntityPlayerMP player) {
        this.player = player;
    }

    public void resetProjectileCooldown() {
        this.projectileCooldown = ProjectEConfig.misc.projectileCooldown;
    }

    public int getProjectileCooldown() {
        return this.projectileCooldown;
    }

    public void resetGemCooldown() {
        this.gemChestCooldown = ProjectEConfig.misc.gemChestCooldown;
    }

    public int getGemCooldown() {
        return this.gemChestCooldown;
    }

    public void setGemState(boolean state) {
        this.gemArmorReady = state;
    }

    public boolean getGemState() {
        return this.gemArmorReady;
    }

    public void tick() {
        if (this.projectileCooldown > 0) {
            --this.projectileCooldown;
        }
        if (this.gemChestCooldown > 0) {
            --this.gemChestCooldown;
        }
        if (!this.shouldPlayerFly() && this.hadFlightItem) {
            if (this.player.field_71075_bZ.field_75101_c) {
                PlayerHelper.updateClientServerFlight(this.player, false);
            }
            this.hadFlightItem = false;
        } else if (this.shouldPlayerFly() && !this.hadFlightItem) {
            if (!this.player.field_71075_bZ.field_75101_c) {
                PlayerHelper.updateClientServerFlight(this.player, true);
            }
            this.hadFlightItem = true;
        }
        if (!this.shouldPlayerResistFire()) {
            if (this.player.func_70045_F()) {
                this.player.field_70178_ae = false;
            }
        } else if (!this.player.func_70045_F()) {
            this.player.field_70178_ae = true;
        }
        if (!this.shouldPlayerStep()) {
            if (this.player.field_70138_W > 0.6f) {
                PlayerHelper.updateClientServerStepHeight(this.player, 0.6f);
            }
        } else if (this.player.field_70138_W < 1.0f) {
            PlayerHelper.updateClientServerStepHeight(this.player, 1.0f);
        }
    }

    public void onDimensionChange() {
        PlayerHelper.updateClientServerFlight(this.player, this.player.field_71075_bZ.field_75101_c);
        PlayerHelper.updateClientServerStepHeight(this.player, this.shouldPlayerStep() ? 1.0f : 0.6f);
    }

    private boolean shouldPlayerFly() {
        if (!this.hasSwrg()) {
            this.disableSwrgFlightOverride();
        }
        if (this.player.field_71075_bZ.field_75098_d || this.player.func_175149_v() || this.swrgOverride) {
            return true;
        }
        for (ItemStack stack : this.player.field_71071_by.field_70460_b) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IFlightProvider) || !((IFlightProvider)stack.func_77973_b()).canProvideFlight(stack, this.player)) continue;
            return true;
        }
        for (int i = 0; i <= 8; ++i) {
            ItemStack stack;
            stack = this.player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IFlightProvider) || !((IFlightProvider)stack.func_77973_b()).canProvideFlight(stack, this.player)) continue;
            return true;
        }
        IItemHandler baubles = PlayerHelper.getBaubles((EntityPlayer)this.player);
        if (baubles != null) {
            for (int i = 0; i < baubles.getSlots(); ++i) {
                ItemStack stack = baubles.getStackInSlot(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IFlightProvider) || !((IFlightProvider)stack.func_77973_b()).canProvideFlight(stack, this.player)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shouldPlayerResistFire() {
        if (this.player.field_71075_bZ.field_75098_d) {
            return true;
        }
        for (ItemStack stack : this.player.field_71071_by.field_70460_b) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IFireProtector) || !((IFireProtector)stack.func_77973_b()).canProtectAgainstFire(stack, this.player)) continue;
            return true;
        }
        for (int i = 0; i <= 8; ++i) {
            ItemStack stack;
            stack = this.player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IFireProtector) || !((IFireProtector)stack.func_77973_b()).canProtectAgainstFire(stack, this.player)) continue;
            return true;
        }
        IItemHandler baubles = PlayerHelper.getBaubles((EntityPlayer)this.player);
        if (baubles != null) {
            for (int i = 0; i < baubles.getSlots(); ++i) {
                ItemStack stack = baubles.getStackInSlot(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IFireProtector) || !((IFireProtector)stack.func_77973_b()).canProtectAgainstFire(stack, this.player)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shouldPlayerStep() {
        for (ItemStack stack : this.player.field_71071_by.field_70460_b) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IStepAssister) || !((IStepAssister)stack.func_77973_b()).canAssistStep(stack, this.player)) continue;
            return true;
        }
        for (int i = 0; i <= 8; ++i) {
            ItemStack stack;
            stack = this.player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IStepAssister) || !((IStepAssister)stack.func_77973_b()).canAssistStep(stack, this.player)) continue;
            return true;
        }
        IItemHandler baubles = PlayerHelper.getBaubles((EntityPlayer)this.player);
        if (baubles != null) {
            for (int i = 0; i < baubles.getSlots(); ++i) {
                ItemStack stack = baubles.getStackInSlot(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IStepAssister) || !((IStepAssister)stack.func_77973_b()).canAssistStep(stack, this.player)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasSwrg() {
        for (int i = 0; i <= 8; ++i) {
            if (((ItemStack)this.player.field_71071_by.field_70462_a.get(i)).func_190926_b() || ((ItemStack)this.player.field_71071_by.field_70462_a.get(i)).func_77973_b() != ObjHandler.swrg) continue;
            return true;
        }
        IItemHandler baubles = PlayerHelper.getBaubles((EntityPlayer)this.player);
        if (baubles != null) {
            for (int i = 0; i < baubles.getSlots(); ++i) {
                if (baubles.getStackInSlot(i).func_190926_b() || baubles.getStackInSlot(i).func_77973_b() != ObjHandler.swrg) continue;
                return true;
            }
        }
        return false;
    }

    public void enableSwrgFlightOverride() {
        this.swrgOverride = true;
    }

    public void disableSwrgFlightOverride() {
        this.swrgOverride = false;
    }

    public static class Provider
    implements ICapabilityProvider {
        private final InternalAbilities capInstance;

        public Provider(EntityPlayerMP player) {
            this.capInstance = new InternalAbilities(player);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CAPABILITY;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CAPABILITY) {
                return (T)CAPABILITY.cast((Object)this.capInstance);
            }
            return null;
        }
    }
}

