/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.tiles.CondenserTile;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.gameObjs.tiles.WrappedItemHandler;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class CondenserMK2Tile
extends CondenserTile {
    @Override
    protected IItemHandler createAutomationInventory() {
        WrappedItemHandler automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.getInput(), WrappedItemHandler.WriteMode.IN){

            @Override
            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return SlotPredicates.HAS_EMC.test(stack) && !CondenserMK2Tile.this.isStackEqualToLock(stack) ? super.insertItem(slot, stack, simulate) : stack;
            }
        };
        WrappedItemHandler automationOutput = new WrappedItemHandler((IItemHandlerModifiable)this.getOutput(), WrappedItemHandler.WriteMode.OUT);
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{automationInput, automationOutput});
    }

    @Override
    protected ItemStackHandler createInput() {
        return new TileEmc.StackHandler(42);
    }

    @Override
    protected ItemStackHandler createOutput() {
        return new TileEmc.StackHandler(42);
    }

    @Override
    protected void condense() {
        while (this.hasSpace() && this.getStoredEmc() >= (double)this.requiredEmc) {
            this.pushStack();
            this.removeEMC(this.requiredEmc);
        }
        if (this.hasSpace()) {
            for (int i = 0; i < this.getInput().getSlots(); ++i) {
                ItemStack stack = this.getInput().getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                this.addEMC(EMCHelper.getEmcSellValue(stack) * (long)stack.func_190916_E());
                this.getInput().setStackInSlot(i, ItemStack.field_190927_a);
                break;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.getOutput().deserializeNBT(nbt.func_74775_l("Output"));
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74782_a("Output", (NBTBase)this.getOutput().serializeNBT());
        return nbt;
    }
}

