/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import moze_intel.projecte.config.CustomEMCParser;
import moze_intel.projecte.config.NBTWhitelistParser;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.emc.EMCMapper;
import moze_intel.projecte.fixes.CapInventoryWalker;
import moze_intel.projecte.fixes.TENameFix;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.tiles.AlchChestTile;
import moze_intel.projecte.gameObjs.tiles.CollectorMK1Tile;
import moze_intel.projecte.gameObjs.tiles.CollectorMK2Tile;
import moze_intel.projecte.gameObjs.tiles.CollectorMK3Tile;
import moze_intel.projecte.gameObjs.tiles.CondenserMK2Tile;
import moze_intel.projecte.gameObjs.tiles.CondenserTile;
import moze_intel.projecte.gameObjs.tiles.DMFurnaceTile;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.gameObjs.tiles.RMFurnaceTile;
import moze_intel.projecte.gameObjs.tiles.RelayMK1Tile;
import moze_intel.projecte.gameObjs.tiles.RelayMK2Tile;
import moze_intel.projecte.gameObjs.tiles.RelayMK3Tile;
import moze_intel.projecte.handlers.InternalAbilities;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.impl.AlchBagImpl;
import moze_intel.projecte.impl.IMCHandler;
import moze_intel.projecte.impl.KnowledgeImpl;
import moze_intel.projecte.impl.TransmutationOffline;
import moze_intel.projecte.integration.Integration;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.ThreadCheckUUID;
import moze_intel.projecte.network.commands.ProjectECMD;
import moze_intel.projecte.playerData.Transmutation;
import moze_intel.projecte.proxies.IProxy;
import moze_intel.projecte.utils.DummyIStorage;
import moze_intel.projecte.utils.GuiHandler;
import net.minecraft.command.ICommand;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="projecte", name="ProjectE", version="1.12-PE1.3.2h", acceptedMinecraftVersions="[1.12,]", dependencies="required-after:forge@[13.20.0.2253,);after:baubles@[1.3.3,);after:jei@[4.6.0,)", updateJSON="https://raw.githubusercontent.com/sinkillerj/ProjectE/mc1.12.x/update.json")
@Mod.EventBusSubscriber(modid="projecte")
public class PECore {
    public static final String MODID = "projecte";
    public static final String MODNAME = "ProjectE";
    public static final String VERSION = "1.12-PE1.3.2h";
    public static final String DEPS = "required-after:forge@[13.20.0.2253,);after:baubles@[1.3.3,);after:jei@[4.6.0,)";
    public static final String UPDATE_JSON = "https://raw.githubusercontent.com/sinkillerj/ProjectE/mc1.12.x/update.json";
    public static final GameProfile FAKEPLAYER_GAMEPROFILE = new GameProfile(UUID.fromString("590e39c7-9fb6-471b-a4c2-c0e539b2423d"), "[ProjectE]");
    public static final int DATA_VERSION = 1;
    public static File CONFIG_DIR;
    public static File PREGENERATED_EMC_FILE;
    public static boolean DEV_ENVIRONMENT;
    public static final Logger LOGGER;
    @Mod.Instance(value="projecte")
    public static PECore instance;
    @SidedProxy(clientSide="moze_intel.projecte.proxies.ClientProxy", serverSide="moze_intel.projecte.proxies.ServerProxy")
    public static IProxy proxy;
    public static final List<String> uuids;

    public static void debugLog(String msg, Object ... args) {
        if (DEV_ENVIRONMENT || ProjectEConfig.misc.debugLogging) {
            LOGGER.info(msg, args);
        } else {
            LOGGER.debug(msg, args);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        DEV_ENVIRONMENT = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        CONFIG_DIR = new File(event.getModConfigurationDirectory(), MODNAME);
        if (!CONFIG_DIR.exists()) {
            CONFIG_DIR.mkdirs();
        }
        PREGENERATED_EMC_FILE = new File(CONFIG_DIR, "pregenerated_emc.json");
        PacketHandler.register();
        AlchBagImpl.init();
        KnowledgeImpl.init();
        CapabilityManager.INSTANCE.register(InternalTimers.class, new DummyIStorage(), InternalTimers::new);
        CapabilityManager.INSTANCE.register(InternalAbilities.class, new DummyIStorage(), () -> new InternalAbilities(null));
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        proxy.registerKeyBinds();
        ObjHandler.register();
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.registerLayerRenderers();
        CompoundDataFixer fixer = FMLCommonHandler.instance().getDataFixer();
        ModFixs modFixer = fixer.init(MODID, 1);
        modFixer.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TENameFix());
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new ItemStackDataLists(AlchChestTile.class, new String[]{"Items"}));
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new ItemStackDataLists(DMPedestalTile.class, new String[]{"Items"}));
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new CapInventoryWalker((Set<Class<? extends TileEntity>>)ImmutableSet.of(CollectorMK1Tile.class, CollectorMK2Tile.class, CollectorMK3Tile.class), "Input", "AuxSlots"));
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new CapInventoryWalker(CondenserTile.class, "Input", "LockSlot"));
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new CapInventoryWalker(CondenserMK2Tile.class, "Input", "LockSlot", "Output"));
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new CapInventoryWalker((Set<Class<? extends TileEntity>>)ImmutableSet.of(DMFurnaceTile.class, RMFurnaceTile.class), "Input", "Output", "Fuel"));
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new CapInventoryWalker((Set<Class<? extends TileEntity>>)ImmutableSet.of(RelayMK1Tile.class, RelayMK2Tile.class, RelayMK3Tile.class), "Input", "Output"));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        NBTWhitelistParser.init();
        proxy.initializeManual();
        Integration.init();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new ProjectECMD());
        if (!ThreadCheckUUID.hasRunServer()) {
            new ThreadCheckUUID(true).start();
        }
        long start = System.currentTimeMillis();
        CustomEMCParser.init();
        LOGGER.info("Starting server-side EMC mapping.");
        EMCMapper.map();
        LOGGER.info("Registered " + EMCMapper.emc.size() + " EMC values. (took " + (System.currentTimeMillis() - start) + " ms)");
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        TransmutationOffline.cleanAll();
    }

    @Mod.EventHandler
    public void serverQuit(FMLServerStoppedEvent event) {
        Transmutation.clearCache();
        EMCMapper.clearMaps();
    }

    @Mod.EventHandler
    public void onIMCMessage(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages()) {
            IMCHandler.handleIMC(msg);
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
        uuids = new ArrayList<String>();
    }
}

