/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.network;

import crafttweaker.mc1120.CraftTweaker;
import io.netty.buffer.ByteBuf;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageOpenBrowser
implements IMessage,
IMessageHandler<MessageOpenBrowser, IMessage> {
    private static final Charset UTF8 = Charset.forName("utf-8");
    private String url;

    public MessageOpenBrowser() {
    }

    public MessageOpenBrowser(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void fromBytes(ByteBuf buf) {
        this.url = UTF8.decode(ByteBuffer.wrap(buf.array())).toString().trim();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBytes(UTF8.encode(this.url).array());
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageOpenBrowser message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> this.handle(message, ctx));
        return null;
    }

    private void handle(MessageOpenBrowser message, MessageContext ctx) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI(message.getUrl()));
            }
            catch (IOException | URISyntaxException exception) {}
        } else {
            CraftTweaker.LOG.error("Desktop not supported");
        }
    }
}

