/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.item;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.block.IBlockState;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.DataString;
import crafttweaker.api.data.IData;
import crafttweaker.api.enchantments.IEnchantment;
import crafttweaker.api.enchantments.IEnchantmentDefinition;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.entity.IEntityItem;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemCondition;
import crafttweaker.api.item.IItemDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IItemTransformer;
import crafttweaker.api.item.IItemTransformerNew;
import crafttweaker.api.item.IngredientItem;
import crafttweaker.api.item.IngredientOr;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IWorld;
import crafttweaker.mc1120.actions.ActionSetBlockHardness;
import crafttweaker.mc1120.actions.ActionSetStackMaxDamage;
import crafttweaker.mc1120.actions.ActionSetStackSize;
import crafttweaker.mc1120.actions.ActionSetStackTranslation;
import crafttweaker.mc1120.block.MCItemBlock;
import crafttweaker.mc1120.data.NBTConverter;
import crafttweaker.mc1120.enchantments.MCEnchantment;
import crafttweaker.mc1120.item.MCItemDefinition;
import crafttweaker.mc1120.liquid.MCLiquidStack;
import crafttweaker.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.oredict.OreDictionary;

public class MCItemStack
implements IItemStack {
    public static final IItemStack EMPTY = new MCItemStack();
    private final ItemStack stack;
    private final List<IItemStack> items;
    private boolean matchTagExact = true;
    private IData tag = null;
    private boolean wildcardSize;

    private MCItemStack() {
        this.stack = ItemStack.field_190927_a;
        this.items = Collections.singletonList(this);
    }

    public MCItemStack(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            throw new IllegalArgumentException("stack cannot be null");
        }
        this.stack = itemStack.func_77946_l();
        this.items = Collections.singletonList(this);
    }

    public MCItemStack(ItemStack itemStack, boolean wildcardSize) {
        this(itemStack);
        this.wildcardSize = wildcardSize;
    }

    private MCItemStack(ItemStack itemStack, IData tag) {
        if (itemStack.func_190926_b()) {
            throw new IllegalArgumentException("stack cannot be null");
        }
        this.stack = itemStack;
        this.items = Collections.singletonList(this);
        this.tag = tag;
    }

    private MCItemStack(ItemStack itemStack, IData tag, boolean wildcardSize) {
        if (itemStack.func_190926_b()) {
            throw new IllegalArgumentException("stack cannot be null");
        }
        this.stack = itemStack;
        this.items = Collections.singletonList(this);
        this.tag = tag;
        this.wildcardSize = wildcardSize;
    }

    private MCItemStack(ItemStack itemStack, int unused) {
        if (itemStack.func_190926_b()) {
            throw new IllegalArgumentException("stack cannot be null");
        }
        this.stack = itemStack;
        this.items = Collections.singletonList(this);
    }

    public static MCItemStack createNonCopy(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return null;
        }
        return new MCItemStack(itemStack, -1);
    }

    @Override
    public IItemDefinition getDefinition() {
        return new MCItemDefinition(this.stack.func_77973_b().getRegistryName().toString(), this.stack.func_77973_b());
    }

    @Override
    public String getName() {
        return this.stack.func_77977_a();
    }

    @Override
    public String getDisplayName() {
        return this.stack.func_82833_r();
    }

    @Override
    public void setDisplayName(String name) {
        CraftTweakerAPI.apply(new ActionSetStackTranslation(this, this.getName() + ".name", name));
    }

    @Override
    public int getMaxStackSize() {
        return this.stack.func_77976_d();
    }

    @Override
    public void setMaxStackSize(int size) {
        CraftTweakerAPI.apply(new ActionSetStackSize((ItemStack)this.getInternal(), size));
    }

    @Override
    public float getBlockHardness() {
        return Block.func_149634_a((Item)this.stack.func_77973_b()).field_149782_v;
    }

    @Override
    public void setBlockHardness(float hardness) {
        CraftTweakerAPI.apply(new ActionSetBlockHardness(this.stack, hardness));
    }

    @Override
    public int getDamage() {
        return this.stack.func_77952_i();
    }

    @Override
    public IData getTag() {
        if (this.tag == null) {
            if (this.stack.func_77978_p() == null) {
                return DataMap.EMPTY;
            }
            this.tag = NBTConverter.from((NBTBase)this.stack.func_77978_p(), true);
        }
        return this.tag;
    }

    @Override
    public int getMaxDamage() {
        return this.stack.func_77958_k();
    }

    @Override
    public void setMaxDamage(int damage) {
        CraftTweakerAPI.apply(new ActionSetStackMaxDamage(this.stack, damage));
    }

    @Override
    public ILiquidStack getLiquid() {
        FluidStack liquid = FluidUtil.getFluidContained((ItemStack)this.stack);
        return liquid == null ? null : new MCLiquidStack(liquid);
    }

    @Override
    public IIngredient anyDamage() {
        ItemStack result = new ItemStack(this.stack.func_77973_b(), this.stack.func_190916_E(), Short.MAX_VALUE);
        result.func_77982_d(this.stack.func_77978_p());
        return new MCItemStack(result, this.tag);
    }

    @Override
    public IItemStack withDamage(int damage) {
        ItemStack result = new ItemStack(this.stack.func_77973_b(), this.stack.func_190916_E(), damage);
        result.func_77982_d(this.stack.func_77978_p());
        return new MCItemStack(result, this.tag);
    }

    @Override
    public IItemStack anyAmount() {
        ItemStack result = new ItemStack(this.stack.func_77973_b(), 1, this.stack.func_77952_i());
        result.func_77982_d(this.stack.func_77978_p());
        return new MCItemStack(result, this.tag, true);
    }

    @Override
    public IItemStack withAmount(int amount) {
        ItemStack result = new ItemStack(this.stack.func_77973_b(), amount, this.stack.func_77952_i());
        result.func_77982_d(this.stack.func_77978_p());
        return new MCItemStack(result, this.tag);
    }

    @Override
    public IItemStack withTag(IData tag, boolean matchTagExact) {
        ItemStack result = new ItemStack(this.stack.func_77973_b(), this.stack.func_190916_E(), this.stack.func_77952_i());
        if (tag == null) {
            result.func_77982_d(null);
        } else {
            result.func_77982_d((NBTTagCompound)NBTConverter.from(tag));
        }
        MCItemStack out = new MCItemStack(result, tag);
        out.matchTagExact = matchTagExact;
        return out;
    }

    @Override
    public IItemStack withTag(IData tag) {
        return this.withTag(tag, true);
    }

    @Override
    public IItemStack updateTag(IData tagUpdate) {
        return this.updateTag(tagUpdate, true);
    }

    @Override
    public IItemStack withEmptyTag() {
        ItemStack result = new ItemStack(this.stack.func_77973_b(), this.stack.func_190916_E(), this.stack.func_77952_i());
        result.func_77982_d(new NBTTagCompound());
        return new MCItemStack(result, NBTConverter.from((NBTBase)new NBTTagCompound(), true));
    }

    @Override
    public IItemStack updateTag(IData tagUpdate, boolean matchTagExact) {
        if (this.tag == null) {
            if (this.stack.func_77978_p() == null) {
                return this.withTag(tagUpdate, matchTagExact);
            }
            this.tag = NBTConverter.from((NBTBase)this.stack.func_77978_p(), true);
        }
        IData updated = this.tag.update(tagUpdate);
        return this.withTag(updated, matchTagExact);
    }

    @Override
    public IItemStack removeTag(String tag) {
        ItemStack result = new ItemStack(this.stack.func_77973_b(), this.stack.func_190916_E(), this.stack.func_77952_i());
        if (tag == null) {
            result.func_77982_d(null);
        } else {
            result.func_77978_p().func_82580_o(tag);
        }
        IData dataTag = NBTConverter.from((NBTBase)result.func_77978_p(), false);
        return new MCItemStack(result, dataTag);
    }

    @Override
    public String getMark() {
        return null;
    }

    @Override
    public int getAmount() {
        return this.stack.func_190916_E();
    }

    @Override
    public List<IItemStack> getItems() {
        return this.items;
    }

    @Override
    public IItemStack[] getItemArray() {
        return this.items.toArray(new IItemStack[this.items.size()]);
    }

    @Override
    public List<ILiquidStack> getLiquids() {
        return Collections.emptyList();
    }

    @Override
    public IItemStack amount(int amount) {
        return this.withAmount(amount);
    }

    @Override
    public WeightedItemStack percent(float chance) {
        return new WeightedItemStack(this, chance * 0.01f);
    }

    @Override
    public WeightedItemStack weight(float chance) {
        return new WeightedItemStack(this, chance);
    }

    @Override
    public IIngredient transformNew(IItemTransformerNew transformer) {
        return new IngredientItem(this, null, ArrayUtil.EMPTY_CONDITIONS, new IItemTransformerNew[]{transformer}, ArrayUtil.EMPTY_TRANSFORMERS_NEW);
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        return new IngredientItem(this, null, new IItemCondition[]{condition}, ArrayUtil.EMPTY_TRANSFORMERS, ArrayUtil.EMPTY_TRANSFORMERS_NEW);
    }

    @Override
    public IIngredient marked(String mark) {
        return new IngredientItem(this, mark, ArrayUtil.EMPTY_CONDITIONS, ArrayUtil.EMPTY_TRANSFORMERS, ArrayUtil.EMPTY_TRANSFORMERS_NEW);
    }

    @Override
    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr(this, ingredient);
    }

    @Override
    public boolean matches(IItemStack item) {
        if (item == null) {
            return false;
        }
        ItemStack internal = (ItemStack)item.getInternal();
        if (this.stack.func_77942_o() && this.matchTagExact) {
            return this.matchesExact(item);
        }
        return !internal.func_190926_b() && !this.stack.func_190926_b() && internal.func_77973_b() == this.stack.func_77973_b() && (this.wildcardSize || internal.func_190916_E() >= this.stack.func_190916_E()) && (this.stack.func_77952_i() == Short.MAX_VALUE || this.stack.func_77952_i() == internal.func_77952_i() || !this.stack.func_77981_g() && !this.stack.func_77973_b().func_77645_m());
    }

    @Override
    public boolean matchesExact(IItemStack item) {
        boolean itemMatches;
        if (item == null) {
            return false;
        }
        ItemStack internal = (ItemStack)item.getInternal();
        NBTTagCompound internalTag = internal.func_77978_p();
        NBTTagCompound stackTag = this.stack.func_77978_p();
        if (internal.func_77942_o() != this.stack.func_77942_o()) {
            return false;
        }
        boolean bl = itemMatches = this.stack.func_77973_b() == internal.func_77973_b() && (internal.func_77960_j() == Short.MAX_VALUE || this.stack.func_77960_j() == internal.func_77960_j());
        if (internalTag == null && stackTag == null) {
            return itemMatches;
        }
        if (!NBTConverter.from((NBTBase)internalTag, true).contains(NBTConverter.from((NBTBase)stackTag, true))) {
            return false;
        }
        return itemMatches;
    }

    @Override
    public boolean matches(ILiquidStack liquid) {
        return false;
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        List<IItemStack> iitems = ingredient.getItems();
        return iitems != null && iitems.size() == 1 && this.matches(iitems.get(0));
    }

    @Override
    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        return item;
    }

    @Override
    public IItemStack applyNewTransform(IItemStack item) {
        return item;
    }

    @Override
    public boolean hasNewTransformers() {
        return false;
    }

    @Override
    public boolean hasTransformers() {
        return false;
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        return new IngredientItem(this, null, ArrayUtil.EMPTY_CONDITIONS, ArrayUtil.EMPTY_TRANSFORMERS, new IItemTransformer[]{transformer});
    }

    @Override
    public Object getInternal() {
        return this.stack;
    }

    @Override
    public IBlock asBlock() {
        ResourceLocation name = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)Block.func_149634_a((Item)this.stack.func_77973_b()));
        if (Block.field_149771_c.func_148741_d((Object)name)) {
            return new MCItemBlock(this.stack);
        }
        throw new ClassCastException("This item is not a block");
    }

    @Override
    public List<IOreDictEntry> getOres() {
        ArrayList<IOreDictEntry> result = new ArrayList<IOreDictEntry>();
        block0: for (String key : OreDictionary.getOreNames()) {
            for (ItemStack is : OreDictionary.getOres((String)key)) {
                if (is.func_77973_b() != this.stack.func_77973_b() || is.func_77952_i() != Short.MAX_VALUE && is.func_77952_i() != this.stack.func_77952_i()) continue;
                result.add(CraftTweakerAPI.oreDict.get(key));
                continue block0;
            }
        }
        return result;
    }

    @Override
    public IItemStack withDisplayName(String name) {
        NBTTagCompound tagComp = !this.stack.func_77942_o() || this.stack.func_77978_p() == null ? new NBTTagCompound() : this.stack.func_77978_p();
        NBTTagCompound display = !tagComp.func_74764_b("display") || !(tagComp.func_74781_a("display") instanceof NBTTagCompound) ? new NBTTagCompound() : (NBTTagCompound)tagComp.func_74781_a("display");
        display.func_74778_a("Name", name);
        tagComp.func_74782_a("display", (NBTBase)display);
        ItemStack newStack = this.stack.func_77946_l();
        newStack.func_77982_d(tagComp);
        return new MCItemStack(newStack);
    }

    @Override
    public IItemStack withLore(String[] lore) {
        NBTTagCompound tagComp = !this.stack.func_77942_o() || this.stack.func_77978_p() == null ? new NBTTagCompound() : this.stack.func_77978_p();
        NBTTagCompound display = !tagComp.func_74764_b("display") || !(tagComp.func_74781_a("display") instanceof NBTTagCompound) ? new NBTTagCompound() : (NBTTagCompound)tagComp.func_74781_a("display");
        NBTTagList loreList = !tagComp.func_74764_b("Lore") || !(tagComp.func_74781_a("Lore") instanceof NBTTagList) ? new NBTTagList() : (NBTTagList)tagComp.func_74781_a("Lore");
        for (String s : lore) {
            loreList.func_74742_a((NBTBase)new NBTTagString(s));
        }
        display.func_74782_a("Lore", (NBTBase)loreList);
        tagComp.func_74782_a("display", (NBTBase)display);
        ItemStack newStack = this.stack.func_77946_l();
        newStack.func_77982_d(tagComp);
        return new MCItemStack(newStack);
    }

    @Override
    public List<String> getToolClasses() {
        return new ArrayList<String>(this.stack.func_77973_b().getToolClasses(this.stack));
    }

    @Override
    public int getItemEnchantability() {
        return this.stack.func_77973_b().getItemEnchantability(this.stack);
    }

    @Override
    public IItemStack getContainerItem() {
        return new MCItemStack(this.stack.func_77973_b().getContainerItem(this.stack));
    }

    @Override
    public boolean hasContainerItem() {
        return this.stack.func_77973_b().hasContainerItem(this.stack);
    }

    @Override
    public IEntityItem createEntityItem(IWorld world, int x, int y, int z) {
        return CraftTweakerMC.getIEntityItem(new EntityItem(CraftTweakerMC.getWorld(world), (double)x, (double)y, (double)z, this.stack));
    }

    @Override
    public IEntityItem createEntityItem(IWorld world, IBlockPos pos) {
        return this.createEntityItem(world, pos.getX(), pos.getY(), pos.getZ());
    }

    @Override
    public boolean isBeaconPayment() {
        return this.stack.func_77973_b().isBeaconPayment(this.stack);
    }

    @Override
    public boolean canPlaceOn(IBlockDefinition block) {
        return this.stack.func_179547_d((Block)block.getInternal());
    }

    @Override
    public boolean canDestroy(IBlockDefinition block) {
        return this.stack.func_179544_c((Block)block.getInternal());
    }

    @Override
    public boolean canHarvestBlock(IBlockState block) {
        return this.stack.func_150998_b((net.minecraft.block.state.IBlockState)block.getInternal());
    }

    @Override
    public int getRepairCost() {
        return this.stack.func_82838_A();
    }

    @Override
    public void setRepairCost(int repairCost) {
        this.stack.func_82841_c(repairCost);
    }

    @Override
    public boolean canEditBlocks() {
        return false;
    }

    @Override
    public boolean isOnItemFrame() {
        return this.stack.func_82839_y();
    }

    @Override
    public boolean isItemEnchanted() {
        return this.stack.func_77948_v();
    }

    @Override
    public boolean isItemDamaged() {
        return this.stack.func_77951_h();
    }

    @Override
    public boolean isDamageable() {
        return this.stack.func_77984_f();
    }

    @Override
    public boolean isStackable() {
        return this.stack.func_77985_e();
    }

    @Override
    public void addEnchantment(IEnchantment enchantment) {
        this.stack.func_77966_a((Enchantment)enchantment.getDefinition().getInternal(), enchantment.getLevel());
    }

    @Override
    public boolean canApplyAtEnchantingTable(IEnchantmentDefinition enchantment) {
        return this.stack.func_77973_b().canApplyAtEnchantingTable(this.stack, (Enchantment)enchantment.getInternal());
    }

    @Override
    public List<IEnchantment> getEnchantments() {
        ArrayList<IEnchantment> output = new ArrayList<IEnchantment>();
        if (this.stack.func_190926_b() || !this.stack.func_77942_o()) {
            return output;
        }
        IData tag = NBTConverter.from((NBTBase)this.stack.func_77978_p(), false);
        if (tag.contains(new DataString("ench"))) {
            List<IData> enchantmentList = tag.memberGet("ench").asList();
            enchantmentList.stream().filter(ench -> ench.contains(new DataString("id")) && ench.contains(new DataString("lvl"))).forEach(ench -> output.add(new MCEnchantment(ench.memberGet("id").asInt(), ench.memberGet("lvl").asInt())));
        }
        return output;
    }

    @Override
    public boolean isItemEnchantable() {
        return this.stack.func_77956_u();
    }

    @Override
    public boolean hasEffect() {
        return this.stack.func_77962_s();
    }

    @Override
    public boolean hasDisplayName() {
        return this.stack.func_82837_s();
    }

    @Override
    public void clearCustomName() {
        this.stack.func_135074_t();
    }

    @Override
    public boolean hasTag() {
        return this.stack.func_77942_o();
    }

    @Override
    public void damageItem(int amount, IEntity entity) {
        if (entity.getInternal() instanceof EntityLivingBase) {
            this.stack.func_77972_a(amount, (EntityLivingBase)entity.getInternal());
        }
    }

    @Override
    public int getMetadata() {
        return this.stack.func_77960_j();
    }

    @Override
    public boolean getHasSubtypes() {
        return this.stack.func_77981_g();
    }

    @Override
    public float getStrengthAgainstBlock(IBlockState blockState) {
        return this.stack.func_150997_a((net.minecraft.block.state.IBlockState)blockState.getInternal());
    }

    @Override
    public IItemStack splitStack(int amount) {
        return new MCItemStack(this.stack.func_77979_a(amount));
    }

    @Override
    public boolean isEmpty() {
        return this.stack.func_190926_b();
    }

    @Override
    public int getItemBurnTime() {
        return TileEntityFurnace.func_145952_a((ItemStack)this.stack);
    }

    @Override
    public boolean showsDurabilityBar() {
        return this.stack.func_77973_b().showDurabilityBar(this.stack);
    }

    @Override
    public boolean hasCustomEntity() {
        return this.stack.func_77973_b().hasCustomEntity(this.stack);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + this.stack.func_77973_b().hashCode();
        hash = 41 * hash + this.stack.func_77952_i();
        hash = 41 * hash + this.stack.func_190916_E();
        hash = 41 * hash + (this.stack.func_77978_p() == null ? 0 : this.stack.func_77978_p().hashCode());
        hash = 41 * hash + (this.wildcardSize ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MCItemStack other = (MCItemStack)obj;
        return this.stack.func_77973_b() == other.stack.func_77973_b() && this.stack.func_77952_i() == other.stack.func_77952_i() && this.stack.func_190916_E() == other.stack.func_190916_E() && (this.stack.func_77978_p() == other.stack.func_77978_p() || !this.stack.equals(other.stack)) && this.wildcardSize == other.wildcardSize;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('<');
        result.append(Item.field_150901_e.func_177774_c((Object)this.stack.func_77973_b()));
        if (this.stack.func_77952_i() == Short.MAX_VALUE) {
            result.append(":*");
        } else if (this.stack.func_77952_i() > 0) {
            result.append(':').append(this.stack.func_77952_i());
        }
        result.append('>');
        if (this.stack.func_77978_p() != null) {
            result.append(".withTag(");
            result.append(NBTConverter.from((NBTBase)this.stack.func_77978_p(), this.wildcardSize).toString());
            result.append(")");
        }
        if (!this.wildcardSize && this.stack.func_190916_E() > 1) {
            result.append(" * ").append(this.stack.func_190916_E());
        }
        return result.toString();
    }

    @Override
    public String toCommandString() {
        return this.toString();
    }
}

