/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.block;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.block.BlockStateMatcherOr;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.block.IBlockStateMatcher;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IWorld;
import crafttweaker.mc1120.block.BlockStateMatcher;
import crafttweaker.mc1120.block.MCBlockProperties;
import crafttweaker.mc1120.block.MCSpecificBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockProperties;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MCBlockState
extends MCBlockProperties
implements crafttweaker.api.block.IBlockState {
    private final IBlockState blockState;
    private IBlock block;

    public MCBlockState(IBlockState blockState) {
        super((IBlockProperties)blockState);
        this.blockState = blockState;
        Block block = blockState.func_177230_c();
        int meta = block.func_176201_c(blockState);
        this.block = new MCSpecificBlock(block, meta);
    }

    @Override
    public IBlock getBlock() {
        return this.block;
    }

    @Override
    public int getMeta() {
        return this.block.getMeta();
    }

    @Override
    public boolean isReplaceable(IWorld world, IBlockPos blockPos) {
        return this.blockState.func_177230_c().func_176200_f((IBlockAccess)((World)world.getInternal()), (BlockPos)blockPos.getInternal());
    }

    @Override
    public int compare(crafttweaker.api.block.IBlockState other) {
        int result = 0;
        if (!this.getInternal().equals(other.getInternal())) {
            if (this.blockState.func_177230_c().equals(((IBlockState)other.getInternal()).func_177230_c())) {
                result = Integer.compare(this.getMeta(), other.getMeta());
            } else {
                int blockId = ((ForgeRegistry)ForgeRegistries.BLOCKS).getID((IForgeRegistryEntry)((IBlockState)this.getInternal()).func_177230_c());
                int otherBlockId = ((ForgeRegistry)ForgeRegistries.BLOCKS).getID((IForgeRegistryEntry)((IBlockState)other.getInternal()).func_177230_c());
                result = Integer.compare(blockId, otherBlockId);
            }
        }
        return result;
    }

    @Override
    public crafttweaker.api.block.IBlockState withProperty(String name, String value) {
        IProperty property = this.blockState.func_177230_c().func_176194_O().func_185920_a(name);
        if (property == null) {
            CraftTweakerAPI.logWarning("Invalid property name");
        } else {
            Optional propValue = property.func_185929_b(value);
            if (propValue.isPresent()) {
                return new MCBlockState(this.blockState.func_177226_a(property, (Comparable)propValue.get()));
            }
            CraftTweakerAPI.logWarning("Invalid property value");
        }
        return this;
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> props = new ArrayList<String>();
        for (IProperty prop : this.blockState.func_177227_a()) {
            props.add(prop.func_177701_a());
        }
        return ImmutableList.copyOf(props);
    }

    @Override
    public String getPropertyValue(String name) {
        IProperty prop = this.blockState.func_177230_c().func_176194_O().func_185920_a(name);
        if (prop != null) {
            return this.blockState.func_177229_b(prop).toString();
        }
        CraftTweakerAPI.logWarning("Invalid property name");
        return "";
    }

    @Override
    public List<String> getAllowedValuesForProperty(String name) {
        IProperty prop = this.blockState.func_177230_c().func_176194_O().func_185920_a(name);
        if (prop != null) {
            ArrayList<String> values = new ArrayList<String>();
            prop.func_177700_c().forEach(v -> values.add(v.toString()));
            return values;
        }
        CraftTweakerAPI.logWarning("Invalid property name");
        return ImmutableList.of();
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        for (Map.Entry entry : this.blockState.func_177228_b().entrySet()) {
            props.put(((IProperty)entry.getKey()).func_177701_a(), ((Comparable)entry.getValue()).toString());
        }
        return ImmutableMap.copyOf(props);
    }

    @Override
    public IBlockStateMatcher matchBlock() {
        return new BlockStateMatcher(this);
    }

    @Override
    public boolean matches(crafttweaker.api.block.IBlockState other) {
        return this.compare(other) == 0;
    }

    @Override
    public IBlockStateMatcher or(IBlockStateMatcher matcher) {
        return new BlockStateMatcherOr(this, matcher);
    }

    @Override
    public Collection<crafttweaker.api.block.IBlockState> getMatchingBlockStates() {
        return ImmutableList.of((Object)this);
    }

    @Override
    public IBlockStateMatcher allowValuesForProperty(String name, String ... values) {
        CraftTweakerAPI.logWarning("IBlockStateMatcher#allowValuesForProperty is deprecated. Please use IBlockStateMatcher#withMatchedValuesForProperty instead.");
        return this.withMatchedValuesForProperty(name, values);
    }

    @Override
    public IBlockStateMatcher withMatchedValuesForProperty(String name, String ... values) {
        HashMap<String, List<String>> newProps = new HashMap<String, List<String>>();
        ImmutableList newValues = ImmutableList.copyOf((Object[])values);
        if (newValues.contains("*") && newValues.size() > 1) {
            newProps.put(name, (List<String>)ImmutableList.of((Object)"*"));
        } else {
            newProps.put(name, (List<String>)newValues);
        }
        return new BlockStateMatcher(this, newProps);
    }

    @Override
    public List<String> getMatchedValuesForProperty(String name) {
        return ImmutableList.of((Object)this.getPropertyValue(name));
    }

    @Override
    public Map<String, List<String>> getMatchedProperties() {
        HashMap<String, ImmutableList> props = new HashMap<String, ImmutableList>();
        for (Map.Entry<String, String> entry : this.getProperties().entrySet()) {
            props.put(entry.getKey(), ImmutableList.of((Object)entry.getValue()));
        }
        return ImmutableMap.copyOf(props);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("<blockstate:");
        builder.append(this.blockState.func_177230_c().getRegistryName());
        if (!this.blockState.func_177228_b().isEmpty()) {
            builder.append(":");
            StringJoiner joiner = new StringJoiner(",");
            for (Map.Entry entry : this.blockState.func_177228_b().entrySet()) {
                joiner.add(((IProperty)entry.getKey()).func_177701_a() + "=" + entry.getValue());
            }
            builder.append(joiner);
        }
        return builder.append(">").toString();
    }

    @Override
    public boolean isCompound() {
        return false;
    }
}

