/*
 * Decompiled with CFR 0.152.
 */
package magicbees.util;

import com.google.common.base.Preconditions;
import forestry.api.genetics.IAlleleSpeciesBuilder;
import forestry.apiculture.blocks.BlockRegistryApiculture;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.blocks.BlockRegistryCore;
import forestry.core.items.ItemRegistryCore;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import magicbees.util.Config;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Utils {
    private static final ItemRegistryApiculture itemsA;
    private static final BlockRegistryApiculture blocksA;
    private static final ItemRegistryCore itemsC;
    private static final BlockRegistryCore blocksC;

    public static ItemRegistryApiculture getApicultureItems() {
        return itemsA;
    }

    public static BlockRegistryApiculture getApicultureBlocks() {
        return blocksA;
    }

    public static ItemRegistryCore getCoreItems() {
        return itemsC;
    }

    public static BlockRegistryCore getCoreBlocks() {
        return blocksC;
    }

    @Nonnull
    public static Block getBlock(String mod, String name) {
        return (Block)Preconditions.checkNotNull((Object)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(mod, name)));
    }

    @Nonnull
    public static Item getItem(String mod, String name) {
        return (Item)Preconditions.checkNotNull((Object)ForgeRegistries.ITEMS.getValue(new ResourceLocation(mod, name)));
    }

    public static void setSecret(IAlleleSpeciesBuilder builder) {
        if (!Config.showAllBees) {
            builder.setIsSecret();
        }
    }

    public static AxisAlignedBB getAABB(BlockPos pos, int range, boolean y) {
        int xCoord = pos.func_177958_n();
        int yCoord = pos.func_177956_o();
        int zCoord = pos.func_177952_p();
        return new AxisAlignedBB((double)(xCoord - range), (double)(yCoord - (y ? range : 0)), (double)(zCoord - range), (double)(xCoord + range + 1), (double)(yCoord + 1 + (y ? range : 0)), (double)(zCoord + range + 1));
    }

    public static void setUnlocalizedName(Item item) {
        item.func_77655_b(Utils.getUnlocalizedName(item));
    }

    public static void setUnlocalizedName(Block block) {
        block.func_149663_c(Utils.getUnlocalizedName(block));
    }

    public static String getUnlocalizedName(IForgeRegistryEntry<?> object) {
        return object.getRegistryName().toString().replace(":", ".").toLowerCase();
    }

    private static Object getStatic(Field field) throws IllegalAccessException {
        field.setAccessible(true);
        return field.get(null);
    }

    static {
        Class<?> core;
        Class<?> apiculture;
        try {
            apiculture = Class.forName("forestry.apiculture.PluginApiculture");
            core = Class.forName("forestry.core.PluginCore");
        }
        catch (ClassNotFoundException e) {
            try {
                apiculture = Class.forName("forestry.apiculture.ModuleApiculture");
                core = Class.forName("forestry.core.ModuleCore");
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            itemsA = (ItemRegistryApiculture)Preconditions.checkNotNull((Object)((ItemRegistryApiculture)Utils.getStatic(apiculture.getDeclaredField("items"))));
            blocksA = (BlockRegistryApiculture)Preconditions.checkNotNull((Object)((BlockRegistryApiculture)Utils.getStatic(apiculture.getDeclaredField("blocks"))));
            itemsC = (ItemRegistryCore)Preconditions.checkNotNull((Object)((ItemRegistryCore)Utils.getStatic(core.getDeclaredField("items"))));
            blocksC = (BlockRegistryCore)Preconditions.checkNotNull((Object)((BlockRegistryCore)Utils.getStatic(core.getDeclaredField("blocks"))));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

