/*
 * Decompiled with CFR 0.152.
 */
package magicbees.integration.botania;

import com.google.common.collect.Lists;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.ISpeciesType;
import magicbees.api.module.IConfigRegistry;
import magicbees.api.module.IMagicBeesInitialisationEvent;
import magicbees.api.module.IMagicBeesModule;
import magicbees.api.module.MagicBeesModule;
import magicbees.bees.BeeIntegrationInterface;
import magicbees.bees.EnumBeeSpecies;
import magicbees.bees.allele.AlleleEffectTransmuting;
import magicbees.elec332.corerepack.compat.forestry.allele.AlleleFlowerProvider;
import magicbees.init.ItemRegister;
import magicbees.integration.botania.BotaniaIntegrationConfig;
import magicbees.integration.botania.BotaniaLexiconEntry;
import magicbees.integration.botania.BotaniaSignature;
import magicbees.integration.botania.FlowerProviderBotania;
import magicbees.integration.botania.RecipeElvenTradeBeeSpecies;
import magicbees.integration.botania.RecipeManaInfusionBeeSpecies;
import magicbees.integration.botania.SubTileBeegonia;
import magicbees.integration.botania.SubTileHibeescus;
import magicbees.integration.botania.SubTileHiveacynth;
import magicbees.util.DefaultTransmutationController;
import magicbees.util.MagicBeesResourceLocation;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.lexicon.LexiconPage;
import vazkii.botania.api.recipe.RecipeElvenTrade;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.api.subtile.signature.SubTileSignature;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.LibItemNames;

@MagicBeesModule(owner="magicbees", name="Botania Integration", modDependencies="botania")
public class IntegrationBotania
implements IMagicBeesModule {
    private Block livingRock;
    private Block dreamWood;
    private Item itemPetal;

    @Override
    public void preInit() {
        BotaniaAPI.registerSubTile((String)"beegonia", SubTileBeegonia.class);
        BotaniaAPI.registerSubTileSignature(SubTileBeegonia.class, (SubTileSignature)new BotaniaSignature("beegonia"));
        BotaniaAPI.addSubTileToCreativeMenu((String)"beegonia");
        BotaniaAPI.registerSubTile((String)"hiveacynth", SubTileHiveacynth.class);
        BotaniaAPI.registerSubTileSignature(SubTileHiveacynth.class, (SubTileSignature)new BotaniaSignature("hiveacynth"));
        BotaniaAPI.addSubTileToCreativeMenu((String)"hiveacynth");
        BotaniaAPI.registerSubTile((String)"hibeescus", SubTileHibeescus.class);
        BotaniaAPI.registerSubTileSignature(SubTileHibeescus.class, (SubTileSignature)new BotaniaSignature("hibeescus"));
        BotaniaAPI.addSubTileToCreativeMenu((String)"hibeescus");
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.cl();
        }
    }

    @Override
    public void registerConfig(IConfigRegistry registry) {
        registry.registerConfig(new BotaniaIntegrationConfig());
    }

    @SideOnly(value=Side.CLIENT)
    private void cl() {
        ModelResourceLocation mrl = new ModelResourceLocation((ResourceLocation)new MagicBeesResourceLocation("beegonia"), "normal");
        BotaniaAPIClient.registerSubtileModel(SubTileBeegonia.class, (ModelResourceLocation)mrl);
        mrl = new ModelResourceLocation((ResourceLocation)new MagicBeesResourceLocation("hibeescus"), "normal");
        BotaniaAPIClient.registerSubtileModel(SubTileHibeescus.class, (ModelResourceLocation)mrl);
        mrl = new ModelResourceLocation((ResourceLocation)new MagicBeesResourceLocation("hiveacynth"), "normal");
        BotaniaAPIClient.registerSubtileModel(SubTileHiveacynth.class, (ModelResourceLocation)mrl);
    }

    @Override
    public void init(IMagicBeesInitialisationEvent event) {
        IBlockState livingWood = BeeIntegrationInterface.livingWood = event.getBlock("livingwood").func_176223_P();
        this.livingRock = event.getBlock("livingrock");
        this.dreamWood = event.getBlock("dreamwood");
        Block mysticalFlower = event.getBlock("specialFlower");
        BeeIntegrationInterface.effectDreaming = new AlleleEffectTransmuting(BeeIntegrationInterface.bot_dreaming_name, new DefaultTransmutationController((world, pos, block, biome) -> {
            int[] oreIDs;
            for (int oreId : oreIDs = OreDictionary.getOreIDs((ItemStack)block)) {
                if (oreId == OreDictionary.getOreID((String)"logWood")) {
                    world.func_180501_a(pos, livingWood, 3);
                    return true;
                }
                if (oreId == OreDictionary.getOreID((String)"stone")) {
                    world.func_180501_a(pos, this.livingRock.func_176223_P(), 3);
                    return true;
                }
                if (oreId != OreDictionary.getOreID((String)"livingwood")) continue;
                world.func_180501_a(pos, this.dreamWood.func_176223_P(), 3);
                return true;
            }
            return false;
        }));
        BeeIntegrationInterface.flowersBotania = new AlleleFlowerProvider(BeeIntegrationInterface.bot_flowers_name, (IFlowerProvider)new FlowerProviderBotania("flowersBotania", mysticalFlower));
        BeeIntegrationInterface.flowersBotania.registerAcceptableFlower(mysticalFlower);
        BeeIntegrationInterface.itemPetal = this.itemPetal = event.getItem("petal");
        BeeIntegrationInterface.itemPastureSeed = event.getItem("grassSeeds");
        BeeIntegrationInterface.seedTypes = 9;
    }

    @Override
    public void postInit() {
        MagicBeesResourceLocation manaSteelScoopRecipe = new MagicBeesResourceLocation("manasteelscoop");
        MagicBeesResourceLocation manaSteelGrafterRecipe = new MagicBeesResourceLocation("manasteelgrafter");
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])new Object[]{"twt", "tmt", " t ", Character.valueOf('m'), new ItemStack(ModItems.manaResource, 1, 0), Character.valueOf('w'), Blocks.field_150325_L, Character.valueOf('t'), Items.field_151055_y});
        ForgeRegistries.RECIPES.register(new ShapedRecipes("", primer.width, primer.height, primer.input, new ItemStack(ItemRegister.manasteelScoop)).setRegistryName((ResourceLocation)manaSteelScoopRecipe));
        primer = CraftingHelper.parseShaped((Object[])new Object[]{"  m", " t ", "t  ", Character.valueOf('m'), new ItemStack(ModItems.manaResource, 1, 0), Character.valueOf('t'), Items.field_151055_y});
        ForgeRegistries.RECIPES.register(new ShapedRecipes("", primer.width, primer.height, primer.input, new ItemStack(ItemRegister.manasteelgrafter)).setRegistryName((ResourceLocation)manaSteelGrafterRecipe));
        RecipeManaInfusionBeeSpecies infusionBeeBotanical = new RecipeManaInfusionBeeSpecies(EnumBeeSpecies.BOT_BOTANIC, EnumBeeSpecies.BOT_ROOTED, 55000, EnumBeeType.DRONE);
        BotaniaAPI.manaInfusionRecipes.add(infusionBeeBotanical);
        RecipeManaInfusionBeeSpecies infusionBeeVazbee = new RecipeManaInfusionBeeSpecies(EnumBeeSpecies.BOT_VAZBEE, EnumBeeSpecies.BOT_FLORAL, 167392, EnumBeeType.PRINCESS);
        infusionBeeVazbee.setAlchemy(true);
        BotaniaAPI.manaInfusionRecipes.add(infusionBeeVazbee);
        RecipeElvenTradeBeeSpecies tradeBeeAelfheim = new RecipeElvenTradeBeeSpecies(EnumBeeSpecies.BOT_DREAMING, EnumBeeSpecies.BOT_ALFHEIM);
        BotaniaAPI.elvenTradeRecipes.add(tradeBeeAelfheim);
        BotaniaLexiconEntry entryManasteelForestryTools = new BotaniaLexiconEntry("magicbees.botania.lexicon.manasteelTools.title", BotaniaAPI.categoryTools);
        entryManasteelForestryTools.setIcon(new ItemStack(ItemRegister.manasteelScoop));
        entryManasteelForestryTools.addPage(BotaniaAPI.internalHandler.textPage("magicbees.botania.lexicon.manasteelTools.0"));
        entryManasteelForestryTools.addPage(BotaniaAPI.internalHandler.craftingRecipePage("magicbees.botania.lexicon.manasteelScoop", (ResourceLocation)manaSteelScoopRecipe));
        entryManasteelForestryTools.addPage(BotaniaAPI.internalHandler.craftingRecipePage("magicbees.botania.lexicon.manasteelGrafter", (ResourceLocation)manaSteelGrafterRecipe));
        BotaniaLexiconEntry entryBeeTrade = new BotaniaLexiconEntry("magicbees.botania.lexicon.beeAlfheim.title", BotaniaAPI.categoryAlfhomancy);
        entryBeeTrade.setIcon(BeeManager.beeRoot.getMemberStack(EnumBeeSpecies.BOT_ALFHEIM.getIndividual(), (ISpeciesType)EnumBeeType.PRINCESS));
        entryBeeTrade.setKnowledgeType(BotaniaAPI.elvenKnowledge);
        entryBeeTrade.addPage(BotaniaAPI.internalHandler.textPage("magicbees.botania.lexicon.beeAlfheim.0"));
        entryBeeTrade.addPage(BotaniaAPI.internalHandler.elvenTradesPage("magicbees.botania.lexicon.beeAlfheim.trade", (RecipeElvenTrade)tradeBeeAelfheim));
        int manaPowder = Lists.newArrayList((Object[])LibItemNames.MANA_RESOURCE_NAMES).indexOf("manaPowder");
        int redstoneRoot = Lists.newArrayList((Object[])LibItemNames.MANA_RESOURCE_NAMES).indexOf("redstoneRoot");
        Item itemManaResource = ModItems.manaResource;
        RecipePetals beegoniaRecipe = BotaniaAPI.registerPetalRecipe((ItemStack)BotaniaAPI.internalHandler.getSubTileAsStack("beegonia"), (Object[])new Object[]{new ItemStack(this.itemPetal), new ItemStack(this.itemPetal, 1, 4), new ItemStack(this.itemPetal, 1, 4), new ItemStack(this.itemPetal, 1, 15), new ItemStack(itemManaResource, 1, manaPowder), new ItemStack(itemManaResource, 1, manaPowder), new ItemStack(itemManaResource, 1, manaPowder)});
        BotaniaLexiconEntry entryBeegonia = new BotaniaLexiconEntry("tile.botania:flower.beegonia.name", BotaniaAPI.categoryGenerationFlowers);
        entryBeegonia.setLexiconPages(new LexiconPage[]{BotaniaAPI.internalHandler.textPage("magicbees.botania.lexicon.beegonia.0"), BotaniaAPI.internalHandler.textPage("magicbees.botania.lexicon.beegonia.1"), BotaniaAPI.internalHandler.petalRecipePage("magicbees.botania.lexicon.beegonia.crafting", beegoniaRecipe), BotaniaAPI.internalHandler.textPage("magicbees.botania.lexicon.beegonia.2")});
        RecipePetals hiveacynthRecipe = BotaniaAPI.registerPetalRecipe((ItemStack)BotaniaAPI.internalHandler.getSubTileAsStack("hiveacynth"), (Object[])new Object[]{new ItemStack(this.itemPetal, 1, 3), new ItemStack(this.itemPetal, 1, 9), new ItemStack(this.itemPetal, 1, 9), new ItemStack(this.itemPetal, 1, 11), new ItemStack(itemManaResource, 1, manaPowder), new ItemStack(itemManaResource, 1, manaPowder), new ItemStack(itemManaResource, 1, manaPowder), new ItemStack(itemManaResource, 1, manaPowder), new ItemStack(itemManaResource, 1, redstoneRoot)});
        BotaniaLexiconEntry entryHiveacynth = new BotaniaLexiconEntry("tile.botania:flower.hiveacynth.name", BotaniaAPI.categoryFunctionalFlowers);
        entryHiveacynth.setLexiconPages(new LexiconPage[]{BotaniaAPI.internalHandler.textPage("magicbees.botania.lexicon.hiveacynth.0"), BotaniaAPI.internalHandler.textPage("magicbees.botania.lexicon.hiveacynth.1"), BotaniaAPI.internalHandler.petalRecipePage("magicbees.botania.lexicon.hiveacynth.crafting", hiveacynthRecipe)});
        RecipePetals hibeescusRecipe = BotaniaAPI.registerPetalRecipe((ItemStack)BotaniaAPI.internalHandler.getSubTileAsStack("hibeescus"), (Object[])new Object[]{new ItemStack(this.itemPetal, 1, 1), new ItemStack(this.itemPetal, 1, 2), new ItemStack(this.itemPetal, 1, 2), new ItemStack(this.itemPetal, 1, 2), new ItemStack(this.itemPetal, 1, 14), new ItemStack(itemManaResource, 1, manaPowder), new ItemStack(ModItems.rune, 1, 0), new ItemStack(ModItems.rune, 1, 5), new ItemStack(ModItems.rune, 1, 14), new ItemStack(ModItems.rune, 1, 11), new ItemStack(ModItems.rune, 1, 15), new ItemStack(itemManaResource, 1, redstoneRoot)});
        BotaniaLexiconEntry entryHibeescus = new BotaniaLexiconEntry("tile.botania:flower.hibeescus.name", BotaniaAPI.categoryFunctionalFlowers);
        entryHibeescus.setLexiconPages(new LexiconPage[]{BotaniaAPI.internalHandler.textPage("magicbees.botania.lexicon.hibeescus.0"), BotaniaAPI.internalHandler.textPage("magicbees.botania.lexicon.hibeescus.1"), BotaniaAPI.internalHandler.textPage("magicbees.botania.lexicon.hibeescus.2"), BotaniaAPI.internalHandler.petalRecipePage("magicbees.botania.lexicon.hibeescus.crafting", hibeescusRecipe)});
    }
}

