/*
 * Decompiled with CFR 0.152.
 */
package magicbees.init;

import com.google.common.collect.Maps;
import forestry.api.recipes.RecipeManagers;
import forestry.apiculture.items.EnumPropolis;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.fluids.Fluids;
import java.util.Map;
import magicbees.init.BlockRegister;
import magicbees.init.ItemRegister;
import magicbees.item.types.EnumCombType;
import magicbees.item.types.EnumDropType;
import magicbees.item.types.EnumPollenType;
import magicbees.item.types.EnumPropolisType;
import magicbees.item.types.EnumResourceType;
import magicbees.item.types.EnumWaxType;
import magicbees.util.Config;
import magicbees.util.EnumOreResourceType;
import magicbees.util.MagicBeesResourceLocation;
import magicbees.util.Utils;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public final class RecipeRegister {
    private static ItemStack beesWax;
    private static ItemStack honeyDrop;
    private static ItemStack honeyDew;
    private static ItemStack magicWax;
    private static ItemStack refractoryWax;
    private static ItemStack pollen;
    private static ItemStack royaljelly;

    public static void init() {
        RecipeRegister.getItems();
        RecipeRegister.registerForestryRecipes();
    }

    private static void getItems() {
        if (beesWax == null) {
            ItemRegistryApiculture ai = Utils.getApicultureItems();
            beesWax = Utils.getCoreItems().beeswax.getItemStack();
            honeyDrop = ai.honeyDrop.getItemStack();
            honeyDew = ai.honeydew.getItemStack();
            refractoryWax = Utils.getCoreItems().refractoryWax.getItemStack();
            magicWax = RecipeRegister.getWax(EnumWaxType.MAGIC);
            pollen = ai.pollenCluster.getItemStack();
            royaljelly = ai.royalJelly.getItemStack();
        }
    }

    @SubscribeEvent
    public void registerVanillaRecipes(RegistryEvent.Register<IRecipe> event) {
        RecipeRegister.getItems();
        ItemStack inputStack = RecipeRegister.getResource(EnumResourceType.EXTENDED_FERTILIZER);
        ItemStack output = Utils.getCoreItems().fertilizerCompound.getItemStack(6);
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("fertilizer1"), null, (ItemStack)output, (Object[])new Object[]{" S ", " F ", " S ", Character.valueOf('F'), inputStack, Character.valueOf('S'), Blocks.field_150354_m});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("fertilizer2"), null, (ItemStack)output, (Object[])new Object[]{"   ", "SFS", "   ", Character.valueOf('F'), inputStack, Character.valueOf('S'), Blocks.field_150354_m});
        output = output.func_77946_l();
        output.func_190920_e(12);
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("fertilizer3"), null, (ItemStack)output, (Object[])new Object[]{"aaa", "aFa", "aaa", Character.valueOf('F'), inputStack, Character.valueOf('a'), Utils.getCoreItems().ash});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("exp"), null, (ItemStack)new ItemStack(Items.field_151062_by), (Object[])new Object[]{"DDD", "DBD", "DDD", Character.valueOf('D'), RecipeRegister.getDrop(EnumDropType.INTELLECT), Character.valueOf('B'), Items.field_151069_bo});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("soulsand1"), null, (ItemStack)new ItemStack(Blocks.field_150425_aM, 4), (Object[])new Object[]{"SwS", "wDw", "SwS", Character.valueOf('S'), Blocks.field_150354_m, Character.valueOf('D'), Blocks.field_150346_d, Character.valueOf('w'), RecipeRegister.getWax(EnumWaxType.SOUL)});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("soulsand2"), null, (ItemStack)new ItemStack(Blocks.field_150425_aM, 4), (Object[])new Object[]{"wSw", "SDS", "wSw", Character.valueOf('S'), Blocks.field_150354_m, Character.valueOf('D'), Blocks.field_150346_d, Character.valueOf('w'), RecipeRegister.getWax(EnumWaxType.SOUL)});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("moondial"), null, (ItemStack)new ItemStack(ItemRegister.moonDial), (Object[])new Object[]{"DqD", "qrq", "DqD", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('q'), Items.field_151128_bU, Character.valueOf('D'), "dyeGreen"});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("skullfragment"), null, (ItemStack)RecipeRegister.getResource(EnumResourceType.SKULL_FRAGMENT), (Object[])new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), RecipeRegister.getResource(EnumResourceType.SKULL_CHIP)});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("nSk"), null, (ItemStack)new ItemStack(Items.field_151144_bL, 1, 1), (Object[])new Object[]{"xxx", "xxx", Character.valueOf('x'), RecipeRegister.getResource(EnumResourceType.SKULL_FRAGMENT)});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("dragonchunk"), null, (ItemStack)RecipeRegister.getResource(EnumResourceType.DRAGON_CHUNK), (Object[])new Object[]{"xxx", "xxx", Character.valueOf('x'), RecipeRegister.getResource(EnumResourceType.DRAGON_DUST)});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("dragonegg"), null, (ItemStack)new ItemStack(Blocks.field_150380_bt, 1), (Object[])new Object[]{"ccc", "cec", "ccc", Character.valueOf('c'), RecipeRegister.getResource(EnumResourceType.DRAGON_CHUNK), Character.valueOf('e'), RecipeRegister.getResource(EnumResourceType.ESSENCE_FALSE_LIFE)});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("essence_eld1"), null, (ItemStack)RecipeRegister.getResource(EnumResourceType.ESSENCE_EVERLASTING_DURABILITY), (Object[])new Object[]{"gwg", "wiw", "gwg", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('w'), RecipeRegister.getWax(EnumWaxType.MAGIC), Character.valueOf('i'), Blocks.field_150339_S});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("essence_eld2"), null, (ItemStack)RecipeRegister.getResource(EnumResourceType.ESSENCE_EVERLASTING_DURABILITY), (Object[])new Object[]{"wgw", "gig", "wgw", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('w'), RecipeRegister.getWax(EnumWaxType.MAGIC), Character.valueOf('i'), Blocks.field_150339_S});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("essence_fl1"), null, (ItemStack)RecipeRegister.getResource(EnumResourceType.ESSENCE_FALSE_LIFE), (Object[])new Object[]{"gwg", "wfw", "gwg", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('w'), RecipeRegister.getWax(EnumWaxType.SOUL), Character.valueOf('f'), Blocks.field_150328_O});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("essence_fl2"), null, (ItemStack)RecipeRegister.getResource(EnumResourceType.ESSENCE_FALSE_LIFE), (Object[])new Object[]{"wgw", "gfg", "wgw", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('w'), RecipeRegister.getWax(EnumWaxType.SOUL), Character.valueOf('f'), Blocks.field_150328_O});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("essence_cg1"), null, (ItemStack)RecipeRegister.getResource(EnumResourceType.ESSENCE_SHALLOW_GRAVE), (Object[])new Object[]{"gwg", "wfw", "gwg", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('w'), RecipeRegister.getWax(EnumWaxType.SOUL), Character.valueOf('f'), Items.field_151078_bh});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("essence_cg2"), null, (ItemStack)RecipeRegister.getResource(EnumResourceType.ESSENCE_SHALLOW_GRAVE), (Object[])new Object[]{"wgw", "gfg", "wgw", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('w'), RecipeRegister.getWax(EnumWaxType.SOUL), Character.valueOf('f'), Items.field_151078_bh});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("essence_lt1"), null, (ItemStack)RecipeRegister.getResource(EnumResourceType.ESSENCE_LOST_TIME), (Object[])new Object[]{"wgw", "gcg", "wgw", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('w'), RecipeRegister.getWax(EnumWaxType.SOUL), Character.valueOf('c'), Items.field_151113_aN});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("essence_lt2"), null, (ItemStack)RecipeRegister.getResource(EnumResourceType.ESSENCE_LOST_TIME), (Object[])new Object[]{"gwg", "wcw", "gwg", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('w'), RecipeRegister.getWax(EnumWaxType.SOUL), Character.valueOf('c'), Items.field_151113_aN});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("essence_fp1"), null, (ItemStack)RecipeRegister.getResource(EnumResourceType.ESSENCE_FICKLE_PERMANENCE), (Object[])new Object[]{"wew", "gcg", "wew", Character.valueOf('w'), RecipeRegister.getWax(EnumWaxType.SOUL), Character.valueOf('c'), Items.field_151064_bs, Character.valueOf('e'), Items.field_151110_aK, Character.valueOf('g'), Blocks.field_150426_aN});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("essence_fp2"), null, (ItemStack)RecipeRegister.getResource(EnumResourceType.ESSENCE_FICKLE_PERMANENCE), (Object[])new Object[]{"wgw", "ece", "wgw", Character.valueOf('w'), RecipeRegister.getWax(EnumWaxType.SOUL), Character.valueOf('c'), Items.field_151064_bs, Character.valueOf('e'), Items.field_151110_aK, Character.valueOf('g'), Blocks.field_150426_aN});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("essence_scob"), null, (ItemStack)RecipeRegister.getResource(EnumResourceType.ESSENCE_SCORNFUL_OBLIVION), (Object[])new Object[]{"gst", "sEs", "tsg", Character.valueOf('g'), RecipeRegister.getResource(EnumResourceType.ESSENCE_SHALLOW_GRAVE), Character.valueOf('t'), RecipeRegister.getResource(EnumResourceType.ESSENCE_LOST_TIME), Character.valueOf('s'), new ItemStack(Items.field_151144_bL, 1, 1), Character.valueOf('E'), Blocks.field_150380_bt});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("magicframe"), null, (ItemStack)new ItemStack((Item)ItemRegister.magicFrame), (Object[])new Object[]{"www", "wfw", "www", Character.valueOf('w'), magicWax, Character.valueOf('f'), Utils.getApicultureItems().frameUntreated});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("temporalframe"), null, (ItemStack)new ItemStack((Item)ItemRegister.temporalFrame), (Object[])new Object[]{"sPs", "PfP", "sPs", Character.valueOf('s'), Blocks.field_150354_m, Character.valueOf('P'), RecipeRegister.getPollen(EnumPollenType.PHASED), Character.valueOf('f'), ItemRegister.magicFrame});
        Ingredient input = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)ItemRegister.magicFrame)});
        GameRegistry.addShapelessRecipe((ResourceLocation)new MagicBeesResourceLocation("ressilientframe"), null, (ItemStack)new ItemStack((Item)ItemRegister.resilientFrame), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeRegister.getResource(EnumResourceType.ESSENCE_EVERLASTING_DURABILITY)}), input});
        GameRegistry.addShapelessRecipe((ResourceLocation)new MagicBeesResourceLocation("gentleframe"), null, (ItemStack)new ItemStack((Item)ItemRegister.gentleFrame), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeRegister.getResource(EnumResourceType.ESSENCE_FALSE_LIFE)}), input});
        GameRegistry.addShapelessRecipe((ResourceLocation)new MagicBeesResourceLocation("necrotictframe"), null, (ItemStack)new ItemStack((Item)ItemRegister.necroticFrame), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeRegister.getResource(EnumResourceType.ESSENCE_SHALLOW_GRAVE)}), input});
        GameRegistry.addShapelessRecipe((ResourceLocation)new MagicBeesResourceLocation("metabolicframe"), null, (ItemStack)new ItemStack((Item)ItemRegister.metabolicFrame), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeRegister.getResource(EnumResourceType.ESSENCE_FICKLE_PERMANENCE)}), input});
        GameRegistry.addShapelessRecipe((ResourceLocation)new MagicBeesResourceLocation("temporalframe"), null, (ItemStack)new ItemStack((Item)ItemRegister.temporalFrame), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeRegister.getResource(EnumResourceType.ESSENCE_LOST_TIME)}), input});
        GameRegistry.addShapelessRecipe((ResourceLocation)new MagicBeesResourceLocation("oblivionframe"), null, (ItemStack)new ItemStack((Item)ItemRegister.oblivionFrame), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeRegister.getResource(EnumResourceType.ESSENCE_SCORNFUL_OBLIVION)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{Utils.getApicultureItems().frameProven.getItemStack()})});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("effectjar"), null, (ItemStack)new ItemStack(BlockRegister.effectJar), (Object[])new Object[]{"GSG", "QPQ", "GGG", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('S'), "slabWood", Character.valueOf('P'), RecipeRegister.getPollen(EnumPollenType.UNUSUAL), Character.valueOf('Q'), Items.field_151128_bU});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("enchanted_earth_1"), null, (ItemStack)new ItemStack(BlockRegister.enchantedEarth), (Object[])new Object[]{"d d", " e ", "d d", Character.valueOf('d'), new ItemStack(Blocks.field_150346_d, 1, Short.MAX_VALUE), Character.valueOf('e'), RecipeRegister.getResource(EnumResourceType.ESSENCE_FALSE_LIFE)});
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("enchanted_earth_2"), null, (ItemStack)new ItemStack(BlockRegister.enchantedEarth), (Object[])new Object[]{" d ", "ded", " d ", Character.valueOf('d'), new ItemStack(Blocks.field_150346_d, 1, Short.MAX_VALUE), Character.valueOf('e'), RecipeRegister.getResource(EnumResourceType.ESSENCE_FALSE_LIFE)});
        output = RecipeRegister.getResource(EnumResourceType.DIMENSIONAL_SINGULARITY);
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("dimensionalsingularity"), null, (ItemStack)output, (Object[])new Object[]{" G ", "QEQ", " W ", Character.valueOf('E'), Items.field_151061_bv, Character.valueOf('Q'), Blocks.field_150371_ca, Character.valueOf('W'), Blocks.field_150377_bs, Character.valueOf('G'), Blocks.field_150340_R});
        output = new ItemStack((Item)ItemRegister.mysteriousMagnet);
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("mysteriousmagnet0"), null, (ItemStack)output, (Object[])new Object[]{" i ", "cSc", " d ", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('c'), Items.field_151111_aL, Character.valueOf('d'), Items.field_151045_i, Character.valueOf('S'), RecipeRegister.getResource(EnumResourceType.DIMENSIONAL_SINGULARITY)});
        for (int level = 1; level <= Config.magnetMaxLevel; ++level) {
            output = new ItemStack((Item)ItemRegister.mysteriousMagnet, 1, level * 2);
            GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("mysteriousmagnet" + level), null, (ItemStack)output, (Object[])new Object[]{" d ", "mSm", " B ", Character.valueOf('d'), Items.field_151045_i, Character.valueOf('m'), new ItemStack((Item)ItemRegister.mysteriousMagnet, 1, (level - 1) * 2), Character.valueOf('B'), Blocks.field_150451_bX, Character.valueOf('S'), RecipeRegister.getResource(EnumResourceType.DIMENSIONAL_SINGULARITY)});
        }
        EnumOreResourceType.registerRecipes((IForgeRegistry<IRecipe>)event.getRegistry());
    }

    private static void registerForestryRecipes() {
        RecipeRegister.registerCentrifugeRecipes();
        RecipeRegister.registerCarpenterRecipes();
    }

    private static void registerCentrifugeRecipes() {
        CombCentrifugeRecipe recipe = new CombCentrifugeRecipe(EnumCombType.MUNDANE);
        recipe.addProduct(beesWax, 0.9f);
        recipe.addProduct(honeyDrop, 0.6f);
        recipe.addProduct(magicWax, 0.1f);
        recipe.register(20);
        recipe = new CombCentrifugeRecipe(EnumCombType.MOLTEN);
        recipe.addProduct(refractoryWax, 0.86f);
        recipe.addProduct(honeyDrop, 0.087f);
        recipe.register(20);
        recipe = new CombCentrifugeRecipe(EnumCombType.FORGOTTEN);
        recipe.addProduct(RecipeRegister.getWax(EnumWaxType.AMNESIC), 0.5f);
        recipe.addProduct(RecipeRegister.getPropolis(EnumPropolis.PULSATING), 0.5f);
        recipe.addProduct(honeyDrop, 0.4f);
        recipe.register(20);
        recipe = new CombCentrifugeRecipe(EnumCombType.OCCULT);
        recipe.addProduct(magicWax, 1.0f);
        recipe.addProduct(honeyDrop, 0.6f);
        recipe.register(20);
        recipe = new CombCentrifugeRecipe(EnumCombType.OTHERWORLDLY);
        recipe.addProduct(beesWax, 0.5f);
        recipe.addProduct(magicWax, 0.22f);
        recipe.addProduct(honeyDrop, 1.0f);
        recipe.register(20);
        recipe = new CombCentrifugeRecipe(EnumCombType.PAPERY);
        recipe.addProduct(beesWax, 0.8f);
        recipe.addProduct(magicWax, 0.2f);
        recipe.addProduct(new ItemStack(Items.field_151121_aF), 0.057f);
        recipe.register(20);
        recipe = new CombCentrifugeRecipe(EnumCombType.INTELLECT);
        recipe.addProduct(magicWax, 0.9f);
        recipe.addProduct(honeyDew, 0.4f);
        recipe.addProduct(RecipeRegister.getDrop(EnumDropType.INTELLECT), 0.1f);
        recipe.register(20);
        recipe = new CombCentrifugeRecipe(EnumCombType.FURTIVE);
        recipe.addProduct(beesWax, 0.9f);
        recipe.addProduct(RecipeRegister.getPropolis(EnumPropolis.NORMAL), 0.2f);
        recipe.addProduct(honeyDew, 0.35f);
        recipe.register(20);
        recipe = new CombCentrifugeRecipe(EnumCombType.SOUL);
        recipe.addProduct(RecipeRegister.getWax(EnumWaxType.SOUL), 0.95f);
        recipe.addProduct(honeyDew, 0.26f);
        recipe.register(20);
        recipe = new CombCentrifugeRecipe(EnumCombType.TEMPORAL);
        recipe.addProduct(magicWax, 1.0f);
        recipe.addProduct(RecipeRegister.getPollen(EnumPollenType.PHASED), 0.055f);
        recipe.addProduct(honeyDew, 0.6f);
        recipe.register(20);
        recipe = new CombCentrifugeRecipe(EnumCombType.TRANSMUTED);
        recipe.addProduct(beesWax, 0.8f);
        recipe.addProduct(magicWax, 0.8f);
        recipe.addProduct(RecipeRegister.getPropolis(EnumPropolisType.UNSTABLE), 0.15f);
        recipe.register(20);
        recipe = new CombCentrifugeRecipe(EnumCombType.AIRY);
        recipe.addProduct(magicWax, 1.0f);
        recipe.addProduct(new ItemStack(Items.field_151008_G), 0.6f);
        recipe.register(20);
        recipe = new CombCentrifugeRecipe(EnumCombType.FIREY);
        recipe.addProduct(magicWax, 1.0f);
        recipe.addProduct(new ItemStack(Items.field_151065_br), 0.6f);
        recipe.register(20);
        recipe = new CombCentrifugeRecipe(EnumCombType.WATERY);
        recipe.addProduct(magicWax, 1.0f);
        recipe.addProduct(new ItemStack(Items.field_151100_aR), 0.6f);
        recipe.register(20);
        recipe = new CombCentrifugeRecipe(EnumCombType.EARTHY);
        recipe.addProduct(magicWax, 1.0f);
        recipe.addProduct(new ItemStack(Items.field_151119_aD), 0.6f);
        recipe.register(20);
        recipe = new CombCentrifugeRecipe(EnumCombType.TE_DESTABILIZED);
        recipe.addProduct(RecipeRegister.getWax(EnumWaxType.MAGIC), 0.55f);
        recipe.addProduct(RecipeRegister.getDrop(EnumDropType.DESTABILIZED), 0.22f);
        recipe.register(20);
        recipe = new CombCentrifugeRecipe(EnumCombType.TE_CARBON);
        recipe.addProduct(RecipeRegister.getWax(EnumWaxType.MAGIC), 0.55f);
        recipe.addProduct(RecipeRegister.getDrop(EnumDropType.CARBON), 0.22f);
        recipe.register(20);
        recipe = new CombCentrifugeRecipe(EnumCombType.TE_LUX);
        recipe.addProduct(RecipeRegister.getWax(EnumWaxType.MAGIC), 0.55f);
        recipe.addProduct(RecipeRegister.getDrop(EnumDropType.LUX), 0.22f);
        recipe.register(20);
        recipe = new CombCentrifugeRecipe(EnumCombType.TE_ENDEARING);
        recipe.addProduct(RecipeRegister.getWax(EnumWaxType.MAGIC), 0.55f);
        recipe.addProduct(RecipeRegister.getDrop(EnumDropType.ENDEARING), 0.22f);
        recipe.register(20);
    }

    private static void registerCarpenterRecipes() {
        ItemStack output = Utils.getApicultureBlocks().candle.getUnlitCandle(24);
        RecipeManagers.carpenterManager.addRecipe(30, new FluidStack(FluidRegistry.WATER, 600), ItemStack.field_190927_a, output.func_77946_l(), new Object[]{" S ", "WWW", "WWW", Character.valueOf('W'), ItemRegister.waxItem, Character.valueOf('S'), Items.field_151007_F});
        output.func_190920_e(6);
        ItemStack input = Utils.getCoreItems().craftingMaterial.getSilkWisp();
        RecipeManagers.carpenterManager.addRecipe(30, new FluidStack(FluidRegistry.WATER, 600), ItemStack.field_190927_a, output.func_77946_l(), new Object[]{"WSW", Character.valueOf('W'), ItemRegister.waxItem, Character.valueOf('S'), input});
        output = ItemRegister.resourceItem.getStackFromType(EnumResourceType.AROMATIC_LUMP, 2);
        RecipeManagers.carpenterManager.addRecipe(30, Fluids.FOR_HONEY.getFluid(1000), ItemStack.field_190927_a, output.func_77946_l(), new Object[]{" P ", "JDJ", " P ", Character.valueOf('P'), pollen, Character.valueOf('J'), royaljelly, Character.valueOf('D'), RecipeRegister.getDrop(EnumDropType.ENCHANTED)});
        RecipeManagers.carpenterManager.addRecipe(30, Fluids.FOR_HONEY.getFluid(1000), ItemStack.field_190927_a, output.func_77946_l(), new Object[]{" J ", "PDP", " J ", Character.valueOf('P'), pollen, Character.valueOf('J'), royaljelly, Character.valueOf('D'), RecipeRegister.getDrop(EnumDropType.ENCHANTED)});
    }

    private static ItemStack getWax(EnumWaxType wax) {
        return ItemRegister.waxItem.getStackFromType(wax);
    }

    private static ItemStack getDrop(EnumDropType drop) {
        return ItemRegister.dropItem.getStackFromType(drop);
    }

    private static ItemStack getPollen(EnumPollenType pollen) {
        return ItemRegister.pollenItem.getStackFromType(pollen);
    }

    private static ItemStack getPropolis(EnumPropolisType propolis) {
        return ItemRegister.propolisItem.getStackFromType(propolis);
    }

    private static ItemStack getResource(EnumResourceType resource) {
        return ItemRegister.resourceItem.getStackFromType(resource);
    }

    private static ItemStack getPropolis(EnumPropolis propolis) {
        return Utils.getApicultureItems().propolis.get(propolis, 1);
    }

    private static class CombCentrifugeRecipe {
        private EnumCombType comb;
        private final Map<ItemStack, Float> products;

        private CombCentrifugeRecipe(EnumCombType comb) {
            this.comb = comb;
            this.products = Maps.newHashMap();
        }

        protected void addProduct(ItemStack stack, float chance) {
            this.products.put(stack.func_77946_l(), Float.valueOf(chance));
        }

        protected void register(int time) {
            RecipeManagers.centrifugeManager.addRecipe(time, ItemRegister.combItem.getStackFromType(this.comb), this.products);
        }
    }
}

