/*
 * Decompiled with CFR 0.152.
 */
package magicbees.elec332.corerepack.compat.forestry;

import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import javax.annotation.Nonnull;
import magicbees.elec332.corerepack.compat.forestry.IIndividualDefinition;
import net.minecraft.item.ItemStack;

public final class DefaultIndividualDefinition<G extends IGenome, I extends IIndividual, T extends ISpeciesType>
implements IIndividualDefinition<G, I, T> {
    private final G g;
    private final IAllele[] alleles;
    private final ISpeciesRoot speciesRoot;

    DefaultIndividualDefinition(IAllele[] alleles, ISpeciesRoot speciesRoot) {
        this.alleles = alleles;
        this.speciesRoot = speciesRoot;
        this.g = this.speciesRoot.templateAsGenome(this.alleles);
    }

    @Override
    @Nonnull
    public G getGenome() {
        return this.g;
    }

    @Override
    @Nonnull
    public IAllele[] getAlleles() {
        IAllele[] ret = new IAllele[this.alleles.length];
        System.arraycopy(this.alleles, 0, ret, 0, this.alleles.length);
        return ret;
    }

    @Override
    public I getIndividual() {
        return (I)this.speciesRoot.templateAsIndividual(this.alleles);
    }

    @Override
    public ItemStack getMemberStack(T speciesType) {
        return this.speciesRoot.getMemberStack(this.getIndividual(), speciesType);
    }
}

