/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.crafting;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public final class RecipeHelper {
    public static void addShapedRecipe(@Nonnull ItemStack output, Object ... inputs) {
        RecipeHelper.addShapedRecipe(null, output, inputs);
    }

    public static void addShapedRecipe(@Nullable ResourceLocation group, @Nonnull ItemStack output, Object ... inputs) {
        ResourceLocation name = output.func_77973_b().getRegistryName();
        if (null == name) {
            throw new IllegalArgumentException("Invalid output item registry name");
        }
        RecipeHelper.addShapedRecipe(name, group, output, inputs);
    }

    public static void addShapedRecipe(@Nonnull ResourceLocation name, @Nullable ResourceLocation group, @Nonnull ItemStack output, Object ... inputs) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])inputs);
        ForgeRegistries.RECIPES.register(new ShapedRecipes(RecipeHelper.groupName(group), primer.width, primer.height, primer.input, output).setRegistryName(name));
    }

    public static void addShapelessRecipe(@Nonnull ItemStack output, Object ... inputs) {
        RecipeHelper.addShapelessRecipe(null, output, inputs);
    }

    public static void addShapelessRecipe(@Nullable ResourceLocation group, @Nonnull ItemStack output, Object ... inputs) {
        ResourceLocation name = output.func_77973_b().getRegistryName();
        if (null == name) {
            throw new IllegalArgumentException("Invalid output item registry name");
        }
        RecipeHelper.addShapelessRecipe(name, group, output, inputs);
    }

    public static void addShapelessRecipe(@Nonnull ResourceLocation name, @Nullable ResourceLocation group, @Nonnull ItemStack output, Object ... inputs) {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (Object input : inputs) {
            ingredients.add((Object)RecipeHelper.asIngredient(input));
        }
        ForgeRegistries.RECIPES.register(new ShapelessRecipes(RecipeHelper.groupName(group), output, ingredients).setRegistryName(name));
    }

    public static void addShapedOreDictRecipe(@Nonnull ItemStack output, Object ... inputs) {
        RecipeHelper.addShapedOreDictRecipe(null, output, inputs);
    }

    public static void addShapedOreDictRecipe(@Nullable ResourceLocation group, @Nonnull ItemStack output, Object ... inputs) {
        ResourceLocation name = output.func_77973_b().getRegistryName();
        if (null == name) {
            throw new IllegalArgumentException("Invalid output item registry name");
        }
        RecipeHelper.addShapedOreDictRecipe(name, group, output, inputs);
    }

    public static void addShapedOreDictRecipe(@Nonnull ResourceLocation name, @Nullable ResourceLocation group, @Nonnull ItemStack output, Object ... inputs) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])inputs);
        ForgeRegistries.RECIPES.register(new ShapedOreRecipe(RecipeHelper.groupResourceLocation(group), output, primer).setRegistryName(name));
    }

    public static void addShapelessOreDictRecipe(@Nonnull ItemStack output, Object ... inputs) {
        RecipeHelper.addShapelessOreDictRecipe(null, output, inputs);
    }

    public static void addShapelessOreDictRecipe(@Nullable ResourceLocation group, @Nonnull ItemStack output, Object ... inputs) {
        ResourceLocation name = output.func_77973_b().getRegistryName();
        if (null == name) {
            throw new IllegalArgumentException("Invalid output item registry name");
        }
        RecipeHelper.addShapelessOreDictRecipe(name, group, output, inputs);
    }

    public static void addShapelessOreDictRecipe(@Nonnull ResourceLocation name, @Nullable ResourceLocation group, @Nonnull ItemStack output, Object ... inputs) {
        ForgeRegistries.RECIPES.register(new ShapelessOreRecipe(RecipeHelper.groupResourceLocation(group), output, inputs).setRegistryName(name));
    }

    @Nonnull
    private static String groupName(@Nullable ResourceLocation group) {
        return null == group ? "" : group.toString();
    }

    @Nonnull
    private static ResourceLocation groupResourceLocation(@Nullable ResourceLocation group) {
        return null == group ? new ResourceLocation("") : group;
    }

    private static Ingredient asIngredient(Object object) {
        if (object instanceof Item) {
            return Ingredient.func_193368_a((Item[])new Item[]{(Item)object});
        }
        if (object instanceof Block) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)object)});
        }
        if (object instanceof ItemStack) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)object});
        }
        if (object instanceof String) {
            return new OreIngredient((String)object);
        }
        throw new IllegalArgumentException("Cannot convert object of type " + object.getClass().toString() + " to an Ingredient!");
    }
}

