/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeSecurityManager;
import com.raoulvdberge.refinedstorage.network.MessageHandlerPlayerToServer;
import com.raoulvdberge.refinedstorage.tile.TileSecurityManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageSecurityManagerUpdate
extends MessageHandlerPlayerToServer<MessageSecurityManagerUpdate>
implements IMessage {
    private int x;
    private int y;
    private int z;
    private Permission permission;
    private boolean state;

    public MessageSecurityManagerUpdate() {
    }

    public MessageSecurityManagerUpdate(TileSecurityManager securityManager, Permission permission, boolean state) {
        this.x = securityManager.func_174877_v().func_177958_n();
        this.y = securityManager.func_174877_v().func_177956_o();
        this.z = securityManager.func_174877_v().func_177952_p();
        this.permission = permission;
        this.state = state;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        int id = buf.readInt();
        this.permission = Permission.INSERT;
        this.state = buf.readBoolean();
        for (Permission otherPermission : Permission.values()) {
            if (otherPermission.getId() != id) continue;
            this.permission = otherPermission;
            break;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.permission.getId());
        buf.writeBoolean(this.state);
    }

    @Override
    protected void handle(MessageSecurityManagerUpdate message, EntityPlayerMP player) {
        TileEntity tile = player.func_130014_f_().func_175625_s(new BlockPos(message.x, message.y, message.z));
        if (tile instanceof TileSecurityManager) {
            ((NetworkNodeSecurityManager)((TileSecurityManager)tile).getNode()).updatePermission(message.permission, message.state);
        }
    }
}

