/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskErrorType;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawer;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.CraftingPattern;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementError;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.control.Scrollbar;
import com.raoulvdberge.refinedstorage.item.ItemPattern;
import com.raoulvdberge.refinedstorage.network.MessageGridCraftingStart;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCraftingPreview
extends GuiBase {
    private static final int VISIBLE_ROWS = 5;
    private List<ICraftingPreviewElement> stacks;
    private GuiScreen parent;
    private int hash;
    private int quantity;
    private GuiButton startButton;
    private GuiButton cancelButton;
    private ItemStack hoveringStack;
    private FluidStack hoveringFluid;
    private IElementDrawers drawers = new CraftingPreviewElementDrawers();
    private boolean fluids;

    public GuiCraftingPreview(GuiScreen parent, List<ICraftingPreviewElement> stacks, int hash, int quantity, boolean fluids) {
        super(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 254, 201);
        this.stacks = new ArrayList<ICraftingPreviewElement>(stacks);
        this.parent = parent;
        this.hash = hash;
        this.quantity = quantity;
        this.fluids = fluids;
        this.scrollbar = new Scrollbar(235, 20, 12, 149);
    }

    @Override
    public void init(int x, int y) {
        this.cancelButton = this.addButton(x + 55, y + 201 - 20 - 7, 50, 20, GuiCraftingPreview.t("gui.cancel", new Object[0]));
        this.startButton = this.addButton(x + 129, y + 201 - 20 - 7, 50, 20, GuiCraftingPreview.t("misc.refinedstorage:start", new Object[0]));
        this.startButton.field_146124_l = this.stacks.stream().noneMatch(ICraftingPreviewElement::hasMissing) && this.getErrorType() == null;
    }

    @Override
    public void update(int x, int y) {
        if (this.scrollbar != null) {
            this.scrollbar.setEnabled(this.getRows() > 5);
            this.scrollbar.setMaxOffset(this.getRows() - 5);
        }
    }

    @Nullable
    private CraftingTaskErrorType getErrorType() {
        if (this.stacks.size() == 1 && this.stacks.get(0) instanceof CraftingPreviewElementError) {
            return ((CraftingPreviewElementError)this.stacks.get(0)).getType();
        }
        return null;
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("gui/crafting_preview.png");
        this.drawTexture(x, y, 0, 0, this.screenWidth, this.screenHeight);
        if (this.getErrorType() != null) {
            GuiCraftingPreview.func_73734_a((int)(x + 7), (int)(y + 20), (int)(x + 228), (int)(y + 169), (int)-2368549);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        block12: {
            int y;
            int x;
            block11: {
                float scale;
                this.drawString(7, 7, GuiCraftingPreview.t("gui.refinedstorage:crafting_preview", new Object[0]));
                x = 7;
                y = 15;
                float f = scale = this.field_146289_q.func_82883_a() ? 1.0f : 0.5f;
                if (this.getErrorType() == null) break block11;
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
                this.drawString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 11, scale), GuiCraftingPreview.t("gui.refinedstorage:crafting_preview.error", new Object[0]));
                switch (this.getErrorType()) {
                    case RECURSIVE: {
                        this.drawString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 21, scale), GuiCraftingPreview.t("gui.refinedstorage:crafting_preview.error.recursive.0", new Object[0]));
                        this.drawString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 31, scale), GuiCraftingPreview.t("gui.refinedstorage:crafting_preview.error.recursive.1", new Object[0]));
                        this.drawString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 41, scale), GuiCraftingPreview.t("gui.refinedstorage:crafting_preview.error.recursive.2", new Object[0]));
                        this.drawString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 51, scale), GuiCraftingPreview.t("gui.refinedstorage:crafting_preview.error.recursive.3", new Object[0]));
                        this.drawString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 61, scale), GuiCraftingPreview.t("gui.refinedstorage:crafting_preview.error.recursive.4", new Object[0]));
                        GlStateManager.func_179121_F();
                        CraftingPattern pattern = ItemPattern.getPatternFromCache((World)this.parent.field_146297_k.field_71441_e, (ItemStack)this.stacks.get(0).getElement());
                        int yy = 83;
                        for (ItemStack output : pattern.getOutputs()) {
                            if (output == null) continue;
                            GlStateManager.func_179094_E();
                            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
                            this.drawString(RenderUtils.getOffsetOnScale(x + 25, scale), RenderUtils.getOffsetOnScale(yy + 6, scale), output.func_82833_r());
                            GlStateManager.func_179121_F();
                            RenderHelper.func_74520_c();
                            GlStateManager.func_179126_j();
                            this.drawItem(x + 5, yy, output);
                            RenderHelper.func_74518_a();
                            yy += 17;
                        }
                        break block12;
                    }
                    case TOO_COMPLEX: {
                        this.drawString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 21, scale), GuiCraftingPreview.t("gui.refinedstorage:crafting_preview.error.too_complex.0", new Object[0]));
                        this.drawString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 31, scale), GuiCraftingPreview.t("gui.refinedstorage:crafting_preview.error.too_complex.1", new Object[0]));
                        GlStateManager.func_179121_F();
                    }
                }
                break block12;
            }
            int slot = this.scrollbar != null ? this.scrollbar.getOffset() * 3 : 0;
            RenderHelper.func_74520_c();
            GlStateManager.func_179126_j();
            this.hoveringStack = null;
            this.hoveringFluid = null;
            for (int i = 0; i < 15; ++i) {
                if (slot < this.stacks.size()) {
                    ICraftingPreviewElement stack = this.stacks.get(slot);
                    stack.draw(x, y + 5, this.drawers);
                    if (this.inBounds(x + 5, y + 7, 16, 16, mouseX, mouseY)) {
                        ItemStack itemStack = this.hoveringStack = stack.getId().equals("item_renderer") ? (ItemStack)stack.getElement() : null;
                        if (this.hoveringStack == null) {
                            FluidStack fluidStack = this.hoveringFluid = stack.getId().equals("fluid_renderer") ? (FluidStack)stack.getElement() : null;
                        }
                    }
                }
                if ((i + 1) % 3 == 0) {
                    x = 7;
                    y += 30;
                } else {
                    x += 74;
                }
                ++slot;
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.hoveringStack != null) {
            this.drawTooltip(this.hoveringStack, mouseX, mouseY, this.hoveringStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)));
        } else if (this.hoveringFluid != null) {
            this.drawTooltip(mouseX, mouseY, this.hoveringFluid.getLocalizedName());
        }
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        if (keyCode == 28 && this.startButton.field_146124_l) {
            this.startRequest();
        } else if (keyCode == 1) {
            this.close();
        } else {
            super.func_73869_a(character, keyCode);
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == this.startButton.field_146127_k) {
            this.startRequest();
        } else if (button.field_146127_k == this.cancelButton.field_146127_k) {
            this.close();
        }
    }

    private void startRequest() {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageGridCraftingStart(this.hash, this.quantity, this.fluids));
        this.close();
    }

    private int getRows() {
        return Math.max(0, (int)Math.ceil((float)this.stacks.size() / 3.0f));
    }

    private void close() {
        FMLClientHandler.instance().showGuiScreen((Object)this.parent);
    }

    public class CraftingPreviewElementDrawers
    extends GuiBase.ElementDrawers {
        private IElementDrawer<Integer> overlayDrawer = (x, y, colour) -> {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            Gui.func_73734_a((int)x, (int)y, (int)(x + 73), (int)(y + 29), (int)colour);
        };

        @Override
        public IElementDrawer<Integer> getOverlayDrawer() {
            return this.overlayDrawer;
        }
    }
}

