/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeStorageMonitor;
import com.raoulvdberge.refinedstorage.block.BlockNode;
import com.raoulvdberge.refinedstorage.block.info.BlockDirection;
import com.raoulvdberge.refinedstorage.block.info.BlockInfoBuilder;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import com.raoulvdberge.refinedstorage.render.tesr.TileEntitySpecialRendererStorageMonitor;
import com.raoulvdberge.refinedstorage.tile.TileStorageMonitor;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStorageMonitor
extends BlockNode {
    public BlockStorageMonitor() {
        super(BlockInfoBuilder.forId("storage_monitor").tileEntity(TileStorageMonitor::new).create());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
        modelRegistration.setModel(this, 0, new ModelResourceLocation(this.info.getId(), "connected=false,direction=north"));
        modelRegistration.setTesr(TileStorageMonitor.class, new TileEntitySpecialRendererStorageMonitor());
    }

    @Override
    @Nullable
    public BlockDirection getDirection() {
        return BlockDirection.HORIZONTAL;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack held = player.field_71071_by.func_70448_g();
            if (player.func_70093_af()) {
                this.openNetworkGui(25, player, world, pos, side);
            } else {
                NetworkNodeStorageMonitor storageMonitor = (NetworkNodeStorageMonitor)((TileStorageMonitor)world.func_175625_s(pos)).getNode();
                if (!held.func_190926_b()) {
                    return storageMonitor.deposit(player, held);
                }
                return storageMonitor.depositAll(player);
            }
        }
        return true;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        super.func_180649_a(world, pos, player);
        if (!world.field_72995_K) {
            RayTraceResult rayResult = ForgeHooks.rayTraceEyes((EntityLivingBase)player, (double)(player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() + 1.0));
            if (rayResult == null) {
                return;
            }
            ((NetworkNodeStorageMonitor)((TileStorageMonitor)world.func_175625_s(pos)).getNode()).extract(player, rayResult.field_178784_b);
        }
    }

    @Override
    public boolean hasConnectedState() {
        return true;
    }
}

