/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.network.MessageGridFluidDelta;
import com.raoulvdberge.refinedstorage.network.MessageGridFluidUpdate;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class StorageCacheListenerGridFluid
implements IStorageCacheListener<FluidStack> {
    private EntityPlayerMP player;
    private INetwork network;

    public StorageCacheListenerGridFluid(EntityPlayerMP player, INetwork network) {
        this.player = player;
        this.network = network;
    }

    @Override
    public void onAttached() {
        RS.INSTANCE.network.sendTo((IMessage)new MessageGridFluidUpdate(this.network, this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (EntityPlayer)this.player)), this.player);
    }

    @Override
    public void onInvalidated() {
    }

    @Override
    public void onChanged(@Nonnull FluidStack stack, int size) {
        RS.INSTANCE.network.sendTo((IMessage)new MessageGridFluidDelta(this.network, this.network.getFluidStorageTracker(), stack, size), this.player);
    }

    @Override
    public void onChangedBulk(@Nonnull List<Pair<FluidStack, Integer>> stacks) {
        for (Pair<FluidStack, Integer> stack : stacks) {
            this.onChanged((FluidStack)stack.getLeft(), (int)((Integer)stack.getRight()));
        }
    }
}

