/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class NetworkNodeCrafter
extends NetworkNode
implements ICraftingPatternContainer {
    public static final String ID = "crafter";
    public static final String DEFAULT_NAME = "gui.refinedstorage:crafter";
    private static final String NBT_DISPLAY_NAME = "DisplayName";
    private static final String NBT_UUID = "CrafterUuid";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_LOCKED = "Locked";
    private static final String NBT_WAS_POWERED = "WasPowered";
    private ItemHandlerBase patternsInventory = new ItemHandlerBase(9, new ListenerNetworkNode(this), new Predicate[]{s -> NetworkNodeCrafter.isValidPatternInSlot(this.world, s)}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (!NetworkNodeCrafter.this.reading) {
                if (!NetworkNodeCrafter.this.world.field_72995_K) {
                    NetworkNodeCrafter.this.invalidate();
                }
                if (NetworkNodeCrafter.this.network != null) {
                    NetworkNodeCrafter.this.network.getCraftingManager().rebuild();
                }
            }
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private List<ICraftingPattern> patterns = new ArrayList<ICraftingPattern>();
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (Consumer<Integer>)new ListenerNetworkNode(this), 2);
    private boolean visited = false;
    private CrafterMode mode = CrafterMode.IGNORE;
    private boolean locked = false;
    private boolean wasPowered;
    private boolean reading;
    @Nullable
    private String displayName;
    @Nullable
    private UUID uuid = null;

    public static boolean isValidPatternInSlot(World world, ItemStack stack) {
        return stack.func_77973_b() instanceof ICraftingPatternProvider && ((ICraftingPatternProvider)stack.func_77973_b()).create(world, stack, null).isValid();
    }

    public NetworkNodeCrafter(World world, BlockPos pos) {
        super(world, pos);
    }

    private void invalidate() {
        this.patterns.clear();
        for (int i = 0; i < this.patternsInventory.getSlots(); ++i) {
            ICraftingPattern pattern;
            ItemStack patternStack = this.patternsInventory.getStackInSlot(i);
            if (patternStack.func_190926_b() || !(pattern = ((ICraftingPatternProvider)patternStack.func_77973_b()).create(this.world, patternStack, this)).isValid()) continue;
            this.patterns.add(pattern);
        }
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.crafterUsage + this.upgrades.getEnergyUsage() + RS.INSTANCE.config.crafterPerPatternUsage * this.patterns.size();
    }

    @Override
    public void update() {
        super.update();
        if (this.ticks == 1) {
            this.invalidate();
        }
        if (this.mode == CrafterMode.PULSE_INSERTS_NEXT_SET) {
            if (this.world.func_175640_z(this.pos)) {
                this.wasPowered = true;
                this.markDirty();
            } else if (this.wasPowered) {
                this.wasPowered = false;
                this.locked = false;
                this.markDirty();
            }
        }
    }

    @Override
    protected void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        network.getCraftingManager().rebuild();
    }

    @Override
    public void onDisconnected(INetwork network) {
        super.onDisconnected(network);
        network.getCraftingManager().getTasks().stream().filter(task -> task.getPattern().getContainer().getPosition().equals((Object)this.pos)).forEach(task -> network.getCraftingManager().cancel(task.getId()));
    }

    @Override
    protected void onDirectionChanged() {
        if (this.network != null) {
            this.network.getCraftingManager().rebuild();
        }
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        this.reading = true;
        StackUtils.readItems((IItemHandlerModifiable)this.patternsInventory, 0, tag);
        if (API.instance().getOneSixMigrationHelper().migratePatternInventory((IItemHandler)this.patternsInventory)) {
            this.markDirty();
        }
        this.invalidate();
        this.reading = false;
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 1, tag);
        if (tag.func_74764_b(NBT_DISPLAY_NAME)) {
            this.displayName = tag.func_74779_i(NBT_DISPLAY_NAME);
        }
        if (tag.func_186855_b(NBT_UUID)) {
            this.uuid = tag.func_186857_a(NBT_UUID);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = CrafterMode.getById(tag.func_74762_e(NBT_MODE));
        }
        if (tag.func_74764_b(NBT_LOCKED)) {
            this.locked = tag.func_74767_n(NBT_LOCKED);
        }
        if (tag.func_74764_b(NBT_WAS_POWERED)) {
            this.wasPowered = tag.func_74767_n(NBT_WAS_POWERED);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.patternsInventory, 0, tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        if (this.displayName != null) {
            tag.func_74778_a(NBT_DISPLAY_NAME, this.displayName);
        }
        if (this.uuid != null) {
            tag.func_186854_a(NBT_UUID, this.uuid);
        }
        tag.func_74768_a(NBT_MODE, this.mode.ordinal());
        tag.func_74757_a(NBT_LOCKED, this.locked);
        tag.func_74757_a(NBT_WAS_POWERED, this.wasPowered);
        return tag;
    }

    @Override
    public int getUpdateInterval() {
        switch (this.upgrades.getUpgradeCount(2)) {
            case 0: {
                return 10;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public int getMaximumSuccessfulCraftingUpdates() {
        switch (this.upgrades.getUpgradeCount(2)) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        return 1;
    }

    @Override
    @Nullable
    public IItemHandler getConnectedInventory() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return WorldUtils.getItemHandler(proxy.getFacingTile(), proxy.getDirection().func_176734_d());
    }

    @Override
    @Nullable
    public IFluidHandler getConnectedFluidInventory() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return WorldUtils.getFluidHandler(proxy.getFacingTile(), proxy.getDirection().func_176734_d());
    }

    @Override
    @Nullable
    public TileEntity getConnectedTile() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return proxy.getFacingTile();
    }

    @Override
    public List<ICraftingPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    @Nullable
    public IItemHandlerModifiable getPatternInventory() {
        return this.patternsInventory;
    }

    @Override
    public String getName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        TileEntity facing = this.getConnectedTile();
        if (facing instanceof IWorldNameable && ((IWorldNameable)facing).func_70005_c_() != null) {
            return ((IWorldNameable)facing).func_70005_c_();
        }
        if (facing != null) {
            return this.world.func_180495_p(facing.func_174877_v()).func_177230_c().func_149739_a() + ".name";
        }
        return DEFAULT_NAME;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public BlockPos getPosition() {
        return this.pos;
    }

    public CrafterMode getMode() {
        return this.mode;
    }

    public void setMode(CrafterMode mode) {
        this.mode = mode;
        this.wasPowered = false;
        this.locked = false;
        this.markDirty();
    }

    public IItemHandler getPatternItems() {
        return this.patternsInventory;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.patternsInventory, this.upgrades});
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    @Nullable
    public ICraftingPatternContainer getRootContainer() {
        if (this.visited) {
            return null;
        }
        INetworkNode facing = API.instance().getNetworkNodeManager(this.world).getNode(this.pos.func_177972_a(this.getDirection()));
        if (!(facing instanceof ICraftingPatternContainer) || facing.getNetwork() != this.network) {
            return this;
        }
        this.visited = true;
        ICraftingPatternContainer facingContainer = ((ICraftingPatternContainer)((Object)facing)).getRootContainer();
        this.visited = false;
        return facingContainer;
    }

    public Optional<ICraftingPatternContainer> getRootContainerNotSelf() {
        ICraftingPatternContainer root = this.getRootContainer();
        if (root != null && root != this) {
            return Optional.of(root);
        }
        return Optional.empty();
    }

    @Override
    public UUID getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            this.markDirty();
        }
        return this.uuid;
    }

    @Override
    public boolean isLocked() {
        Optional<ICraftingPatternContainer> root = this.getRootContainerNotSelf();
        if (root.isPresent()) {
            return root.get().isLocked();
        }
        switch (this.mode) {
            case IGNORE: {
                return false;
            }
            case SIGNAL_LOCKS_AUTOCRAFTING: {
                return this.world.func_175640_z(this.pos);
            }
            case SIGNAL_UNLOCKS_AUTOCRAFTING: {
                return !this.world.func_175640_z(this.pos);
            }
            case PULSE_INSERTS_NEXT_SET: {
                return this.locked;
            }
        }
        return false;
    }

    @Override
    public void onUsedForProcessing() {
        Optional<ICraftingPatternContainer> root = this.getRootContainerNotSelf();
        if (root.isPresent()) {
            root.get().onUsedForProcessing();
            return;
        }
        if (this.mode == CrafterMode.PULSE_INSERTS_NEXT_SET) {
            this.locked = true;
            this.markDirty();
        }
    }

    public static enum CrafterMode {
        IGNORE,
        SIGNAL_UNLOCKS_AUTOCRAFTING,
        SIGNAL_LOCKS_AUTOCRAFTING,
        PULSE_INSERTS_NEXT_SET;


        public static CrafterMode getById(int id) {
            if (id >= 0 && id < CrafterMode.values().length) {
                return CrafterMode.values()[id];
            }
            return IGNORE;
        }
    }
}

