/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons.subaddons.binniesmods;

import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.power.ComponentProcess;
import binnie.extratrees.blocks.BlockHops;
import binnie.extratrees.machines.brewery.BreweryLogic;
import binnie.extratrees.machines.distillery.DistilleryLogic;
import binnie.extratrees.machines.fruitpress.FruitPressLogic;
import binnie.extratrees.machines.lumbermill.LumbermillLogic;
import com.google.common.collect.Lists;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.styles.ProgressStyleExtraTreesMachine;
import java.util.Collections;
import java.util.List;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class SubAddonTrees
extends AddonBlank {
    @GameRegistry.ObjectHolder(value="extratrees:hops")
    private static final BlockCrops HOPS = null;
    private static final List<Class<? extends ComponentProcess>> machineProcesses = Lists.newArrayList((Object[])new Class[]{LumbermillLogic.class, DistilleryLogic.class, FruitPressLogic.class, BreweryLogic.class});

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        Machine machine;
        TileEntity tile = world.func_175625_s(data.getPos());
        if (tile instanceof TileEntityMachine && (machine = ((TileEntityMachine)tile).getMachine()) != null) {
            for (Class<? extends ComponentProcess> process : machineProcesses) {
                if (!machine.hasComponent(process)) continue;
                ComponentProcess logic = (ComponentProcess)machine.getComponent(process);
                if (!logic.isInProgress()) break;
                probeInfo.progress(Math.round(logic.getProgress()), 100, (IProgressStyle)new ProgressStyleExtraTreesMachine(process));
                break;
            }
        }
    }

    @Override
    public List<IBlockDisplayOverride> getBlockDisplayOverrides() {
        return Collections.singletonList((mode, probeInfo, player, world, blockState, data) -> {
            if (blockState.func_177230_c() == HOPS && blockState.func_177229_b((IProperty)BlockHops.HALF) == BlockHops.HopsHalf.UP) {
                if (Tools.show((ProbeMode)mode, (IProbeConfig.ConfigMode)Config.getRealConfig().getShowModName())) {
                    probeInfo.horizontal().item(data.getPickBlock()).vertical().text(data.getPickBlock().func_82833_r()).text(TextStyleClass.MODNAME + Tools.getModName((Block)HOPS));
                } else {
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(data.getPickBlock()).text(data.getPickBlock().func_82833_r());
                }
                IBlockState belowState = world.func_180495_p(data.getPos().func_177977_b());
                int age = ((BlockHops)blockState.func_177230_c()).func_185527_x(belowState);
                int maxAge = ((BlockHops)blockState.func_177230_c()).func_185526_g();
                if (age == maxAge) {
                    probeInfo.text(TextStyleClass.OK + "Fully grown");
                } else {
                    probeInfo.text(TextStyleClass.LABEL + "Growth: " + TextStyleClass.WARNING + age * 100 / maxAge + "%");
                }
                return true;
            }
            return false;
        });
    }

    @Override
    public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (blockState.func_177230_c() == HOPS && blockState.func_177229_b((IProperty)BlockHops.HALF) == BlockHops.HopsHalf.UP) {
            config.showCropPercentage(IProbeConfig.ConfigMode.NOT);
        }
    }
}

