/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import com.google.common.collect.ImmutableSet;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IHiveTile;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.ITree;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorState;
import forestry.api.farming.FarmDirection;
import forestry.api.genetics.IChromosomeType;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IEntityButterfly;
import forestry.apiculture.items.ItemArmorApiarist;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.apiculture.multiblock.TileAlvearySieve;
import forestry.apiculture.multiblock.TileAlvearySwarmer;
import forestry.apiculture.tiles.TileApiary;
import forestry.apiculture.tiles.TileBeeHousingBase;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.arboriculture.tiles.TileSapling;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.core.ModuleCore;
import forestry.core.blocks.BlockBogEarth;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.Fluids;
import forestry.core.items.ItemArmorNaturalist;
import forestry.core.tiles.TileAnalyzer;
import forestry.core.tiles.TileEngine;
import forestry.core.tiles.TileForestry;
import forestry.core.utils.GeneticsUtil;
import forestry.energy.tiles.TileEngineBiogas;
import forestry.factory.tiles.TileFermenter;
import forestry.factory.tiles.TileMoistener;
import forestry.factory.tiles.TileRaintank;
import forestry.factory.tiles.TileStill;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.tiles.TileFarm;
import io.github.drmanganese.topaddons.TOPAddons;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.api.TOPAddon;
import io.github.drmanganese.topaddons.config.capabilities.IClientOptsCapability;
import io.github.drmanganese.topaddons.elements.forestry.ElementBeeHousingInventory;
import io.github.drmanganese.topaddons.elements.forestry.ElementForestryFarm;
import io.github.drmanganese.topaddons.reference.Colors;
import io.github.drmanganese.topaddons.reference.EnumChip;
import io.github.drmanganese.topaddons.reference.Names;
import io.github.drmanganese.topaddons.styles.ProgressStyleForestryMultiColored;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

@TOPAddon(dependency="forestry")
public class AddonForestry
extends AddonBlank {
    private final List<IErrorState> NORMAL_STATES = Arrays.asList(EnumErrorCode.NO_QUEEN, EnumErrorCode.IS_RAINING, EnumErrorCode.NOT_DAY, EnumErrorCode.FORCED_COOLDOWN, EnumErrorCode.NO_SPECIMEN, EnumErrorCode.NOT_DARK);

    private void addFarmElement(IProbeInfo probeInfo, NonNullList<ItemStack> farmIcons, String oneDirection, boolean showInventory, NonNullList<ItemStack> inventoryStacks, EntityPlayer player) {
        probeInfo.element((IElement)new ElementForestryFarm(AddonForestry.getElementId(player, "farm"), farmIcons, oneDirection, showInventory, inventoryStacks));
    }

    private void addFarmElement(IProbeInfo probeInfo, NonNullList<ItemStack> farmIcons, String oneDirection, EntityPlayer player) {
        this.addFarmElement(probeInfo, farmIcons, oneDirection, false, (NonNullList<ItemStack>)NonNullList.func_191196_a(), player);
    }

    private IProbeInfo addBeeHouseInventory(IProbeInfo probeInfo, boolean isApiary, NonNullList<ItemStack> inventoryStacks, EntityPlayer player) {
        return probeInfo.element((IElement)new ElementBeeHousingInventory(AddonForestry.getElementId(player, "bee_inventory"), isApiary, inventoryStacks));
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tile;
        if (blockState.func_177230_c() == ModuleCore.getBlocks().bogEarth) {
            AddonForestry.textPrefixed(probeInfo, "{*topaddons.forestry:maturity*}", TextStyleClass.WARNING + String.valueOf((Integer)blockState.func_177229_b((IProperty)BlockBogEarth.MATURITY) * 100 / 3) + "%");
        }
        if ((tile = world.func_175625_s(data.getPos())) instanceof TileForestry || tile instanceof TileAlveary || tile instanceof TileTreeContainer || tile instanceof TileFarm) {
            int i;
            TileAnalyzer analyzer;
            ImmutableSet errorStates = tile instanceof IErrorLogicSource ? ((IErrorLogicSource)tile).getErrorLogic().getErrorStates() : ImmutableSet.of();
            if (tile instanceof IBeeHousing && !(tile instanceof IHiveTile)) {
                IBeeHousing beeHousing = (IBeeHousing)tile;
                ItemStack queen = beeHousing.getBeeInventory().getQueen();
                if (!queen.func_190926_b()) {
                    int progress = beeHousing.getBeekeepingLogic().getBeeProgressPercent();
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(queen).progress(progress, 100, (IProgressStyle)new ProgressStyleForestryMultiColored(progress).showText(false));
                    if (mode == ProbeMode.EXTENDED) {
                        AddonForestry.textPrefixed(probeInfo, "{*for.gui.species*}", BeeManager.beeRoot.getMember(queen).getGenome().getSpeciesRoot().getMember(queen).getDisplayName());
                    }
                }
                if (mode == ProbeMode.EXTENDED) {
                    ItemStack stack;
                    int i2;
                    NonNullList inventoryStacks = NonNullList.func_191197_a((int)(tile instanceof TileApiary ? 12 : 9), (Object)ItemStack.field_190927_a);
                    if (tile instanceof TileAlveary) {
                        for (i2 = 0; i2 < 9; ++i2) {
                            stack = ((MultiblockLogicAlveary)((TileAlveary)tile).getMultiblockLogic()).getController().getInternalInventory().func_70301_a(i2);
                            inventoryStacks.set(i2, (Object)(!stack.func_190926_b() ? stack : new ItemStack(Blocks.field_180401_cv)));
                        }
                    } else if (tile instanceof TileBeeHousingBase) {
                        for (i2 = 0; i2 < 9; ++i2) {
                            stack = ((TileBeeHousingBase)tile).getInternalInventory().func_70301_a(i2);
                            inventoryStacks.set(i2, (Object)(!stack.func_190926_b() ? stack : new ItemStack(Blocks.field_180401_cv)));
                        }
                        if (tile instanceof TileApiary) {
                            for (i2 = 9; i2 < 12; ++i2) {
                                stack = ((TileApiary)tile).getInternalInventory().func_70301_a(i2);
                                inventoryStacks.set(i2, (Object)(!stack.func_190926_b() ? stack : new ItemStack(Blocks.field_180401_cv)));
                            }
                        }
                    }
                    this.addBeeHouseInventory(probeInfo, tile instanceof TileApiary, this.reorderBeeInvStacks((NonNullList<ItemStack>)inventoryStacks), player);
                }
            }
            if (tile instanceof TileAnalyzer && !(analyzer = (TileAnalyzer)tile).getIndividualOnDisplay().func_190926_b()) {
                IProbeInfo horizontal = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
                horizontal.item(analyzer.getIndividualOnDisplay());
                horizontal.progress(analyzer.getProgressScaled(100), 100, (IProgressStyle)new ProgressStyleForestryMultiColored(analyzer.getProgressScaled(100)));
            }
            if (tile instanceof TileLeaves) {
                TileLeaves leaves = (TileLeaves)tile;
                if (leaves.hasFruit()) {
                    String ripeness = leaves.getRipeness() >= 1.0f ? TextStyleClass.OK + "{*topaddons.forestry:ripe*}" : TextFormatting.RED + "{*topaddons.forestry:unripe*}";
                    AddonForestry.textPrefixed(probeInfo, "{*topaddons.forestry:fruit*}", leaves.getTree().getGenome().getFruitProvider().getDescription() + " - " + ripeness);
                }
                if (leaves.isPollinated() && GeneticsUtil.hasNaturalistEye((EntityPlayer)player)) {
                    probeInfo.text(TextStyleClass.LABEL + "{*topaddons.forestry:pollinated*}");
                }
            }
            if (tile instanceof TileSapling) {
                ITree tree = ((TileSapling)tile).getTree();
                if (mode == ProbeMode.EXTENDED) {
                    if (tree.isAnalyzed()) {
                        AddonForestry.textPrefixed(probeInfo, "{*for.gui.saplings*}", tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.FERTILITY).getAlleleName());
                        AddonForestry.textPrefixed(probeInfo, "{*for.gui.maturity*}", tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.MATURATION).getAlleleName());
                        AddonForestry.textPrefixed(probeInfo, "{*for.gui.height*}", tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.HEIGHT).getAlleleName());
                        AddonForestry.textPrefixed(probeInfo, "{*for.gui.girth*}", tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.GIRTH).toString());
                        AddonForestry.textPrefixed(probeInfo, "{*for.gui.yield*}", tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.YIELD).getAlleleName());
                        AddonForestry.textPrefixed(probeInfo, "{*for.gui.sappiness*}", tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.SAPPINESS).getAlleleName());
                    } else {
                        probeInfo.text(TextStyleClass.OBSOLETE + "{*for.gui.unknown*}");
                    }
                }
            }
            if (tile instanceof TileFarm) {
                TileFarm farm = (TileFarm)tile;
                EnumFacing facing = player.func_174811_aO();
                NonNullList farmIcons = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
                ItemStack socket = ((MultiblockLogicFarm)farm.getMultiblockLogic()).getController().getSocket(0);
                farmIcons.set(4, (Object)(!socket.func_190926_b() ? socket : new ItemStack(Blocks.field_180401_cv)));
                for (int i3 = 0; i3 < 4; ++i3) {
                    farmIcons.set(i3, (Object)((MultiblockLogicFarm)farm.getMultiblockLogic()).getController().getFarmLogic(FarmDirection.getFarmDirection((EnumFacing)facing)).getIconItemStack());
                    facing = facing.func_176746_e();
                }
                if (mode == ProbeMode.NORMAL) {
                    this.addFarmElement(probeInfo, (NonNullList<ItemStack>)farmIcons, facing.func_176610_l(), player);
                }
                if (mode == ProbeMode.EXTENDED) {
                    NonNullList inventoryStacks = NonNullList.func_191197_a((int)20, (Object)ItemStack.field_190927_a);
                    for (i = 0; i < 20; ++i) {
                        inventoryStacks.set(i, (Object)farm.getInternalInventory().func_70301_a(i));
                    }
                    this.addFarmElement(probeInfo, (NonNullList<ItemStack>)farmIcons, facing.func_176610_l(), true, (NonNullList<ItemStack>)inventoryStacks, player);
                }
            }
            if (tile instanceof TileMoistener) {
                TileMoistener moistener = (TileMoistener)tile;
                int light = world.func_175699_k(data.getPos().func_177984_a());
                int speed = light > 11 ? 0 : (light >= 9 ? 1 : (light >= 7 ? 2 : (light >= 5 ? 3 : 4)));
                AddonForestry.textPrefixed(probeInfo, "{*topaddons.forestry:moistener_speed*}", (speed == 0 ? TextStyleClass.WARNING.toString() : "") + speed);
                NonNullList wheats = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
                wheats.set(0, (Object)new ItemStack(Items.field_151015_O, 1));
                wheats.set(1, (Object)new ItemStack((Item)ModuleCore.getItems().mouldyWheat, 1));
                wheats.set(2, (Object)new ItemStack((Item)ModuleCore.getItems().decayingWheat, 1));
                wheats.set(3, (Object)new ItemStack((Item)ModuleCore.getItems().mulch, 1));
                TextFormatting[] arrowColors = new TextFormatting[]{TextFormatting.DARK_GRAY, TextFormatting.DARK_GRAY, TextFormatting.DARK_GRAY};
                for (i = 0; i < 10; ++i) {
                    ItemStack stack = moistener.getInternalInventory().func_70301_a(i);
                    if (stack.func_190926_b()) continue;
                    for (int j = 0; j < wheats.size(); ++j) {
                        if (!stack.func_77969_a((ItemStack)wheats.get(j))) continue;
                        ((ItemStack)wheats.get(j)).func_190917_f(stack.func_190916_E() - 1);
                        if (i != 9) continue;
                        arrowColors[j] = TextFormatting.WHITE;
                    }
                }
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item((ItemStack)wheats.get(0)).text(arrowColors[0] + "\u25b6").item((ItemStack)wheats.get(1)).text(arrowColors[1] + "\u25b6").item((ItemStack)wheats.get(2)).text(arrowColors[2] + "\u25b6").item((ItemStack)wheats.get(3));
                if (!moistener.getInternalInventory().func_70301_a(11).func_190926_b()) {
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(moistener.getInternalInventory().func_70301_a(11)).progress(15 - moistener.getProductionProgressScaled(15), 15, probeInfo.defaultProgressStyle().showText(false).width(60)).item(moistener.getInternalInventory().func_70301_a(10));
                }
            }
            if (tile instanceof TileEngine) {
                TileEngine engine = (TileEngine)tile;
                if (mode == ProbeMode.EXTENDED) {
                    AddonForestry.textPrefixed(probeInfo, "{*topaddons.forestry:engine_stored*}", engine.getEnergyManager().getEnergyStored() + " RF");
                    AddonForestry.textPrefixed(probeInfo, "{*topaddons.forestry:engine_heat*}", engine.getHeat() / 10 + " C" + (errorStates.contains((Object)EnumErrorCode.FORCED_COOLDOWN) ? TextStyleClass.ERROR + " ({*for.errors.forced_cooldown.desc*})" : ""));
                }
                probeInfo.text(TextStyleClass.LABEL + "{*topaddons:generating*} " + TextStyleClass.INFOIMP + engine.getCurrentOutput() + TextStyleClass.LABEL + " RF/t");
            }
            if (errorStates.size() > 0) {
                probeInfo.text(TextStyleClass.ERROR + "{*topaddons.forestry:errors_nowork*}");
                errorStates.forEach(state -> {
                    if (mode == ProbeMode.EXTENDED || this.NORMAL_STATES.contains(state) && !((IClientOptsCapability)player.getCapability(TOPAddons.OPTS_CAP, null)).getBoolean("forestryReasonCrouch")) {
                        probeInfo.text(TextStyleClass.ERROR + "\u21aa " + TextStyleClass.WARNING + "{*" + state.getUnlocalizedDescription() + "*}");
                    }
                });
            }
        }
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (entity instanceof IEntityButterfly) {
            IButterfly butterfly = ((IEntityButterfly)entity).getButterfly();
            if (!butterfly.isPureBred((IChromosomeType)EnumButterflyChromosome.SPECIES)) {
                AddonForestry.textPrefixed(probeInfo, "{*for.gui.hybrid*}", butterfly.getGenome().getInactiveAllele((IChromosomeType)EnumButterflyChromosome.SPECIES).getAlleleName());
            }
            if (mode == ProbeMode.EXTENDED) {
                if (butterfly.isAnalyzed()) {
                    AddonForestry.textPrefixed(probeInfo, "{*for.gui.size*}", butterfly.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.SIZE).getAlleleName());
                    AddonForestry.textPrefixed(probeInfo, "{*for.gui.speed*}", butterfly.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.SPEED).getAlleleName());
                    AddonForestry.textPrefixed(probeInfo, "{*for.gui.lifespan*}", butterfly.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.LIFESPAN).getAlleleName());
                    AddonForestry.textPrefixed(probeInfo, "{*for.gui.fertility*}", butterfly.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.FERTILITY).getAlleleName());
                } else {
                    probeInfo.text(TextStyleClass.OBSOLETE + "{*for.gui.unknown*}");
                }
            }
        }
    }

    @Override
    public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tile = world.func_175625_s(data.getPos());
        if (tile instanceof IBeeHousing && !(tile instanceof TileAlvearySieve) && !(tile instanceof TileAlvearySwarmer) || tile instanceof TileMoistener || tile instanceof TileFarm) {
            config.showChestContents(IProbeConfig.ConfigMode.NOT);
            config.showChestContentsDetailed(IProbeConfig.ConfigMode.NOT);
        } else {
            config.showChestContents(IProbeConfig.ConfigMode.EXTENDED);
            config.showChestContentsDetailed(IProbeConfig.ConfigMode.EXTENDED);
        }
    }

    @Override
    public void registerElements() {
        this.registerElement("farm", ElementForestryFarm::new);
        this.registerElement("bee_inventory", ElementBeeHousingInventory::new);
    }

    @Override
    public void addFluidColors() {
        for (Fluids fluidDef : Fluids.values()) {
            Fluid fluid = fluidDef.getFluid();
            if (fluid == null) continue;
            Colors.FLUID_NAME_COLOR_MAP.put(fluid.getName(), fluidDef.getParticleColor().hashCode());
        }
    }

    @Override
    public void addTankNames() {
        Names.tankNamesMap.put(TileEngineBiogas.class, new String[]{"Fuel", "Heating", "Burner"});
        Names.tankNamesMap.put(TileStill.class, new String[]{"In", "Out"});
        Names.tankNamesMap.put(TileFermenter.class, new String[]{"Resource Tank", "Product Tank"});
        Names.tankNamesMap.put(TileRaintank.class, new String[]{"Reservoir"});
    }

    @Override
    public Map<Class<? extends ItemArmor>, EnumChip> getSpecialHelmets() {
        HashMap<Class<? extends ItemArmor>, EnumChip> map = new HashMap<Class<? extends ItemArmor>, EnumChip>(2);
        map.put(ItemArmorApiarist.class, EnumChip.STANDARD);
        map.put(ItemArmorNaturalist.class, EnumChip.SPECTACLES);
        return map;
    }

    private NonNullList<ItemStack> reorderBeeInvStacks(NonNullList<ItemStack> old) {
        NonNullList ret = NonNullList.func_191197_a((int)old.size(), (Object)ItemStack.field_190927_a);
        ret.set(0, old.get(0));
        ret.set(1, old.get(1));
        ret.set(2, old.get(7));
        ret.set(3, old.get(6));
        ret.set(4, old.get(8));
        ret.set(5, old.get(2));
        ret.set(6, old.get(5));
        ret.set(7, old.get(3));
        ret.set(8, old.get(4));
        if (old.size() > 9) {
            ret.set(9, old.get(9));
            ret.set(10, old.get(10));
            ret.set(11, old.get(11));
        }
        return ret;
    }
}

