/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import com.elytradev.architecture.common.shape.Shape;
import io.github.drmanganese.topaddons.TOPAddons;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.api.TOPAddon;
import io.github.drmanganese.topaddons.config.capabilities.IClientOptsCapability;
import java.util.Collections;
import java.util.List;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

@TOPAddon(dependency="architecturecraft")
public class AddonArchitectureCraft
extends AddonBlank {
    @GameRegistry.ObjectHolder(value="architecturecraft:shape")
    public static Block SHAPE;

    private static String getShapeBlockName(ItemStack pickBlock) {
        NBTTagCompound tag = pickBlock.func_77978_p();
        Block block = Block.func_149684_b((String)tag.func_74779_i("BaseName"));
        if (block == null) {
            return pickBlock.func_82833_r();
        }
        Item item = Item.func_150898_a((Block)block);
        ItemStack stack = new ItemStack(item, 1, tag.func_74762_e("BaseData"));
        return stack.func_82833_r();
    }

    private static String getShapeName(ItemStack pickBlock) {
        return Shape.forId((int)pickBlock.func_77978_p().func_74762_e((String)"Shape")).title;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (blockState.func_177230_c() == SHAPE) {
            boolean swap = ((IClientOptsCapability)player.getCapability(TOPAddons.OPTS_CAP, null)).getBoolean("swapArchitectureShapeAndMaterial");
            String description = !swap ? AddonArchitectureCraft.getShapeBlockName(data.getPickBlock()) : AddonArchitectureCraft.getShapeName(data.getPickBlock());
            probeInfo.text(TextStyleClass.LABEL + description);
        }
    }

    @Override
    public List<IBlockDisplayOverride> getBlockDisplayOverrides() {
        return Collections.singletonList(new IBlockDisplayOverride(){

            public boolean overrideStandardInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
                if (blockState.func_177230_c() == SHAPE) {
                    String name;
                    boolean swap = ((IClientOptsCapability)player.getCapability(TOPAddons.OPTS_CAP, null)).getBoolean("swapArchitectureShapeAndMaterial");
                    String string = name = swap ? AddonArchitectureCraft.getShapeBlockName(data.getPickBlock()) : AddonArchitectureCraft.getShapeName(data.getPickBlock());
                    if (Tools.show((ProbeMode)mode, (IProbeConfig.ConfigMode)Config.getRealConfig().getShowModName())) {
                        probeInfo.horizontal().item(data.getPickBlock()).vertical().text(name).text(TextStyleClass.MODNAME + Tools.getModName((Block)((ItemBlock)data.getPickBlock().func_77973_b()).func_179223_d()));
                    } else {
                        probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(data.getPickBlock()).text(name);
                    }
                    return true;
                }
                return false;
            }
        });
    }
}

