/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.gui.IGlobalGuiHandler;
import mezz.jei.api.gui.IGuiProperties;
import mezz.jei.api.gui.IGuiScreenHandler;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class GuiScreenHelper {
    private final IngredientRegistry ingredientRegistry;
    private final List<IGlobalGuiHandler> globalGuiHandlers;
    private final List<IAdvancedGuiHandler<?>> advancedGuiHandlers;
    private final Map<Class, IGhostIngredientHandler> ghostIngredientHandlers;
    private final Map<Class, IGuiScreenHandler> guiScreenHandlers;
    private Set<Rectangle> guiExclusionAreas = Collections.emptySet();

    public GuiScreenHelper(IngredientRegistry ingredientRegistry, List<IGlobalGuiHandler> globalGuiHandlers, List<IAdvancedGuiHandler<?>> advancedGuiHandlers, Map<Class, IGhostIngredientHandler> ghostIngredientHandlers, Map<Class, IGuiScreenHandler> guiScreenHandlers) {
        this.ingredientRegistry = ingredientRegistry;
        this.globalGuiHandlers = globalGuiHandlers;
        this.advancedGuiHandlers = advancedGuiHandlers;
        this.ghostIngredientHandlers = ghostIngredientHandlers;
        this.guiScreenHandlers = guiScreenHandlers;
    }

    @Nullable
    public <T extends GuiScreen> IGuiProperties getGuiProperties(@Nullable T guiScreen) {
        if (guiScreen == null) {
            return null;
        }
        IGuiScreenHandler handler = this.guiScreenHandlers.get(guiScreen.getClass());
        if (handler != null) {
            return handler.apply(guiScreen);
        }
        for (Map.Entry<Class, IGuiScreenHandler> entry : this.guiScreenHandlers.entrySet()) {
            IGuiScreenHandler handler2;
            Class guiScreenClass = entry.getKey();
            if (!guiScreenClass.isInstance(guiScreen) || (handler2 = entry.getValue()) == null) continue;
            return handler2.apply(guiScreen);
        }
        return null;
    }

    public boolean updateGuiExclusionAreas() {
        Set<Rectangle> guiAreas = this.getPluginsExclusionAreas();
        if (!guiAreas.equals(this.guiExclusionAreas)) {
            this.guiExclusionAreas = guiAreas;
            return true;
        }
        return false;
    }

    public Set<Rectangle> getGuiExclusionAreas() {
        return this.guiExclusionAreas;
    }

    public boolean isInGuiExclusionArea(int mouseX, int mouseY) {
        return MathUtil.contains(this.guiExclusionAreas, mouseX, mouseY);
    }

    private Set<Rectangle> getPluginsExclusionAreas() {
        GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
        if (guiScreen == null) {
            return Collections.emptySet();
        }
        HashSet<Rectangle> allGuiExtraAreas = new HashSet<Rectangle>();
        if (guiScreen instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)guiScreen;
            List<IAdvancedGuiHandler<GuiContainer>> activeAdvancedGuiHandlers = this.getActiveAdvancedGuiHandlers(guiContainer);
            for (IAdvancedGuiHandler<GuiContainer> advancedGuiHandler : activeAdvancedGuiHandlers) {
                List<Rectangle> guiExtraAreas = advancedGuiHandler.getGuiExtraAreas(guiContainer);
                if (guiExtraAreas == null) continue;
                allGuiExtraAreas.addAll(guiExtraAreas);
            }
        }
        for (IGlobalGuiHandler globalGuiHandler : this.globalGuiHandlers) {
            Collection<Rectangle> guiExtraAreas = globalGuiHandler.getGuiExtraAreas();
            allGuiExtraAreas.addAll(guiExtraAreas);
        }
        return allGuiExtraAreas;
    }

    @Nullable
    public <T extends GuiContainer> IClickedIngredient<?> getPluginsIngredientUnderMouse(T guiContainer, int mouseX, int mouseY) {
        IClickedIngredient<Object> clickedIngredient;
        Object clicked;
        List<IAdvancedGuiHandler<T>> activeAdvancedGuiHandlers = this.getActiveAdvancedGuiHandlers(guiContainer);
        for (IAdvancedGuiHandler<T> advancedGuiHandler : activeAdvancedGuiHandlers) {
            clicked = advancedGuiHandler.getIngredientUnderMouse(guiContainer, mouseX, mouseY);
            clickedIngredient = this.createClickedIngredient(clicked, guiContainer);
            if (clickedIngredient == null) continue;
            return clickedIngredient;
        }
        for (IGlobalGuiHandler globalGuiHandler : this.globalGuiHandlers) {
            clicked = globalGuiHandler.getIngredientUnderMouse(mouseX, mouseY);
            clickedIngredient = this.createClickedIngredient(clicked, guiContainer);
            if (clickedIngredient == null) continue;
            return clickedIngredient;
        }
        return null;
    }

    @Nullable
    public <T extends GuiScreen> IGhostIngredientHandler<T> getGhostIngredientHandler(T guiScreen) {
        IGhostIngredientHandler handler = this.ghostIngredientHandlers.get(guiScreen.getClass());
        if (handler != null) {
            return handler;
        }
        for (Map.Entry<Class, IGhostIngredientHandler> entry : this.ghostIngredientHandlers.entrySet()) {
            IGhostIngredientHandler handler2;
            Class guiScreenClass = entry.getKey();
            if (!guiScreenClass.isInstance(guiScreen) || (handler2 = entry.getValue()) == null) continue;
            return handler2;
        }
        return null;
    }

    @Nullable
    private <T> IClickedIngredient<T> createClickedIngredient(@Nullable T ingredient, GuiContainer guiContainer) {
        if (ingredient != null && this.ingredientRegistry.isValidIngredient(ingredient)) {
            Rectangle area = null;
            Slot slotUnderMouse = guiContainer.getSlotUnderMouse();
            if (ingredient instanceof ItemStack && slotUnderMouse != null && ItemStack.func_77989_b((ItemStack)slotUnderMouse.func_75211_c(), (ItemStack)((ItemStack)ingredient))) {
                area = new Rectangle(slotUnderMouse.field_75223_e, slotUnderMouse.field_75221_f, 16, 16);
            }
            return ClickedIngredient.create(ingredient, area);
        }
        return null;
    }

    private <T extends GuiContainer> List<IAdvancedGuiHandler<T>> getActiveAdvancedGuiHandlers(T guiContainer) {
        ArrayList<IAdvancedGuiHandler<T>> activeAdvancedGuiHandler = new ArrayList<IAdvancedGuiHandler<T>>();
        for (IAdvancedGuiHandler<?> advancedGuiHandler : this.advancedGuiHandlers) {
            Class<?> guiContainerClass = advancedGuiHandler.getGuiContainerClass();
            if (!guiContainerClass.isInstance(guiContainer)) continue;
            IAdvancedGuiHandler<?> advancedGuiHandlerCast = advancedGuiHandler;
            activeAdvancedGuiHandler.add(advancedGuiHandlerCast);
        }
        return activeAdvancedGuiHandler;
    }
}

