/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.proxy;

import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.RegistryManager;
import wanion.lib.common.Dependencies;
import wanion.lib.common.Util;
import wanion.lib.module.AbstractModule;
import wanion.lib.module.ModuleHandler;
import wanion.unidict.Config;
import wanion.unidict.UniDict;
import wanion.unidict.common.SpecificEntryItemStackComparator;
import wanion.unidict.common.SpecificKindItemStackComparator;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.integration.IntegrationModule;
import wanion.unidict.plugin.crafttweaker.UniDictCraftTweakerPlugin;
import wanion.unidict.resource.UniResourceHandler;

public class CommonProxy {
    private UniResourceHandler uniResourceHandler = null;
    public Dependencies<UniDict.IDependency> dependencies = new Dependencies();
    public ModuleHandler moduleHandler = null;

    public void preInit(FMLPreInitializationEvent event) {
        this.moduleHandler = this.searchForModules(this.populateModules(new ModuleHandler()), event.getAsmData());
        this.searchForIntegrations(event.getAsmData());
        if (Loader.isModLoaded((String)"crafttweaker")) {
            UniDictCraftTweakerPlugin.preInit();
        }
        this.uniResourceHandler = new UniResourceHandler();
        this.uniResourceHandler.preInit();
        this.moduleHandler.startModules((FMLStateEvent)event);
    }

    public void init(FMLInitializationEvent event) {
        this.uniResourceHandler.init(event);
        if (Loader.isModLoaded((String)"tconstruct")) {
            this.fixTCon();
        }
        if (Loader.isModLoaded((String)"crafttweaker")) {
            UniDictCraftTweakerPlugin.init();
        }
        this.moduleHandler.startModules((FMLStateEvent)event);
    }

    private void fixTCon() {
        Class<?> recipeUtilClass = null;
        try {
            recipeUtilClass = Class.forName("slimeknights.tconstruct.library.utils.RecipeUtil");
        }
        catch (ClassNotFoundException e) {
            UniDict.getLogger().error("Couldn't find the class: \"slimeknights.tconstruct.library.utils.RecipeUtil\".");
        }
        if (recipeUtilClass == null) {
            return;
        }
        Util.setField(recipeUtilClass, (String)"orePreferences", null, (Object)new String[0]);
        Map preferenceCache = (Map)Util.getField(recipeUtilClass, (String)"preferenceCache", null, Map.class);
        if (preferenceCache != null && preferenceCache.size() > 0) {
            preferenceCache.clear();
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        this.uniResourceHandler.postInit(event);
        this.moduleHandler.startModules((FMLStateEvent)event);
        ForgeRegistry recipeRegistry = RegistryManager.ACTIVE.getRegistry(GameData.RECIPES);
        UniDict.getConfig().recipesToRemove.forEach(arg_0 -> ((ForgeRegistry)recipeRegistry).remove(arg_0));
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        this.moduleHandler.startModules((FMLStateEvent)event);
    }

    private ModuleHandler populateModules(ModuleHandler moduleHandler) {
        Config config = UniDict.getConfig();
        if (!config.libraryMode && config.integrationModule) {
            moduleHandler.addModule((AbstractModule)IntegrationModule.getIntegrationModule());
        }
        return moduleHandler;
    }

    private ModuleHandler searchForModules(ModuleHandler moduleHandler, ASMDataTable asmDataTable) {
        if (UniDict.getConfig().libraryMode) {
            return moduleHandler;
        }
        Set modules = asmDataTable.getAll("wanion.unidict.UniDict$Module");
        modules.forEach(asmData -> {
            try {
                Class<?> mayBeAModule = Class.forName(asmData.getClassName());
                if (mayBeAModule.getSuperclass().isAssignableFrom(AbstractModule.class)) {
                    moduleHandler.addModule((AbstractModule)mayBeAModule.newInstance());
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                UniDict.getLogger().error("Cannot load ", (Object)asmData.getClassName(), (Object)e);
            }
        });
        return moduleHandler;
    }

    private void searchForIntegrations(ASMDataTable asmDataTable) {
        if (UniDict.getConfig().libraryMode) {
            return;
        }
        Set modules = asmDataTable.getAll("wanion.unidict.UniDict$Integration");
        modules.forEach(asmData -> {
            try {
                Class<AbstractIntegrationThread> mayBeAIntegration = Class.forName(asmData.getClassName());
                if (mayBeAIntegration.getSuperclass().isAssignableFrom(AbstractIntegrationThread.class)) {
                    IntegrationModule.getIntegrationModule().registerIntegration(mayBeAIntegration);
                }
            }
            catch (ClassNotFoundException e) {
                UniDict.getLogger().error("Cannot load ", (Object)asmData.getClassName(), (Object)e);
            }
        });
    }

    public void clean() {
        this.uniResourceHandler = null;
        this.moduleHandler = null;
        this.dependencies = null;
        SpecificKindItemStackComparator.kindSpecificComparators = null;
        SpecificEntryItemStackComparator.entrySpecificComparators = null;
    }
}

