/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.ae2wtlib.helpers;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.features.ILocatable;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.tile.networking.TileWireless;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import p455w0rd.ae2wtlib.api.ICustomWirelessTermHandler;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.api.WTGuiObject;

public class WTGuiObjectImpl<O extends IAEStack<O>, C extends IStorageChannel<O>>
extends WTGuiObject<O> {
    private final ItemStack effectiveItem;
    private final IWirelessTermHandler wth;
    private final String encryptionKey;
    private final EntityPlayer myPlayer;
    private IGrid targetGrid;
    private IStorageGrid sg;
    private IMEMonitor<O> itemStorage;
    private IWirelessAccessPoint myWap;
    private double sqRange = Double.MAX_VALUE;
    private double myRange = Double.MAX_VALUE;
    private final int inventorySlot;

    public WTGuiObjectImpl(IWirelessTermHandler wh, ItemStack is, EntityPlayer ep, World w, int x, int y, int z) {
        IGridNode n;
        this.encryptionKey = wh.getEncryptionKey(is);
        this.effectiveItem = is;
        this.myPlayer = ep;
        this.wth = wh;
        this.inventorySlot = x;
        ILocatable obj = null;
        try {
            long encKey = Long.parseLong(this.encryptionKey);
            obj = AEApi.instance().registries().locatable().getLocatableBy(encKey);
        }
        catch (NumberFormatException encKey) {
            // empty catch block
        }
        if (obj != null && obj instanceof IGridHost && (n = ((IGridHost)obj).getGridNode(AEPartLocation.INTERNAL)) != null) {
            this.targetGrid = n.getGrid();
            if (this.targetGrid != null) {
                this.sg = (IStorageGrid)this.targetGrid.getCache(IStorageGrid.class);
                if (this.sg != null && wh instanceof ICustomWirelessTermHandler) {
                    IStorageChannel<?> channel = ((ICustomWirelessTermHandler)wh).getStorageChannel();
                    this.itemStorage = this.sg.getInventory(channel);
                }
            }
        }
    }

    @Override
    public List<IWirelessAccessPoint> getWAPs() {
        ArrayList wapList = Lists.newArrayList();
        if (this.targetGrid != null) {
            IMachineSet tw = this.targetGrid.getMachines(TileWireless.class);
            for (IGridNode n : tw) {
                if (!(n.getMachine() instanceof IWirelessAccessPoint)) continue;
                IWirelessAccessPoint wap = (IWirelessAccessPoint)n.getMachine();
                wapList.add(wap);
            }
        }
        return wapList;
    }

    @Override
    public IWirelessAccessPoint getWAP() {
        if (this.myWap == null && this.targetGrid != null) {
            IMachineSet tw = this.targetGrid.getMachines(TileWireless.class);
            for (IGridNode n : tw) {
                IWirelessAccessPoint wap;
                if (!(n.getMachine() instanceof IWirelessAccessPoint)) continue;
                this.myWap = wap = (IWirelessAccessPoint)n.getMachine();
            }
        }
        return this.myWap;
    }

    @Override
    public IGrid getTargetGrid() {
        return this.targetGrid;
    }

    @Override
    public double getRange() {
        return this.myRange;
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        if (this.sg != null && channel != null) {
            return this.sg.getInventory(channel);
        }
        return null;
    }

    public void addListener(IMEMonitorHandlerReceiver<O> l, Object verificationToken) {
        if (this.itemStorage != null) {
            this.itemStorage.addListener(l, verificationToken);
        }
    }

    public void removeListener(IMEMonitorHandlerReceiver<O> l) {
        if (this.itemStorage != null) {
            this.itemStorage.removeListener(l);
        }
    }

    @Deprecated
    public IItemList<O> getAvailableItems(IItemList<O> out) {
        if (this.itemStorage != null) {
            return this.itemStorage.getAvailableItems(out);
        }
        return out;
    }

    public IItemList<O> getStorageList() {
        if (this.itemStorage != null) {
            return this.itemStorage.getStorageList();
        }
        return null;
    }

    public AccessRestriction getAccess() {
        if (this.itemStorage != null) {
            return this.itemStorage.getAccess();
        }
        return AccessRestriction.NO_ACCESS;
    }

    public boolean isPrioritized(O input) {
        if (this.itemStorage != null) {
            return this.itemStorage.isPrioritized(input);
        }
        return false;
    }

    public boolean canAccept(O input) {
        if (this.itemStorage != null) {
            return this.itemStorage.canAccept(input);
        }
        return false;
    }

    public int getPriority() {
        if (this.itemStorage != null) {
            return this.itemStorage.getPriority();
        }
        return 0;
    }

    public int getSlot() {
        if (this.itemStorage != null) {
            return this.itemStorage.getSlot();
        }
        return 0;
    }

    public boolean validForPass(int i) {
        return this.itemStorage.validForPass(i);
    }

    public O injectItems(O input, Actionable type, IActionSource src) {
        if (this.itemStorage != null) {
            return (O)this.itemStorage.injectItems(input, type, src);
        }
        return input;
    }

    public O extractItems(O request, Actionable mode, IActionSource src) {
        if (this.itemStorage != null) {
            return (O)this.itemStorage.extractItems(request, mode, src);
        }
        return null;
    }

    public IStorageChannel<O> getChannel() {
        if (this.itemStorage != null) {
            return this.itemStorage.getChannel();
        }
        if (this.wth instanceof ICustomWirelessTermHandler) {
            return (IStorageChannel)this.itemStorage;
        }
        return null;
    }

    public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
        if (this.wth != null && this.effectiveItem != null) {
            if (mode == Actionable.SIMULATE) {
                return this.wth.hasPower(this.myPlayer, amt, this.effectiveItem) ? amt : 0.0;
            }
            return this.wth.usePower(this.myPlayer, amt, this.effectiveItem) ? amt : 0.0;
        }
        return 0.0;
    }

    public ItemStack getItemStack() {
        return this.effectiveItem;
    }

    public IConfigManager getConfigManager() {
        return this.wth.getConfigManager(this.effectiveItem);
    }

    @Override
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getActionableNode();
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.NONE;
    }

    @Override
    public IGridNode getActionableNode() {
        boolean ignoreRange = false;
        if (!this.effectiveItem.func_190926_b() && WTApi.instance().isAnyWT(this.effectiveItem) && this.effectiveItem.func_77973_b() instanceof ICustomWirelessTerminalItem) {
            ICustomWirelessTerminalItem item = (ICustomWirelessTerminalItem)this.effectiveItem.func_77973_b();
            ignoreRange = item.checkForBooster(this.effectiveItem);
        }
        return this.getActionableNode(ignoreRange);
    }

    @Override
    public IGridNode getActionableNode(boolean ignoreRange) {
        IGridNode node;
        IGrid grid;
        this.rangeCheck(ignoreRange);
        if (this.myWap != null) {
            if (this.myWap.getActionableNode() != null) {
                return this.myWap.getActionableNode();
            }
            if (this.getTargetGrid() != null) {
                return this.getTargetGrid().getPivot();
            }
        } else if (ignoreRange && (grid = this.getTargetGrid()) != null && (node = grid.getPivot()) != null) {
            return node;
        }
        return null;
    }

    @Override
    public boolean rangeCheck() {
        return this.rangeCheck(false);
    }

    @Override
    public boolean rangeCheck(boolean ignoreRange) {
        this.myRange = Double.MAX_VALUE;
        this.sqRange = Double.MAX_VALUE;
        if (this.targetGrid != null && this.itemStorage != null) {
            if (this.myWap != null) {
                return this.myWap.getGrid() == this.targetGrid && this.testWap(this.myWap);
            }
            IMachineSet tw = this.targetGrid.getMachines(TileWireless.class);
            this.myWap = null;
            for (IGridNode n : tw) {
                IWirelessAccessPoint wap = (IWirelessAccessPoint)n.getMachine();
                if (!this.testWap(wap, ignoreRange)) continue;
                this.myWap = wap;
            }
            return this.myWap != null;
        }
        return false;
    }

    @Override
    public boolean testWap(IWirelessAccessPoint wap) {
        return this.testWap(wap, false);
    }

    @Override
    public boolean testWap(IWirelessAccessPoint wap, boolean ignoreRange) {
        double rangeLimit = wap.getRange();
        rangeLimit *= rangeLimit;
        DimensionalCoord dc = wap.getLocation();
        if (dc.getWorld() == this.myPlayer.func_130014_f_()) {
            double offX = (double)dc.x - this.myPlayer.field_70165_t;
            double offY = (double)dc.y - this.myPlayer.field_70163_u;
            double offZ = (double)dc.z - this.myPlayer.field_70161_v;
            double r = offX * offX + offY * offY + offZ * offZ;
            if (r < rangeLimit && this.sqRange > r && !ignoreRange) {
                if (wap.isActive()) {
                    this.sqRange = r;
                    this.myRange = Math.sqrt(r);
                    return true;
                }
            } else if (wap.isActive() && ignoreRange) {
                this.sqRange = r;
                this.myRange = Math.sqrt(r);
                return true;
            }
        }
        return false;
    }

    public int getInventorySlot() {
        return this.inventorySlot;
    }
}

