/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.endertether;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.darkutils.DarkUtils;
import net.darkhax.darkutils.features.DUFeature;
import net.darkhax.darkutils.features.Feature;
import net.darkhax.darkutils.features.endertether.BlockEnderTether;
import net.darkhax.darkutils.features.endertether.RendererEnderTether;
import net.darkhax.darkutils.features.endertether.TileEntityEnderTether;
import net.darkhax.darkutils.features.material.FeatureMaterial;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@DUFeature(name="Ender Tether", description="A block to redirect ender teleportation")
public class FeatureEnderTether
extends Feature {
    public static final Map<WorldServer, List<TileEntityEnderTether>> LOADED_TETHERS = new HashMap<WorldServer, List<TileEntityEnderTether>>();
    public static Block blockEnderTether;
    protected static boolean affectPlayers;
    public static double tetherRange;

    @Override
    public void onPreInit() {
        blockEnderTether = DarkUtils.REGISTRY.registerBlock((Block)new BlockEnderTether(), "ender_tether");
        GameRegistry.registerTileEntity(TileEntityEnderTether.class, (String)"ender_tether");
    }

    @Override
    public void setupConfiguration(Configuration config) {
        tetherRange = config.getFloat("Tether Range", this.configName, 32.0f, 0.0f, 512.0f, "The range of the effect given by the tether. Distance is measured in blocks.");
        affectPlayers = config.getBoolean("Affect Players", this.configName, true, "Should the Ender Tether catch players using ender teleportation?");
    }

    @Override
    public void onPreRecipe() {
        DarkUtils.REGISTRY.addShapedRecipe("ender_tether", new ItemStack(blockEnderTether), new Object[]{" p ", "oto", Character.valueOf('p'), new ItemStack(FeatureMaterial.itemMaterial, 1, 1), Character.valueOf('o'), "obsidian", Character.valueOf('t'), Blocks.field_150429_aA});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientPreInit() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEnderTether.class, (TileEntitySpecialRenderer)new RendererEnderTether());
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    public static void trackTether(TileEntityEnderTether tile) {
        if (tile.func_145831_w() instanceof WorldServer) {
            FeatureEnderTether.getTethers((WorldServer)tile.func_145831_w()).add(tile);
        }
    }

    public static void stopTrackingTether(TileEntityEnderTether tile) {
        if (tile.func_145831_w() instanceof WorldServer) {
            FeatureEnderTether.getTethers((WorldServer)tile.func_145831_w()).remove((Object)tile);
        }
    }

    public static List<TileEntityEnderTether> getTethers(WorldServer world) {
        return LOADED_TETHERS.computeIfAbsent(world, key -> new ArrayList());
    }

    public static boolean isTracked(TileEntityEnderTether tile) {
        if (tile.func_145831_w() instanceof WorldServer) {
            return FeatureEnderTether.getTethers((WorldServer)tile.func_145831_w()).contains((Object)tile);
        }
        return false;
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof WorldServer) {
            LOADED_TETHERS.remove(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent event) {
        if (event.getEntityLiving() instanceof EntityLivingBase && !event.getEntityLiving().field_70128_L && event.getEntityLiving().func_130014_f_() instanceof WorldServer) {
            for (TileEntityEnderTether tile : FeatureEnderTether.getTethers((WorldServer)event.getEntityLiving().func_130014_f_())) {
                if (!tile.isEntityCloseEnough(event.getEntityLiving())) continue;
                BlockPos pos = tile.func_174877_v();
                event.setTargetX((double)((float)pos.func_177958_n() + 0.5f));
                event.setTargetY((double)pos.func_177956_o());
                event.setTargetZ((double)((float)pos.func_177952_p() + 0.5f));
                break;
            }
        }
    }

    static {
        affectPlayers = true;
        tetherRange = 32.0;
    }
}

