/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.charms;

import java.util.List;
import net.darkhax.bookshelf.util.PlayerUtils;
import net.darkhax.darkutils.DarkUtils;
import net.darkhax.darkutils.features.DUFeature;
import net.darkhax.darkutils.features.Feature;
import net.darkhax.darkutils.features.charms.BaubleCapabilityHandler;
import net.darkhax.darkutils.features.charms.ItemCharm;
import net.darkhax.darkutils.features.charms.ItemNullCharm;
import net.darkhax.darkutils.features.material.FeatureMaterial;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@DUFeature(name="Charms", description="A collection of charms which have unique effects")
public class FeatureCharms
extends Feature {
    public static boolean restrictBaubles = true;
    public static ItemCharm itemAgressionCharm;
    public static ItemCharm itemFocusSash;
    public static ItemCharm itemGluttonyCharm;
    public static ItemCharm itemNullCharm;
    public static ItemCharm itemPortalCharm;
    public static ItemCharm itemSleepCharm;

    @Override
    public void onPreInit() {
        itemAgressionCharm = (ItemCharm)DarkUtils.REGISTRY.registerItem((Item)new ItemCharm(), "charm_agression");
        itemFocusSash = (ItemCharm)DarkUtils.REGISTRY.registerItem((Item)new ItemCharm(), "focus_sash");
        itemGluttonyCharm = (ItemCharm)DarkUtils.REGISTRY.registerItem((Item)new ItemCharm(), "charm_gluttony");
        itemNullCharm = (ItemCharm)DarkUtils.REGISTRY.registerItem((Item)new ItemNullCharm(), "charm_null");
        itemPortalCharm = (ItemCharm)DarkUtils.REGISTRY.registerItem((Item)new ItemCharm(), "charm_portal");
        itemSleepCharm = (ItemCharm)DarkUtils.REGISTRY.registerItem((Item)new ItemCharm(), "charm_sleep");
    }

    @Override
    public void onPreRecipe() {
        DarkUtils.REGISTRY.addShapedRecipe("agression_charm", new ItemStack((Item)itemAgressionCharm), new Object[]{"sgs", "gfg", "wgw", Character.valueOf('s'), "string", Character.valueOf('g'), "nuggetGold", Character.valueOf('f'), Items.field_151078_bh, Character.valueOf('w'), Items.field_151010_B});
        DarkUtils.REGISTRY.addShapedRecipe("focus_sash", new ItemStack((Item)itemFocusSash), new Object[]{" a ", "bcd", " e ", Character.valueOf('a'), Items.field_151065_br, Character.valueOf('b'), new ItemStack(Blocks.field_150325_L, 1, 4), Character.valueOf('c'), Items.field_151064_bs, Character.valueOf('d'), new ItemStack(Blocks.field_150325_L, 1, 14), Character.valueOf('e'), new ItemStack(Blocks.field_150325_L, 1, 1)});
        DarkUtils.REGISTRY.addShapedRecipe("gluttony_charm", new ItemStack((Item)itemGluttonyCharm), new Object[]{" s ", "wgw", " w ", Character.valueOf('s'), "string", Character.valueOf('w'), "cropWheat", Character.valueOf('g'), Items.field_151153_ao});
        DarkUtils.REGISTRY.addShapedRecipe("null_charm", new ItemStack((Item)itemNullCharm), new Object[]{" s ", "uop", Character.valueOf('s'), "string", Character.valueOf('u'), new ItemStack(FeatureMaterial.itemMaterial, 1, 1), Character.valueOf('o'), "obsidian", Character.valueOf('p'), "enderpearl"});
        DarkUtils.REGISTRY.addShapedRecipe("portal_charm_1", new ItemStack((Item)itemPortalCharm), new Object[]{" s ", "oio", " o ", Character.valueOf('s'), "string", Character.valueOf('o'), "obsidian", Character.valueOf('i'), Items.field_151061_bv});
        DarkUtils.REGISTRY.addShapedRecipe("portal_charm_2", new ItemStack((Item)itemPortalCharm), new Object[]{" s ", "oio", " o ", Character.valueOf('s'), "string", Character.valueOf('o'), "obsidian", Character.valueOf('i'), Items.field_185158_cP});
        DarkUtils.REGISTRY.addShapedRecipe("sleep_charm", new ItemStack((Item)itemSleepCharm), new Object[]{"lsl", "sbs", "lsl", Character.valueOf('l'), "leather", Character.valueOf('s'), "stickWood", Character.valueOf('b'), "bed"});
    }

    @Override
    public void setupConfiguration(Configuration config) {
        restrictBaubles = config.getBoolean("restrictBaubles", this.configName, true, "Should charms be restricted to the charm slot in baubles?");
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    @Optional.Method(modid="baubles")
    public void onItemCapability(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() instanceof ItemCharm) {
            event.addCapability(new ResourceLocation("darkutils", "baubles_charm"), (ICapabilityProvider)BaubleCapabilityHandler.INSTANCE);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        EntityPlayer player;
        EntityPlayer entityBase;
        if (event.getEntityLiving() instanceof EntityPlayer && (entityBase = (EntityPlayer)event.getEntityLiving()) instanceof EntityPlayer && itemFocusSash.hasItem(entityBase) && entityBase.func_110143_aJ() >= entityBase.func_110138_aP() && event.getAmount() >= entityBase.func_110143_aJ()) {
            event.setAmount(entityBase.func_110143_aJ() - 1.0f);
            entityBase.func_145747_a((ITextComponent)new TextComponentTranslation("chat.darkutils.focussash", new Object[]{TextFormatting.GREEN}));
        }
        if (event.getSource() != null && event.getSource().func_76346_g() instanceof EntityPlayer && itemAgressionCharm.hasItem(player = (EntityPlayer)event.getSource().func_76346_g())) {
            for (EntityLivingBase entity : player.func_130014_f_().func_72872_a(event.getEntityLiving().getClass(), player.func_174813_aQ().func_72321_a(32.0, 32.0, 32.0))) {
                entity.func_70604_c((EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void onItemUse(LivingEntityUseItemEvent.Tick event) {
        if (event.getEntityLiving() instanceof EntityPlayer && itemGluttonyCharm.hasItem((EntityPlayer)event.getEntityLiving()) && !event.getItem().func_190926_b() && event.getItem().func_77973_b() instanceof ItemFood) {
            event.setDuration(0);
        }
    }

    @SubscribeEvent
    public void onItemPickedUp(EntityItemPickupEvent event) {
        List<ItemStack> charms = itemNullCharm.getItem(event.getEntityPlayer());
        for (ItemStack charm : charms) {
            if (!ItemNullCharm.isBlackListed(event.getItem().func_92059_d(), charm)) continue;
            event.getItem().func_70106_y();
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        if (PlayerUtils.inPortal((EntityPlayer)event.player) && itemPortalCharm.hasItem(event.player)) {
            PlayerUtils.setPortalTimer((EntityPlayer)event.player, (int)100);
        } else if (event.player.func_70608_bn() && itemSleepCharm.hasItem(event.player)) {
            PlayerUtils.setSleepTimer((EntityPlayer)event.player, (int)100);
        }
    }
}

